/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines.tileentity;

import com.teammetallurgy.atum.api.recipe.IAtumRecipeType;
import com.teammetallurgy.atum.api.recipe.recipes.KilnRecipe;
import com.teammetallurgy.atum.blocks.machines.KilnBlock;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnBaseTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumTileEntities;
import com.teammetallurgy.atum.inventory.container.block.KilnContainer;
import com.teammetallurgy.atum.misc.StackHelper;
import com.teammetallurgy.atum.misc.recipe.RecipeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.OreBlock;
import net.minecraft.block.SpongeBlock;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;

public class KilnTileEntity
extends KilnBaseTileEntity
implements ITickableTileEntity {
    public int burnTime;
    public int recipesUsed;
    public int cookTime;
    public int cookTimeTotal;
    public final IIntArray kilnData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return KilnTileEntity.this.burnTime;
                }
                case 1: {
                    return KilnTileEntity.this.recipesUsed;
                }
                case 2: {
                    return KilnTileEntity.this.cookTime;
                }
                case 3: {
                    return KilnTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    KilnTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    KilnTileEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    KilnTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    KilnTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public KilnTileEntity() {
        super(AtumTileEntities.KILN);
    }

    public void func_73660_a() {
        if (!this.isPrimary()) {
            return;
        }
        boolean isBurning = this.isBurning();
        boolean markDirty = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ItemStack fuelStack = (ItemStack)this.inventory.get(4);
            if (this.isBurning() || !fuelStack.func_190926_b() && !this.getInputs().isEmpty()) {
                int i;
                boolean canSmeltAny = false;
                for (i = 0; i <= 4; ++i) {
                    canSmeltAny |= this.canSmelt(i, 5, 8) != -1;
                }
                if (!this.isBurning() && canSmeltAny) {
                    this.recipesUsed = this.burnTime = ForgeHooks.getBurnTime((ItemStack)fuelStack);
                    if (this.isBurning()) {
                        markDirty = true;
                        if (!fuelStack.func_190926_b()) {
                            Item fuelItemCached = fuelStack.func_77973_b();
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190926_b()) {
                                ItemStack containerStack = fuelItemCached.getContainerItem(fuelStack);
                                this.inventory.set(4, (Object)containerStack);
                            }
                        }
                    }
                }
                if (this.isBurning() && canSmeltAny) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = 0;
                        if (!this.isInputEmpty()) {
                            this.cookTimeTotal = this.getCookTime();
                        }
                        for (i = 0; i <= 4; ++i) {
                            this.smeltItem(i, 5, 8);
                        }
                        markDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0 || this.isInputEmpty()) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (isBurning != this.isBurning()) {
                BlockState secondaryState;
                markDirty = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)KilnBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())));
                BlockPos secondaryKilnPos = KilnBlock.getSecondaryKilnFromPrimary(this.field_145850_b, this.field_174879_c);
                if (secondaryKilnPos != null && (secondaryState = this.field_145850_b.func_180495_p(secondaryKilnPos)).func_177230_c() == AtumBlocks.KILN) {
                    this.field_145850_b.func_175656_a(secondaryKilnPos, (BlockState)secondaryState.func_206870_a((IProperty)KilnBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())));
                }
            }
        }
        if (markDirty) {
            this.func_70296_d();
        }
    }

    private boolean isInputEmpty() {
        for (int i = 0; i <= 4; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        if (!this.isPrimary()) {
            KilnBaseTileEntity primary = this.getPrimary();
            if (primary != null) {
                primary.func_70299_a(index, stack);
            }
            return;
        }
        ItemStack slotStack = (ItemStack)this.inventory.get(index);
        boolean isValid = !stack.func_190926_b() && stack.func_77969_a(slotStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index <= 3 && !isValid) {
            this.cookTimeTotal = this.getCookTime();
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        KilnBaseTileEntity primary;
        if (!this.isPrimary() && (primary = this.getPrimary()) != null) {
            return ((KilnTileEntity)primary).isBurning();
        }
        return this.burnTime > 0;
    }

    private int canSmelt(int inputSlot, int outputSlotStart, int outputSlotEnd) {
        if (((ItemStack)this.inventory.get(inputSlot)).func_190926_b()) {
            return -1;
        }
        ItemStack result = this.getSmeltingResult((ItemStack)this.inventory.get(inputSlot));
        if (result.func_190926_b()) {
            return -1;
        }
        for (int outputSlot = outputSlotStart; outputSlot <= outputSlotEnd; ++outputSlot) {
            ItemStack output = (ItemStack)this.inventory.get(outputSlot);
            if (output.func_190926_b()) {
                return outputSlot;
            }
            if (!output.func_77969_a(result)) continue;
            if (output.func_190916_E() + result.func_190916_E() <= this.func_70297_j_() && output.func_190916_E() + result.func_190916_E() <= output.func_77976_d()) {
                return outputSlot;
            }
            if (output.func_190916_E() + result.func_190916_E() > result.func_77976_d()) continue;
            return outputSlot;
        }
        return -1;
    }

    private void smeltItem(int inputSlot, int outputSlotStart, int outputSlotEnd) {
        int outputSlot = this.canSmelt(inputSlot, outputSlotStart, outputSlotEnd);
        if (outputSlot != -1) {
            ItemStack input = (ItemStack)this.inventory.get(inputSlot);
            ItemStack result = this.getSmeltingResult(input);
            ItemStack output = (ItemStack)this.inventory.get(outputSlot);
            if (output.func_190926_b()) {
                this.inventory.set(outputSlot, (Object)result);
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
        }
    }

    @Nonnull
    private ItemStack getSmeltingResult(@Nonnull ItemStack input) {
        if (this.field_145850_b instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
            RecipeManager recipeManager = serverWorld.func_199532_z();
            ArrayList<KilnRecipe> recipes = new ArrayList<KilnRecipe>(RecipeHelper.getRecipes(recipeManager, IAtumRecipeType.KILN));
            recipes.addAll(RecipeHelper.getKilnRecipesFromFurnace(recipeManager));
            for (KilnRecipe kilnRecipe : recipes) {
                for (Ingredient ingredient : kilnRecipe.func_192400_c()) {
                    if (!StackHelper.areIngredientsEqualIgnoreSize(ingredient, input)) continue;
                    return kilnRecipe.func_77572_b(this);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private List<ItemStack> getInputs() {
        return Arrays.asList((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3));
    }

    protected int getCookTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(IAtumRecipeType.KILN, (IInventory)this, this.field_145850_b).map(KilnRecipe::getCookTime).orElse(200);
    }

    @Override
    protected Container func_213906_a(int windowID, @Nonnull PlayerInventory playerInventory) {
        return new KilnContainer(windowID, playerInventory, this.field_174879_c);
    }

    public static boolean canKilnNotSmelt(Ingredient ingredient) {
        int n = 0;
        ItemStack[] itemStackArray = ingredient.func_193365_a();
        int n2 = itemStackArray.length;
        if (n < n2) {
            ItemStack stack = itemStackArray[n];
            return KilnTileEntity.canKilnNotSmelt(stack);
        }
        return true;
    }

    public static boolean canKilnNotSmelt(ItemStack stack) {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return IAtumRecipeType.kilnBlacklist.contains(item.getRegistryName()) || IAtumRecipeType.kilnBlacklist.contains(block.getRegistryName()) || item.func_219971_r() || block instanceof OreBlock || item.func_206844_a(ItemTags.field_219775_L) || item.func_206844_a(Tags.Items.ORES_COAL) || item.func_206844_a(Tags.Items.STORAGE_BLOCKS_COAL) || item.func_206844_a(ItemTags.field_199905_b) || item.func_206844_a(ItemTags.field_200038_h) || item.func_206844_a(Tags.Items.RODS_WOODEN) || item.func_206844_a(ItemTags.field_219770_E) || item.func_206844_a(Tags.Items.ORES) || item.func_206844_a(Tags.Items.INGOTS) && !item.func_206844_a(Tags.Items.INGOTS_BRICK) || item.func_206844_a(Tags.Items.NUGGETS) || item.func_206844_a(Tags.Items.GEMS) || item.func_206844_a(Tags.Items.DUSTS) || item.func_206844_a(Tags.Items.DYES) || item.func_206844_a(Tags.Items.SLIMEBALLS) || item.func_206844_a(Tags.Items.LEATHER) || block instanceof SpongeBlock;
    }

    @Override
    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.recipesUsed = ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.inventory.get(4)));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        return compound;
    }
}

