/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines.tileentity;

import com.teammetallurgy.atum.api.recipe.IAtumRecipeType;
import com.teammetallurgy.atum.api.recipe.recipes.QuernRecipe;
import com.teammetallurgy.atum.blocks.base.tileentity.InventoryBaseTileEntity;
import com.teammetallurgy.atum.blocks.machines.QuernBlock;
import com.teammetallurgy.atum.init.AtumTileEntities;
import com.teammetallurgy.atum.misc.StackHelper;
import com.teammetallurgy.atum.misc.recipe.RecipeHelper;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class QuernTileEntity
extends InventoryBaseTileEntity
implements ITickableTileEntity,
ISidedInventory {
    private int currentRotation;
    private int quernRotations;

    public QuernTileEntity() {
        super(AtumTileEntities.QUERN, 1);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.currentRotation >= 360) {
                this.currentRotation = 0;
                ++this.quernRotations;
            }
            if (this.func_70301_a(0).func_190926_b()) {
                this.quernRotations = 0;
            }
            if (this.quernRotations > 0 && this.field_145850_b instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
                Collection<QuernRecipe> recipes = RecipeHelper.getRecipes(serverWorld.func_199532_z(), IAtumRecipeType.QUERN);
                for (QuernRecipe quernRecipe : recipes) {
                    for (Ingredient ingredient : quernRecipe.func_192400_c()) {
                        if (!StackHelper.areIngredientsEqualIgnoreSize(ingredient, this.func_70301_a(0)) || quernRecipe.getRotations() != this.quernRotations) continue;
                        this.func_70298_a(0, 1);
                        this.outputItems(quernRecipe.func_77572_b(this), this.field_145850_b, this.func_174877_v());
                        this.quernRotations = 0;
                        this.func_70296_d();
                    }
                }
            }
        }
    }

    private void outputItems(@Nonnull ItemStack stack, World world, BlockPos pos) {
        IItemHandler itemHandler;
        LazyOptional capability;
        Direction facing = ((Direction)world.func_180495_p(pos).func_177229_b((IProperty)QuernBlock.FACING)).func_176734_d();
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
        if (tileEntity instanceof ISidedInventory && ((ISidedInventory)tileEntity).func_180463_a(facing).length > 0 || tileEntity instanceof IInventory && ((IInventory)tileEntity).func_70302_i_() > 0) {
            IInventory inventory = (IInventory)tileEntity;
            stack = HopperTileEntity.func_174918_a((IInventory)this, (IInventory)inventory, (ItemStack)stack, (Direction)facing);
        } else if (tileEntity != null && (capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)).isPresent() && (itemHandler = (IItemHandler)capability.orElse(null)) != null) {
            stack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
        }
        if (!stack.func_190926_b()) {
            StackHelper.spawnItemStack(world, (double)facing.func_82601_c() + (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.15, (double)facing.func_82599_e() + (double)pos.func_177952_p() + 0.5, stack);
            if (world.field_72995_K) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 1.0f, 0.4f, false);
            }
        }
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return RecipeHelper.isItemValidForSlot(this.field_145850_b, stack, IAtumRecipeType.QUERN);
    }

    public int getRotations() {
        return this.currentRotation;
    }

    public void setRotations(int rotations) {
        this.currentRotation = rotations;
    }

    @Override
    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        this.currentRotation = compound.func_74762_e("currentRotation");
        this.quernRotations = compound.func_74762_e("quernRotations");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("currentRotation", this.currentRotation);
        compound.func_74768_a("quernRotations", this.quernRotations);
        return compound;
    }

    protected Container func_213906_a(int windowID, @Nonnull PlayerInventory playerInventory) {
        return null;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        super.onDataPacket(manager, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull Direction side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack stack, Direction facing) {
        return false;
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction facing) {
        return false;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(capability, direction);
    }
}

