/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RaStoneBlock
extends BreakableBlock {
    private static final IntegerProperty AGE = BlockStateProperties.field_208168_U;

    public RaStoneBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151645_D).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public int func_200011_d(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return 3;
    }

    @Nonnull
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if ((random.nextInt(3) == 0 || this.shouldDisappear((IBlockReader)world, pos, 4)) && world.func_201696_r(pos) > 11 - (Integer)state.func_177229_b((IProperty)AGE) - state.func_200016_a((IBlockReader)world, pos) && this.slightlyRemove(state, (World)world, pos)) {
            try (BlockPos.PooledMutable mutablePos = BlockPos.PooledMutable.func_185346_s();){
                for (Direction direction : Direction.values()) {
                    mutablePos.func_189533_g((Vec3i)pos).func_189536_c(direction);
                    BlockState stateDirection = world.func_180495_p((BlockPos)mutablePos);
                    if (stateDirection.func_177230_c() != this || this.slightlyRemove(stateDirection, (World)world, (BlockPos)mutablePos)) continue;
                    world.func_205220_G_().func_205360_a((BlockPos)mutablePos, (Object)this, MathHelper.func_76136_a((Random)random, (int)20, (int)40));
                }
            }
        } else {
            world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)random, (int)20, (int)40));
        }
    }

    private boolean slightlyRemove(BlockState state, World world, BlockPos pos) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 3) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            return false;
        }
        this.turnIntoLava(world, pos);
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (block == this && this.shouldDisappear((IBlockReader)world, pos, 2)) {
            this.turnIntoLava(world, pos);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    private boolean shouldDisappear(IBlockReader world, BlockPos pos, int neighborsRequired) {
        int i = 0;
        try (BlockPos.PooledMutable mutablePos = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.values()) {
                mutablePos.func_189533_g((Vec3i)pos).func_189536_c(direction);
                if (world.func_180495_p((BlockPos)mutablePos).func_177230_c() != this || ++i < neighborsRequired) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void turnIntoLava(World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        world.func_190524_a(pos, Blocks.field_150353_l, pos);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{AGE});
    }
}

