/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.trap.tileentity;

import com.teammetallurgy.atum.blocks.trap.TrapBlock;
import com.teammetallurgy.atum.blocks.trap.tileentity.TrapTileEntity;
import com.teammetallurgy.atum.init.AtumTileEntities;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ArrowTrapTileEntity
extends TrapTileEntity {
    private int timer = 80;

    public ArrowTrapTileEntity() {
        super(AtumTileEntities.ARROW_TRAP);
    }

    @Override
    public void func_73660_a() {
        boolean isBurningCheck = this.isBurning();
        boolean isBurning = false;
        boolean canDamageEntity = false;
        World world = this.field_145850_b;
        if (world == null) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
        }
        if (!this.isDisabled && this.isBurning()) {
            Direction facing = (Direction)world.func_180495_p(this.field_174879_c).func_177229_b((IProperty)TrapBlock.FACING);
            Class entity = this.isInsidePyramid ? PlayerEntity.class : LivingEntity.class;
            AxisAlignedBB box = this.getFacingBoxWithRange(facing, 13).func_186664_h(1.0);
            List entities = world.func_217357_a(entity, box);
            for (LivingEntity livingBase : entities) {
                boolean cantSeeEntity;
                BlockRayTraceResult findBlock = this.rayTraceMinMax(world, box, livingBase);
                boolean bl = cantSeeEntity = this.getDistance(findBlock.func_216350_a()) < this.getDistance(livingBase.func_180425_c());
                if (livingBase instanceof PlayerEntity ? !((PlayerEntity)livingBase).func_184812_l_() && !cantSeeEntity : !cantSeeEntity) {
                    if (this.canSee(facing, world, livingBase)) {
                        canDamageEntity = true;
                        if (this.timer != 0) continue;
                        this.timer = 80;
                        this.triggerTrap(world, facing, livingBase);
                        continue;
                    }
                    canDamageEntity = false;
                    continue;
                }
                canDamageEntity = false;
            }
        }
        if (this.isInsidePyramid) {
            this.burnTime = 1;
        }
        if (this.isBurning() && !this.isDisabled && canDamageEntity && !this.isInsidePyramid) {
            --this.burnTime;
        }
        if (!world.field_72995_K && !this.isDisabled) {
            ItemStack fuel = (ItemStack)this.inventory.get(0);
            if (!(!this.isBurning() && fuel.func_190926_b() || this.isBurning())) {
                this.currentItemBurnTime = this.burnTime = ForgeHooks.getBurnTime((ItemStack)fuel) / 10;
                if (this.isBurning()) {
                    isBurning = true;
                    if (!fuel.func_190926_b()) {
                        fuel.func_190918_g(1);
                    }
                }
            }
            if (isBurningCheck != this.isBurning()) {
                isBurning = true;
            }
        }
        if (isBurning) {
            this.func_70296_d();
        }
    }

    private boolean canSee(Direction facing, World world, LivingEntity living) {
        Vec3d livingPos;
        Vec3i dir = facing.func_176730_m();
        Vec3d posDir = new Vec3d((double)(this.field_174879_c.func_177958_n() + dir.func_177958_n()), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() + dir.func_177952_p()));
        return world.func_217299_a(new RayTraceContext(posDir, livingPos = new Vec3d(living.func_226277_ct_(), living.func_226278_cu_() + (double)living.func_70047_e(), living.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)living)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    private BlockRayTraceResult rayTraceMinMax(World world, AxisAlignedBB box, LivingEntity living) {
        Vec3d min = new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        Vec3d max = new Vec3d(box.field_72336_d, box.field_72337_e + 0.05, box.field_72334_f);
        return world.func_217299_a(new RayTraceContext(max, min, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)living));
    }

    private double getDistance(BlockPos position) {
        double d0 = position.func_177958_n() - this.field_174879_c.func_177958_n();
        double d1 = position.func_177956_o() - this.field_174879_c.func_177956_o();
        double d2 = position.func_177952_p() - this.field_174879_c.func_177952_p();
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    @Override
    protected void triggerTrap(World world, Direction facing, LivingEntity livingBase) {
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + world.field_73012_v.nextDouble() * 12.0 / 16.0;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        double randomPos = world.field_73012_v.nextDouble() * 0.6 - 0.3;
        world.func_184134_a(x, (double)this.field_174879_c.func_177956_o(), z, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
        switch (facing) {
            case DOWN: {
                this.fireArrow(world, facing, x - randomPos, y - 0.5, z);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x - randomPos, y - 0.2, z, 0.0, 0.0, 0.0);
                break;
            }
            case UP: {
                this.fireArrow(world, facing, x - randomPos, y + 1.0, z);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x - randomPos, y + 1.0, z, 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                this.fireArrow(world, facing, x - 0.52, y, z + randomPos);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x - 0.52, y, z + randomPos, 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                this.fireArrow(world, facing, x + 0.52, y, z + randomPos);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.52, y, z + randomPos, 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                this.fireArrow(world, facing, x + randomPos, y, z - 0.52);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + randomPos, y, z - 0.52, 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                this.fireArrow(world, facing, x + randomPos, y, z + 0.52);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + randomPos, y, z + 0.52, 0.0, 0.0, 0.0);
            }
        }
    }

    private void fireArrow(World world, Direction facing, double x, double y, double z) {
        if (!world.field_72995_K) {
            ArrowEntity arrow = new ArrowEntity(world, x, y, z);
            arrow.func_70186_c((double)facing.func_82601_c(), (double)((float)facing.func_96559_d() + 0.1f), (double)facing.func_82599_e(), 1.1f, 6.0f);
            world.func_217376_c((Entity)arrow);
        }
    }

    @Override
    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        this.timer = compound.func_74762_e("Timer");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Timer", this.timer);
        return compound;
    }
}

