/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.teammetallurgy.atum.entity.undead.BonestormEntity;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BonestormModel<T extends BonestormEntity>
extends SegmentedModel<T> {
    private ModelRenderer[] bonestormSticks;
    private ModelRenderer bonestormHead = new ModelRenderer((Model)this, 0, 0);
    private final ImmutableList<ModelRenderer> parts;

    public BonestormModel() {
        this.bonestormHead.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.bonestormSticks = new ModelRenderer[12];
        for (int i = 0; i < this.bonestormSticks.length; ++i) {
            this.bonestormSticks[i] = new ModelRenderer((Model)this, 0, 16);
            this.bonestormSticks[i].func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f);
        }
        ImmutableList.Builder partsList = ImmutableList.builder();
        partsList.add((Object)this.bonestormHead);
        partsList.addAll(Arrays.asList(this.bonestormSticks));
        this.parts = partsList.build();
    }

    @Nonnull
    public Iterable<ModelRenderer> func_225601_a_() {
        return this.parts;
    }

    public void setRotationAngles(@Nonnull T bonestorm, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int i;
        float f = ageInTicks * (float)Math.PI * -0.1f;
        for (i = 0; i < 4; ++i) {
            this.bonestormSticks[i].field_78797_d = -2.0f + MathHelper.func_76134_b((float)(((float)(i * 2) + ageInTicks) * 0.25f));
            this.bonestormSticks[i].field_78800_c = MathHelper.func_76134_b((float)f) * 9.0f;
            this.bonestormSticks[i].field_78798_e = MathHelper.func_76126_a((float)f) * 9.0f;
            f += 1.0f;
        }
        f = 0.7853982f + ageInTicks * (float)Math.PI * 0.03f;
        for (i = 4; i < 8; ++i) {
            this.bonestormSticks[i].field_78797_d = 2.0f + MathHelper.func_76134_b((float)(((float)(i * 2) + ageInTicks) * 0.25f));
            this.bonestormSticks[i].field_78800_c = MathHelper.func_76134_b((float)f) * 7.0f;
            this.bonestormSticks[i].field_78798_e = MathHelper.func_76126_a((float)f) * 7.0f;
            f += 1.0f;
        }
        f = 0.47123894f + ageInTicks * (float)Math.PI * -0.05f;
        for (i = 8; i < 12; ++i) {
            this.bonestormSticks[i].field_78797_d = 11.0f + MathHelper.func_76134_b((float)(((float)i * 1.5f + ageInTicks) * 0.5f));
            this.bonestormSticks[i].field_78800_c = MathHelper.func_76134_b((float)f) * 5.0f;
            this.bonestormSticks[i].field_78798_e = MathHelper.func_76126_a((float)f) * 5.0f;
            f += 1.0f;
        }
        this.bonestormHead.field_78796_g = netHeadYaw / 57.295776f;
        this.bonestormHead.field_78795_f = headPitch / 57.295776f;
    }
}

