/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SwirlParticle
extends SpriteTexturedParticle {
    private float scale;

    protected SwirlParticle(World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, IAnimatedSprite spriteSet) {
        super(world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed);
        this.field_187129_i = this.field_187129_i * (double)0.01f + xSpeed;
        this.field_187130_j = this.field_187130_j * (double)0.01f + ySpeed;
        this.field_187131_k = this.field_187131_k * (double)0.01f + zSpeed;
        this.field_187126_f += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187127_g += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187128_h += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.scale = this.field_70544_f;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.func_217566_b(spriteSet);
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo renderInfo, float partialTicks) {
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_70544_f = this.scale * (1.0f - f * f * 0.5f);
        super.func_225606_a_(builder, renderInfo, partialTicks);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Shu
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Shu(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NuitWhite
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public NuitWhite(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NuitBlack
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public NuitBlack(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Isis
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Isis(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SwirlParticle particle = new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.scale = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.05f, (float)0.15f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Horus
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Horus(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Geb
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Geb(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Gas
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Gas(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SwirlParticle particle = new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.scale = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.05f, (float)0.18f);
            particle.field_190017_n = true;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AnubisSkull
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public AnubisSkull(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Anubis
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Anubis(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SwirlParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

