/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.teammetallurgy.atum.blocks.linen.LinenCarpetBlock;
import com.teammetallurgy.atum.blocks.wood.CrateBlock;
import com.teammetallurgy.atum.entity.ai.goal.CamelCaravanGoal;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import com.teammetallurgy.atum.entity.projectile.CamelSpitEntity;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.inventory.container.entity.CamelContainer;
import com.teammetallurgy.atum.world.biome.DeadOasisBiome;
import com.teammetallurgy.atum.world.biome.OasisBiome;
import com.teammetallurgy.atum.world.biome.SandDunesBiome;
import com.teammetallurgy.atum.world.biome.SandPlainsBiome;
import com.teammetallurgy.atum.world.dimension.AtumDimensionType;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SaddleItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.NetworkHooks;

public class CamelEntity
extends AbstractHorseEntity
implements IRangedAttackMob,
INamedContainerProvider {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_COLOR_ID = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> LEFT_CRATE = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> RIGHT_CRATE = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> ARMOR_STACK = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("13a48eeb-c17d-45cc-8163-e7210a6adfc9");
    public static final float CAMEL_RIDING_SPEED_AMOUNT = 0.65f;
    private String textureName;
    private boolean didSpit;
    private CamelEntity caravanHead;
    private CamelEntity caravanTail;

    public CamelEntity(EntityType<? extends CamelEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 3;
        this.field_190688_bE = false;
        this.field_70138_W = 1.6f;
        this.func_110226_cD();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLOR_ID, (Object)-1);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(LEFT_CRATE, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(RIGHT_CRATE, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(ARMOR_STACK, (Object)ItemStack.field_190927_a);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getCamelMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(36.0);
        this.func_110148_a(field_110271_bv).func_111128_a(0.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT nbt) {
        livingdata = super.func_213386_a(world, difficulty, spawnReason, livingdata, nbt);
        int variant = this.getCamelVariantBiome();
        this.setVariant(variant);
        return livingdata;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new CamelCaravanGoal(this, 2.1f));
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 40, 20.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new SpitGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new DefendDesertWolfGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendWolfGoal(this));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191260_dz;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_191254_dE;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191252_dC;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected SoundEvent func_184785_dv() {
        return SoundEvents.field_191260_dz;
    }

    public boolean func_70878_b(@Nonnull AnimalEntity otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof CamelEntity && this.func_110200_cJ() && ((CamelEntity)otherAnimal).func_110200_cJ();
    }

    public CamelEntity createChild(@Nonnull AgeableEntity ageable) {
        CamelEntity camel = new CamelEntity(AtumEntities.CAMEL, this.field_70170_p);
        camel.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)ageable)), SpawnReason.BREEDING, null, null);
        return camel;
    }

    private float getCamelMaxHealth() {
        if (this.func_110248_bS()) {
            return 40.0f;
        }
        return 20.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.textureName = null;
        }
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.textureName = null;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private int getCamelVariantBiome() {
        Biome biome = this.field_70170_p.func_226691_t_(new BlockPos((Entity)this));
        int chance = this.field_70146_Z.nextInt(100);
        if (this.field_70170_p.field_73011_w.func_186058_p() == AtumDimensionType.ATUM) {
            if (biome instanceof SandPlainsBiome) {
                return chance <= 50 ? 0 : 5;
            }
            if (biome instanceof SandDunesBiome) {
                return chance <= 50 ? 0 : 2;
            }
            if (biome instanceof OasisBiome) {
                return chance <= 50 ? 0 : 1;
            }
            if (biome instanceof DeadOasisBiome) {
                return chance <= 50 ? 3 : 4;
            }
            return 0;
        }
        return MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.textureName == null) {
            DyeColor color;
            ItemStack armor;
            String customName;
            this.textureName = String.valueOf(this.getVariant());
            if (this.func_145818_k_() && this.func_200201_e() != null && (customName = this.func_200201_e().func_150254_d()).equalsIgnoreCase("girafi")) {
                this.textureName = "girafi";
            }
            if (!(armor = this.getArmor()).func_190926_b()) {
                ArmorType armorType = ArmorType.getByItemStack(armor);
                this.textureName = this.textureName + "_" + armorType.getName();
            }
            if ((color = this.getColor()) != null) {
                this.textureName = this.textureName + "_" + color.func_176610_l();
            }
        }
        return this.textureName;
    }

    public void func_82196_d(@Nonnull LivingEntity target, float distanceFactor) {
        this.spit(target);
    }

    private void spit(LivingEntity target) {
        CamelSpitEntity camelSpit = new CamelSpitEntity(this.field_70170_p, this);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - camelSpit.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        camelSpit.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 10.0f);
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191255_dF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_217376_c((Entity)camelSpit);
        this.didSpit = true;
    }

    private void setDidSpit(boolean didSpit) {
        this.didSpit = didSpit;
    }

    public boolean func_184776_b() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.78;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float cos = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float sin = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            passenger.func_70107_b(this.func_226277_ct_() + (double)(0.1f * sin), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() - (double)(0.1f * cos));
        }
    }

    public void func_70659_e(float speed) {
        if (this.func_184207_aI()) {
            super.func_70659_e(speed * 0.65f);
        } else {
            super.func_70659_e(speed);
        }
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(CamelEntity camel) {
        this.caravanHead = camel;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public CamelEntity getCaravanHead() {
        return this.caravanHead;
    }

    protected double func_190634_dg() {
        return 2.0;
    }

    protected void func_190679_dD() {
        if (!this.inCaravan() && this.func_70631_g_()) {
            super.func_190679_dD();
        }
    }

    public boolean func_190684_dE() {
        return false;
    }

    @Nullable
    public DyeColor getColor() {
        int color = (Integer)this.field_70180_af.func_187225_a(DATA_COLOR_ID);
        return color == -1 ? null : DyeColor.func_196056_a((int)color);
    }

    private void setColor(@Nullable DyeColor color) {
        this.field_70180_af.func_187227_b(DATA_COLOR_ID, (Object)(color == null ? -1 : color.func_196059_a()));
    }

    public boolean hasColor() {
        return this.getColor() != null;
    }

    protected void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_110232_cE();
            this.setColor(CamelEntity.getCarpetColor(this.field_110296_bG.func_70301_a(2)));
        }
        this.setArmorStack(this.field_110296_bG.func_70301_a(1));
        this.field_70180_af.func_187227_b(LEFT_CRATE, (Object)this.field_110296_bG.func_70301_a(3));
        this.field_70180_af.func_187227_b(RIGHT_CRATE, (Object)this.field_110296_bG.func_70301_a(4));
    }

    private void setArmorStack(@Nonnull ItemStack stack) {
        ArmorType armorType = ArmorType.getByItemStack(stack);
        this.field_70180_af.func_187227_b(ARMOR_STACK, (Object)stack);
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(ARMOR_MODIFIER_UUID);
            int protection = armorType.getProtection();
            if (protection != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(ARMOR_MODIFIER_UUID, "Camel armor bonus", (double)protection, AttributeModifier.Operation.ADDITION).func_111168_a(false));
            }
        }
    }

    @Nonnull
    public ItemStack getArmor() {
        return (ItemStack)this.field_70180_af.func_187225_a(ARMOR_STACK);
    }

    @Nullable
    private static DyeColor getCarpetColor(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block instanceof CarpetBlock ? ((CarpetBlock)block).func_196547_d() : null;
    }

    public boolean isValidCarpet(@Nonnull ItemStack stack) {
        return stack.func_77973_b().func_206844_a(ItemTags.field_200035_e) || Block.func_149634_a((Item)stack.func_77973_b()) instanceof LinenCarpetBlock;
    }

    public boolean func_190682_f(@Nonnull ItemStack stack) {
        return ArmorType.isArmor(stack);
    }

    public boolean func_190677_dK() {
        return true;
    }

    public void func_110199_f(@Nonnull PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)player)) && this.func_110248_bS() && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.writeInt(this.func_145782_y()));
        }
    }

    public Inventory getHorseChest() {
        return this.field_110296_bG;
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_218657_a("ArmorItem", (INBT)this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
        if (!this.field_110296_bG.func_70301_a(2).func_190926_b()) {
            compound.func_218657_a("Carpet", (INBT)this.field_110296_bG.func_70301_a(2).func_77955_b(new CompoundNBT()));
        }
        if (!this.field_110296_bG.func_70301_a(3).func_190926_b()) {
            compound.func_218657_a("CrateLeft", (INBT)this.field_110296_bG.func_70301_a(3).func_77955_b(new CompoundNBT()));
        }
        if (!this.field_110296_bG.func_70301_a(4).func_190926_b()) {
            compound.func_218657_a("CrateRight", (INBT)this.field_110296_bG.func_70301_a(4).func_77955_b(new CompoundNBT()));
        }
        if (this.hasLeftCrate()) {
            ListNBT tagList = new ListNBT();
            for (int slot = this.getNonCrateSize(); slot < this.field_110296_bG.func_70302_i_(); ++slot) {
                ItemStack slotStack = this.field_110296_bG.func_70301_a(slot);
                if (slotStack.func_190926_b()) continue;
                CompoundNBT tagCompound = new CompoundNBT();
                tagCompound.func_74774_a("Slot", (byte)slot);
                slotStack.func_77955_b(tagCompound);
                tagList.add((Object)tagCompound);
            }
            compound.func_218657_a("Items", (INBT)tagList);
        }
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        ItemStack armorStack;
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getCamelMaxHealth());
        if (compound.func_150297_b("Carpet", 10)) {
            this.field_110296_bG.func_70299_a(2, ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Carpet")));
        }
        if (compound.func_150297_b("ArmorItem", 10) && !(armorStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(armorStack)) {
            this.field_110296_bG.func_70299_a(1, armorStack);
        }
        if (compound.func_150297_b("CrateLeft", 10)) {
            this.field_110296_bG.func_70299_a(3, ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("CrateLeft")));
        }
        if (compound.func_150297_b("CrateRight", 10)) {
            this.field_110296_bG.func_70299_a(4, ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("CrateRight")));
        }
        if (this.hasLeftCrate()) {
            ListNBT tagList = compound.func_150295_c("Items", 10);
            this.func_110226_cD();
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tagCompound = tagList.func_150305_b(i);
                int slot = tagCompound.func_74771_c("Slot") & 0xFF;
                if (slot < this.getNonCrateSize() || slot >= this.field_110296_bG.func_70302_i_()) continue;
                this.field_110296_bG.func_70299_a(slot, ItemStack.func_199557_a((CompoundNBT)tagCompound));
            }
        }
        this.func_110232_cE();
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        this.func_110232_cE();
    }

    protected int func_190686_di() {
        return this.getNonCrateSize() + 2 * (this.getInventoryColumns() * 3);
    }

    public int getNonCrateSize() {
        return 5;
    }

    public int getInventoryColumns() {
        return 4;
    }

    public boolean hasLeftCrate() {
        return !((ItemStack)this.field_70180_af.func_187225_a(LEFT_CRATE)).func_190926_b();
    }

    public boolean hasRightCrate() {
        return !((ItemStack)this.field_70180_af.func_187225_a(RIGHT_CRATE)).func_190926_b();
    }

    public boolean func_184645_a(PlayerEntity player, @Nonnull Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(player, hand);
        }
        if (!heldStack.func_190926_b()) {
            boolean eating = this.func_190678_b(player, heldStack);
            if (!eating && !this.func_110248_bS()) {
                if (heldStack.func_111282_a(player, (LivingEntity)this, hand)) {
                    return true;
                }
                this.func_190687_dF();
                return true;
            }
            if (!(eating || this.hasLeftCrate() && this.hasRightCrate() || !(Block.func_149634_a((Item)heldStack.func_77973_b()) instanceof CrateBlock))) {
                this.func_110199_f(player);
                return true;
            }
            if (!eating && this.getArmor().func_190926_b() && this.func_190682_f(heldStack)) {
                this.func_110199_f(player);
                return true;
            }
            if (!eating && this.field_110296_bG.func_70301_a(2).func_190926_b() && this.isValidCarpet(heldStack)) {
                this.func_110199_f(player);
                return true;
            }
            if (!eating && !this.func_70631_g_() && !this.func_110257_ck() && heldStack.func_77973_b() instanceof SaddleItem) {
                this.func_110199_f(player);
                return true;
            }
            if (!eating && heldStack.func_77973_b() == Items.field_151133_ar && !this.func_70631_g_() && this.func_110248_bS()) {
                heldStack.func_190918_g(1);
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                if (heldStack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151117_aB));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151117_aB))) {
                    player.func_71019_a(new ItemStack((IItemProvider)Items.field_151117_aB), false);
                }
                return true;
            }
            if (eating) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldStack.func_190918_g(1);
                }
                return true;
            }
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && player.func_213453_ef()) {
                this.func_110199_f(player);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        if (heldStack.func_111282_a(player, (LivingEntity)this, hand)) {
            return true;
        }
        this.func_110237_h(player);
        return true;
    }

    protected boolean func_190678_b(@Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        boolean isEating = false;
        float healAmount = 0.0f;
        int growthAmount = 0;
        int temperAmount = 0;
        Item item = stack.func_77973_b();
        if (item.func_206844_a(Tags.Items.CROPS_WHEAT)) {
            healAmount = 2.0f;
            growthAmount = 20;
            temperAmount = 3;
        } else if (item == Blocks.field_150407_cf.func_199767_j()) {
            healAmount = 20.0f;
            growthAmount = 180;
        } else if (item == Items.field_151034_e) {
            healAmount = 3.0f;
            growthAmount = 60;
            temperAmount = 3;
        } else if (item == AtumItems.DATE) {
            healAmount = 3.0f;
            growthAmount = 60;
            temperAmount = 3;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                isEating = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151150_bK) {
            healAmount = 4.0f;
            growthAmount = 60;
            temperAmount = 5;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                isEating = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151153_ao || item == AtumItems.GOLDEN_DATE || item == AtumItems.ENCHANTED_GOLDEN_DATE) {
            healAmount = 10.0f;
            growthAmount = 240;
            temperAmount = 10;
            if (!this.func_110248_bS()) {
                this.func_110263_g(player);
            } else if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                isEating = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && healAmount > 0.0f) {
            this.func_70691_i(healAmount);
            isEating = true;
        }
        if (this.func_70631_g_() && growthAmount > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(growthAmount);
            }
            isEating = true;
        }
        if (temperAmount > 0 && (isEating || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            isEating = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(temperAmount);
            }
        }
        if (isEating) {
            this.eatingCamel();
        }
        return isEating;
    }

    private void eatingCamel() {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191253_dD, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public void func_110234_j(boolean tamed) {
        super.func_110234_j(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getCamelMaxHealth());
        this.func_70691_i(this.getCamelMaxHealth());
    }

    @Nullable
    public Container createMenu(int windowID, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new CamelContainer(windowID, playerInventory, this.func_145782_y());
    }

    public static enum ArmorType {
        NONE(0),
        IRON(5, "iron"),
        GOLD(7, "gold"),
        DIAMOND(11, "diamond");

        private final String textureName;
        private final String typeName;
        private final int protection;

        private ArmorType(int armorStrength) {
            this.protection = armorStrength;
            this.typeName = null;
            this.textureName = null;
        }

        private ArmorType(int armorStrength, String typeName) {
            this.protection = armorStrength;
            this.typeName = typeName;
            this.textureName = new ResourceLocation("atum", "textures/entity/armor/camel_armor_" + typeName) + ".png";
        }

        public int getProtection() {
            return this.protection;
        }

        public String getName() {
            return this.typeName;
        }

        public String getTextureName() {
            return this.textureName;
        }

        public static ArmorType getByItemStack(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item == AtumItems.CAMEL_IRON_ARMOR) {
                return IRON;
            }
            if (item == AtumItems.CAMEL_GOLD_ARMOR) {
                return GOLD;
            }
            if (item == AtumItems.CAMEL_DIAMOND_ARMOR) {
                return DIAMOND;
            }
            return NONE;
        }

        public static boolean isArmor(@Nonnull ItemStack stack) {
            return ArmorType.getByItemStack(stack) != NONE;
        }
    }

    static class SpitGoal
    extends HurtByTargetGoal {
        SpitGoal(CamelEntity camel) {
            super((CreatureEntity)camel, new Class[0]);
        }

        public boolean func_75253_b() {
            CamelEntity camel;
            if (this.field_75299_d instanceof CamelEntity && (camel = (CamelEntity)this.field_75299_d).didSpit) {
                camel.setDidSpit(false);
                return false;
            }
            return super.func_75253_b();
        }
    }

    static class DefendWolfGoal
    extends NearestAttackableTargetGoal<WolfEntity> {
        public DefendWolfGoal(CamelEntity camel) {
            super((MobEntity)camel, WolfEntity.class, 16, false, true, entity -> !((WolfEntity)entity).func_70909_n());
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.25;
        }
    }

    static class DefendDesertWolfGoal
    extends NearestAttackableTargetGoal<DesertWolfEntity> {
        DefendDesertWolfGoal(CamelEntity camel) {
            super((MobEntity)camel, DesertWolfEntity.class, 16, false, true, entity -> !((DesertWolfEntity)((Object)entity)).func_70909_n());
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.25;
        }
    }
}

