/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.bandit;

import com.teammetallurgy.atum.entity.ai.goal.OpenAnyDoorGoal;
import com.teammetallurgy.atum.entity.ai.pathfinding.ClimberGroundPathNavigator;
import com.teammetallurgy.atum.entity.bandit.BanditBaseEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class AssassinEntity
extends BanditBaseEntity {
    private final DamageSource ASSASSINATED = new EntityDamageSource("assassinated", (Entity)this);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(AssassinEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private LivingEntity markedTarget;

    public AssassinEntity(EntityType<? extends AssassinEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 12;
        new ClimberGroundPathNavigator((MobEntity)this, world).func_179688_b(true);
        this.setCanPatrol(false);
    }

    @Override
    protected boolean hasSkinVariants() {
        return false;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MarkedForDeathGoal((MobEntity)this, this.markedTarget));
        this.field_70714_bg.func_75776_a(3, (Goal)new OpenAnyDoorGoal((MobEntity)this, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AssassinMeleeAttackGoal((CreatureEntity)this, 1.2, true));
    }

    @Override
    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{BanditBaseEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, UndeadBaseEntity.class, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Nonnull
    protected PathNavigator func_175447_b(@Nonnull World world) {
        return new ClimberGroundPathNavigator((MobEntity)this, world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    private boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    private void setBesideClimbableBlock(boolean isClimbing) {
        byte climbing = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        climbing = isClimbing ? (byte)(climbing | 1) : (byte)(climbing & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull BlockState state) {
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)AtumItems.POISON_DAGGER));
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        if (!super.func_70652_k(entity)) {
            return false;
        }
        if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == AtumItems.POISON_DAGGER && entity instanceof LivingEntity) {
            entity.func_70097_a(this.ASSASSINATED, (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 1));
        }
        return true;
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.markedTarget instanceof PlayerEntity) {
            compound.func_186854_a("MarkedForDeathTarget", this.markedTarget.func_110124_au());
        }
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        PlayerEntity playerEntity = this.field_70170_p.func_217371_b(compound.func_186857_a("MarkedForDeathTarget"));
        if (playerEntity != null) {
            this.markedTarget = playerEntity;
        }
    }

    public static boolean canSpawn(EntityType<? extends BanditBaseEntity> banditBase, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return spawnReason == SpawnReason.EVENT ? world.func_175710_j(pos) && world.func_226658_a_(LightType.BLOCK, pos) <= 8 : BanditBaseEntity.canSpawn(banditBase, world, spawnReason, pos, random);
    }

    public void setMarkedTarget(LivingEntity livingEntity) {
        this.markedTarget = livingEntity;
        this.field_70714_bg.func_75776_a(1, (Goal)new MarkedForDeathGoal((MobEntity)this, livingEntity));
    }

    public static class AssassinMeleeAttackGoal
    extends MeleeAttackGoal {
        public AssassinMeleeAttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean func_75250_a() {
            return this.field_75441_b != null && super.func_75250_a();
        }
    }

    public static class MarkedForDeathGoal
    extends TargetGoal {
        protected LivingEntity markedTarget;

        public MarkedForDeathGoal(MobEntity mob, @Nullable LivingEntity markedTarget) {
            super(mob, false);
            this.markedTarget = markedTarget;
        }

        protected double func_111175_f() {
            return 128.0;
        }

        public boolean func_75253_b() {
            LivingEntity target;
            LivingEntity revenge = this.field_75299_d.func_70643_av();
            if (revenge != null) {
                target = revenge;
            } else {
                target = this.markedTarget;
                if (target == null) {
                    target = this.field_75299_d.func_70638_az();
                }
            }
            if (target == null) {
                return false;
            }
            if (!target.func_70089_S()) {
                return false;
            }
            double distance = this.func_111175_f();
            if (this.field_75299_d.func_70068_e((Entity)target) > distance * distance) {
                return false;
            }
            if (target instanceof PlayerEntity && ((PlayerEntity)target).field_71075_bZ.field_75102_a) {
                return false;
            }
            this.field_75299_d.func_70624_b(target);
            return true;
        }

        public boolean func_75250_a() {
            return this.markedTarget != null;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.markedTarget = null;
            ((AssassinEntity)this.field_75299_d).markedTarget = null;
        }
    }
}

