/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.bandit;

import com.teammetallurgy.atum.entity.ITexture;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import com.teammetallurgy.atum.entity.stone.StoneBaseEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.integration.champion.ChampionsHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BanditBaseEntity
extends PatrollerEntity
implements ITexture {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(BanditBaseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private String texturePath;
    private boolean canPatrol;
    private UUID leadingEntity;

    BanditBaseEntity(EntityType<? extends BanditBaseEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, new BanditPatrolGoal<BanditBaseEntity>(this, 0.7, 0.595));
        this.field_70714_bg.func_75776_a(6, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new AvoidEntityGoal((CreatureEntity)this, DesertWolfEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{BanditBaseEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, UndeadBaseEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, StoneBaseEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
    }

    public boolean func_213358_a(@Nonnull EntityType<?> type) {
        return type != this.func_200600_R() && super.func_213358_a(type);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this.hasSkinVariants()) {
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT nbt) {
        spawnData = this.mobInitialSpawn(spawnData);
        this.func_180483_b(difficulty);
        this.func_180481_a(difficulty);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.func_213630_eb()) {
            this.func_184201_a(EquipmentSlotType.HEAD, BanditBaseEntity.createBanditBanner());
            this.func_184642_a(EquipmentSlotType.HEAD, 1.5f);
        }
        if (spawnReason == SpawnReason.PATROL) {
            this.func_226541_s_(true);
        }
        if (this.hasSkinVariants()) {
            int variant = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)this.getVariantAmount());
            this.setVariant(variant);
        }
        return spawnData;
    }

    public ILivingEntityData mobInitialSpawn(@Nullable ILivingEntityData spawnData) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_184641_n(this.field_70146_Z.nextFloat() < 0.5f);
        return spawnData;
    }

    public static ItemStack createBanditBanner() {
        ItemStack banner = new ItemStack((IItemProvider)Items.field_196191_eg);
        CompoundNBT nbt = banner.func_190925_c("BlockEntityTag");
        ListNBT nbtList = new BannerPattern.Builder().func_222477_a(BannerPattern.BASE, DyeColor.WHITE).func_222477_a(BannerPattern.STRIPE_DOWNLEFT, DyeColor.GRAY).func_222477_a(BannerPattern.STRIPE_DOWNRIGHT, DyeColor.GRAY).func_222477_a(BannerPattern.CROSS, DyeColor.RED).func_222477_a(BannerPattern.FLOWER, DyeColor.BLACK).func_222477_a(BannerPattern.FLOWER, DyeColor.ORANGE).func_222477_a(BannerPattern.CIRCLE_MIDDLE, DyeColor.BLACK).func_222477_a(BannerPattern.CIRCLE_MIDDLE, DyeColor.YELLOW).func_222477_a(BannerPattern.SKULL, DyeColor.BLACK).func_222477_a(BannerPattern.SKULL, DyeColor.WHITE).func_222476_a();
        nbt.func_218657_a("Patterns", (INBT)nbtList);
        banner.func_200302_a(new TranslationTextComponent("block.atum.bandit_banner", new Object[0]).func_211708_a(TextFormatting.GOLD));
        return banner;
    }

    public boolean func_213637_dY() {
        return false;
    }

    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    boolean hasSkinVariants() {
        return true;
    }

    protected int getVariantAmount() {
        return 7;
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    protected boolean canPatrol() {
        return this.canPatrol;
    }

    public void setCanPatrol(boolean canPatrol) {
        this.canPatrol = canPatrol;
    }

    public void setLeadingEntity(BanditBaseEntity leadingEntity) {
        this.leadingEntity = leadingEntity.func_110124_au();
    }

    @Nullable
    public UUID getLeadingEntity() {
        return this.leadingEntity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            ResourceLocation texture;
            String entityName = Objects.requireNonNull(this.func_200600_R().getRegistryName()).func_110623_a();
            if (ChampionsHelper.isChampion((Entity)this) && (texture = ChampionsHelper.getTexture((Entity)this, entityName)) != null) {
                this.texturePath = texture.toString();
                return this.texturePath;
            }
            this.texturePath = this.hasSkinVariants() ? new ResourceLocation("atum", "textures/entity/" + entityName + "_" + this.getVariant()) + ".png" : new ResourceLocation("atum", "textures/entity/" + entityName) + ".png";
        }
        return this.texturePath;
    }

    @Nonnull
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219686_is;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_219689_iv;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219688_iu;
    }

    public boolean func_213380_a(@Nonnull IWorld world, @Nonnull SpawnReason spawnReason) {
        return super.func_213380_a(world, spawnReason);
    }

    public static boolean canSpawn(EntityType<? extends BanditBaseEntity> banditBase, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return (spawnReason == SpawnReason.SPAWNER || pos.func_177956_o() > 62 && world.func_175710_j(pos)) && world.func_226658_a_(LightType.BLOCK, pos) <= 8 && BanditBaseEntity.func_223324_d(banditBase, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random);
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.hasSkinVariants()) {
            compound.func_74768_a("Variant", this.getVariant());
        }
        compound.func_74757_a("CanPatrol", this.canPatrol);
        if (this.leadingEntity != null) {
            compound.func_186854_a("LeadingEntity", this.leadingEntity);
        }
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.hasSkinVariants()) {
            this.setVariant(compound.func_74762_e("Variant"));
        }
        this.canPatrol = compound.func_74767_n("CanPatrol");
        this.leadingEntity = compound.func_186857_a("LeadingEntity");
    }

    public static class BanditPatrolGoal<T extends BanditBaseEntity>
    extends Goal {
        private final T owner;
        private final double patrollerSpeed;
        private final double leaderSpeed;
        private long time;

        public BanditPatrolGoal(T bandit, double patrollerSpeed, double leaderSpeed) {
            this.owner = bandit;
            this.patrollerSpeed = patrollerSpeed;
            this.leaderSpeed = leaderSpeed;
            this.time = -1L;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            boolean flag = ((BanditBaseEntity)this.owner).field_70170_p.func_82737_E() < this.time;
            return ((BanditBaseEntity)this.owner).canPatrol() && ((BanditBaseEntity)this.owner).func_213633_ef() && this.owner.func_70638_az() == null && !this.owner.func_184207_aI() && this.owner.func_213632_ea() && !flag;
        }

        public void func_75246_d() {
            boolean isLeader = this.owner.func_213630_eb();
            PathNavigator navigator = this.owner.func_70661_as();
            if (navigator.func_75500_f()) {
                List<BanditBaseEntity> patrollers = this.getPatrollers();
                if (((BanditBaseEntity)this.owner).func_213633_ef() && patrollers.isEmpty()) {
                    ((BanditBaseEntity)this.owner).func_226541_s_(false);
                } else if (isLeader && this.owner.func_213638_dZ().func_218137_a((IPosition)this.owner.func_213303_ch(), 10.0)) {
                    this.owner.func_213636_ee();
                } else {
                    Vec3d vec3d = new Vec3d((Vec3i)this.owner.func_213638_dZ());
                    Vec3d vec3d1 = this.owner.func_213303_ch();
                    Vec3d vec3d2 = vec3d1.func_178788_d(vec3d);
                    vec3d = vec3d2.func_178785_b(90.0f).func_186678_a(0.4).func_178787_e(vec3d);
                    Vec3d vec3d3 = vec3d.func_178788_d(vec3d1).func_72432_b().func_186678_a(10.0).func_178787_e(vec3d1);
                    BlockPos pos = new BlockPos(vec3d3);
                    if (!navigator.func_75492_a((double)(pos = ((BanditBaseEntity)this.owner).field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos)).func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), isLeader ? this.leaderSpeed : this.patrollerSpeed)) {
                        this.tryMoveTo();
                        this.time = ((BanditBaseEntity)this.owner).field_70170_p.func_82737_E() + 200L;
                    } else if (isLeader) {
                        T leader = this.owner;
                        for (BanditBaseEntity patroller : this.getPatrollers((BanditBaseEntity)leader)) {
                            patroller.func_213631_g(pos);
                        }
                    }
                }
            }
        }

        private List<BanditBaseEntity> getPatrollers() {
            return ((BanditBaseEntity)this.owner).field_70170_p.func_175647_a(BanditBaseEntity.class, this.owner.func_174813_aQ().func_186662_g(24.0), e -> e.func_213634_ed() && !e.func_70028_i((Entity)this.owner));
        }

        private List<BanditBaseEntity> getPatrollers(BanditBaseEntity leader) {
            return ((BanditBaseEntity)this.owner).field_70170_p.func_175647_a(BanditBaseEntity.class, this.owner.func_174813_aQ().func_186662_g(24.0), e -> e.func_213634_ed() && !e.func_70028_i((Entity)this.owner) && ((BanditBaseEntity)e).leadingEntity == leader.func_110124_au());
        }

        private boolean tryMoveTo() {
            Random random = this.owner.func_70681_au();
            BlockPos pos = ((BanditBaseEntity)this.owner).field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(this.owner).func_177982_a(-8 + random.nextInt(16), 0, -8 + random.nextInt(16)));
            return this.owner.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.patrollerSpeed);
        }
    }
}

