/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.efreet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import com.teammetallurgy.atum.entity.ai.brain.ShowWaresTask;
import com.teammetallurgy.atum.entity.ai.brain.SunspeakerTradeTask;
import com.teammetallurgy.atum.entity.efreet.EfreetBaseEntity;
import com.teammetallurgy.atum.entity.efreet.SunspeakerData;
import com.teammetallurgy.atum.entity.undead.PharaohEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumDataSerializer;
import com.teammetallurgy.atum.init.AtumEffects;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.items.LootItem;
import com.teammetallurgy.atum.items.tools.ScepterItem;
import com.teammetallurgy.atum.misc.StackHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.CongregateTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.ExpirePOITask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindWalkTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.GatherPOITask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.JumpOnBedTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.SleepAtHomeTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.UpdateActivityTask;
import net.minecraft.entity.ai.brain.task.WakeUpTask;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToHouseTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.ai.brain.task.WorkTask;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LongSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class SunspeakerEntity
extends EfreetBaseEntity
implements IReputationTracking,
IMerchant {
    private static final DataParameter<SunspeakerData> SUNSPEAKER_DATA = EntityDataManager.func_187226_a(SunspeakerEntity.class, AtumDataSerializer.SUNSPEAKER_DATA);
    @Nullable
    private PlayerEntity customer;
    @Nullable
    protected MerchantOffers offers;
    private int timeUntilReset;
    private boolean leveledUp;
    @Nullable
    private PlayerEntity previousCustomer;
    private final GossipManager gossip = new GossipManager();
    private long lastGossipDecay;
    private int xp;
    private long lastRestock;
    private int restocksToday;
    private long restockTime;
    private static final List<VillagerTrades.ITrade[]> TRADES = Arrays.asList({new ItemsForCoins(32, AtumBlocks.PALM_SAPLING.func_199767_j(), 4, 5, 4, 3), new ItemsForCoins(16, Blocks.field_196800_gd.func_199767_j(), 1, 2, 7, 1), new ItemsForCoins(24, AtumItems.DATE, 14, 16, 3, 2), new ItemsForCoins(24, AtumItems.EMMER_BREAD, 3, 4, 6, 2)}, {new ItemsForCoins(36, AtumItems.LINEN_CLOTH, 5, 10, 5, 3), new ItemsForCoins(48, AtumItems.CAMEL_RAW, 13, 18, 10, 2), new ItemsForCoins(48, AtumItems.SCROLL, 9, 12, 4, 4), new ItemsForCoins(32, AtumItems.ANPUTS_FINGERS_SPORES, 8, 10, 2, 2)}, {new ItemsForCoins(48, Blocks.field_150426_aN.func_199767_j(), 3, 4, 10, 2), new ItemsForCoins(48, Items.field_151057_cb, 1, 2, 16, 1), new ItemsForCoins(64, Items.field_222088_mr, 1, 1, 2, 9), new ItemsForCoins(36, Items.field_151065_br, 4, 5, 16, 4)}, {new ItemsForCoins(48, Items.field_151141_av, 1, 1, 12, 4), new ItemsForCoins(64, AtumItems.ENCHANTED_GOLDEN_DATE, 1, 2, 4, 10), new ItemsForCoins(48, Items.field_151079_bi, 3, 4, 8, 15), new ItemsForCoins(64, AtumItems.DISENCHANTING_SCROLL, 1, 1, 16, 14)});
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220948_i, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220952_m, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_220955_p, (Object)MemoryModuleType.field_225462_q, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y, MemoryModuleType.field_226332_A_});
    private static final ImmutableList<SensorType<? extends Sensor<? super SunspeakerEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_221000_d, (Object)SensorType.field_221001_e, (Object)SensorType.field_221002_f);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<SunspeakerEntity, PointOfInterestType>> HOME = ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (sunspeaker, poi) -> poi == PointOfInterestType.field_221069_q);

    public SunspeakerEntity(EntityType<? extends SunspeakerEntity> entityType, World world) {
        super(entityType, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new CompoundNBT()));
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ScepterItem.getScepter(PharaohEntity.God.RA)));
    }

    protected void func_213333_a(@Nonnull DamageSource source, int looting, boolean recentlyHit) {
    }

    @Nonnull
    public Brain<SunspeakerEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    @Nonnull
    protected Brain<?> func_213364_a(@Nonnull Dynamic<?> dynamic) {
        Brain brain = new Brain(MEMORY_TYPES, SENSOR_TYPES, dynamic);
        this.initBrain((Brain<SunspeakerEntity>)brain);
        return brain;
    }

    public void resetBrain(ServerWorld serverWorld) {
        Brain<SunspeakerEntity> brain = this.func_213375_cj();
        brain.func_218227_b(serverWorld, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        this.initBrain(this.func_213375_cj());
    }

    private void initBrain(Brain<SunspeakerEntity> brain) {
        float speed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() + 0.75f;
        brain.func_218208_a(Activity.field_221365_a, SunspeakerTasks.core(speed));
        brain.func_218224_a(Activity.field_221370_f, SunspeakerTasks.meet(speed), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        brain.func_218208_a(Activity.field_221369_e, SunspeakerTasks.rest(speed));
        brain.func_218208_a(Activity.field_221366_b, SunspeakerTasks.idle(speed));
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        brain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p instanceof ServerWorld) {
            this.resetBrain((ServerWorld)this.field_70170_p);
        }
    }

    @Override
    protected void func_184651_r() {
        super.getSuperGoals();
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        super.func_175456_n();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Override
    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("brain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.hasCustomer() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.leveledUp) {
                    this.levelUp();
                    this.leveledUp = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        if (this.previousCustomer != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221033_e, (Entity)this.previousCustomer, (IReputationTracking)this);
            this.field_70170_p.func_72960_a((Entity)this, (byte)14);
            this.previousCustomer = null;
        }
        super.func_70619_bc();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickGossip();
    }

    @Nullable
    public Entity changeDimension(@Nonnull DimensionType destination, @Nonnull ITeleporter teleporter) {
        this.resetCustomer();
        return super.changeDimension(destination, teleporter);
    }

    @Nullable
    public AgeableEntity func_90011_a(@Nonnull AgeableEntity ageable) {
        SunspeakerEntity sunspeaker = (SunspeakerEntity)AtumEntities.SUNSPEAKER.func_200721_a(this.field_70170_p);
        sunspeaker.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)sunspeaker)), SpawnReason.BREEDING, null, null);
        return sunspeaker;
    }

    public void func_213739_a(@Nonnull IReputationType type, @Nonnull Entity target) {
        if (type == IReputationType.field_221033_e) {
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.TRADING, 2);
        } else if (type == IReputationType.field_221031_c) {
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, 25);
        } else if (type == IReputationType.field_221032_d) {
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.customer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    protected void resetCustomer() {
        this.func_70932_a_(null);
        this.resetAllSpecialPrices();
    }

    @Nonnull
    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213704_a(@Nonnull MerchantOffer offer) {
        offer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.onSunSpeakerTrade(offer);
    }

    public void setSunspeakerData(SunspeakerData sunspeakerData) {
        this.field_70180_af.func_187227_b(SUNSPEAKER_DATA, (Object)sunspeakerData);
    }

    public SunspeakerData getSunspeakerData() {
        return (SunspeakerData)this.field_70180_af.func_187225_a(SUNSPEAKER_DATA);
    }

    protected void onSunSpeakerTrade(MerchantOffer offer) {
        int xpAmount = 3 + this.field_70146_Z.nextInt(4);
        this.xp += offer.func_222210_n();
        this.previousCustomer = this.func_70931_l_();
        if (this.canLevelUp()) {
            this.timeUntilReset = 40;
            this.leveledUp = true;
            xpAmount += 5;
        }
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), xpAmount));
        }
    }

    @Override
    public void func_70604_c(@Nullable LivingEntity livingBase) {
        if (livingBase != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221031_c, (Entity)livingBase, (IReputationTracking)this);
            if (this.func_70089_S() && livingBase instanceof PlayerEntity) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)13);
            }
        }
        super.func_70604_c(livingBase);
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        double chance;
        Entity entity = cause.func_76346_g();
        if (entity != null) {
            this.updateKilledReputation(entity);
        }
        this.runMemoryModule((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220941_b);
        this.runMemoryModule((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220943_d);
        super.func_70645_a(cause);
        this.resetCustomer();
        Entity killer = cause.func_76346_g();
        if (killer instanceof PlayerEntity && (chance = this.field_70146_Z.nextDouble()) <= 0.5) {
            ((PlayerEntity)killer).func_195064_c(new EffectInstance(AtumEffects.MARKED_FOR_DEATH, 1200, 1, false, false, true));
        }
    }

    private void updateKilledReputation(Entity entity) {
        Optional optional;
        if (this.field_70170_p instanceof ServerWorld && (optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_220946_g)).isPresent()) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            ((List)optional.get()).stream().filter(livingEntity -> livingEntity instanceof IReputationTracking).forEach(livingEntity -> serverWorld.func_217489_a(IReputationType.field_221032_d, entity, (IReputationTracking)livingEntity));
        }
    }

    public void runMemoryModule(MemoryModuleType<GlobalPos> globalPosMemory) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer server = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(globalPosMemory).ifPresent(globalPos -> {
                ServerWorld serverWorld = server.func_71218_a(globalPos.func_218177_a());
                PointOfInterestManager poiManager = serverWorld.func_217443_B();
                Optional optional = poiManager.func_219148_c(globalPos.func_218180_b());
                BiPredicate<SunspeakerEntity, PointOfInterestType> predicate = HOME.get(globalPosMemory);
                if (optional.isPresent() && predicate.test(this, (PointOfInterestType)optional.get())) {
                    poiManager.func_219142_b(globalPos.func_218180_b());
                }
            });
        }
    }

    public int getPlayerReputation(PlayerEntity player) {
        return this.gossip.func_220921_a(player.func_110124_au(), gossipType -> true);
    }

    private boolean canLevelUp() {
        int level = this.getSunspeakerData().getLevel();
        return level < 4 && VillagerData.func_221128_d((int)level) && this.xp >= VillagerData.func_221127_c((int)level);
    }

    private void levelUp() {
        this.setSunspeakerData(this.getSunspeakerData().withLevel(this.getSunspeakerData().getLevel() + 1));
        this.populateTradeData();
    }

    public void func_110297_a_(@Nonnull ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.getYesNoSound(!stack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nonnull
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public int func_213708_dV() {
        return this.xp;
    }

    public void func_213702_q(int xp) {
        this.xp = xp;
    }

    public boolean func_213705_dZ() {
        return true;
    }

    @Nonnull
    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    protected SoundEvent getYesNoSound(boolean getYesSound) {
        return getYesSound ? SoundEvents.field_187915_go : SoundEvents.field_187913_gm;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void populateTradeData() {
        VillagerTrades.ITrade[] trade;
        SunspeakerData sunspeakerData = this.getSunspeakerData();
        List<VillagerTrades.ITrade[]> trades = TRADES;
        if (trades != null && !trades.isEmpty() && (trade = trades.get(sunspeakerData.getLevel() - 1)) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.addTrades(merchantoffers, trade, 2);
        }
    }

    private void tickGossip() {
        long gameTime = this.field_70170_p.func_82737_E();
        if (this.lastGossipDecay == 0L) {
            this.lastGossipDecay = gameTime;
        } else if (gameTime >= this.lastGossipDecay + 24000L) {
            this.gossip.func_223538_b();
            this.lastGossipDecay = gameTime;
        }
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_70146_Z.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ITrade trade = newTrades[integer];
            MerchantOffer merchantOffer = trade.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantOffer == null) continue;
            givenMerchantOffers.add((Object)merchantOffer);
        }
    }

    public boolean func_184645_a(PlayerEntity player, @Nonnull Hand hand) {
        boolean isAgressiveTowards;
        ItemStack heldStack = player.func_184586_b(hand);
        boolean nameTag = heldStack.func_77973_b() == Items.field_151057_cb;
        boolean bl = isAgressiveTowards = player.func_110124_au() == this.angerTargetUUID;
        if (nameTag) {
            heldStack.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (!(heldStack.func_77973_b() instanceof LootItem || heldStack.func_77973_b() instanceof SpawnEggItem || !this.func_70089_S() || this.hasCustomer() || this.func_70608_bn() || player.func_226563_dT_())) {
            if (this.func_70631_g_()) {
                this.shakeHead();
                return super.func_184645_a(player, hand);
            }
            boolean noOffers = this.func_213706_dY().isEmpty();
            if (hand == Hand.MAIN_HAND) {
                if (noOffers && !this.field_70170_p.field_72995_K) {
                    this.shakeHead();
                }
                player.func_195066_a(Stats.field_188074_H);
            }
            if (noOffers || isAgressiveTowards) {
                if (isAgressiveTowards && heldStack.func_77973_b() == AtumItems.GOLD_COIN) {
                    this.angerTargetUUID = null;
                    this.func_70604_c(null);
                    this.func_70624_b(null);
                    this.field_70717_bb = null;
                    this.field_70718_bc = 0;
                    this.angerLevel = 0;
                    this.gossip.func_220916_a(player.func_110124_au(), GossipType.MINOR_POSITIVE, 10);
                    return true;
                }
                return super.func_184645_a(player, hand);
            }
            if (!this.field_70170_p.field_72995_K && !this.func_213706_dY().isEmpty()) {
                this.displayMerchantGui(player);
            }
            return true;
        }
        if (heldStack.func_77973_b() instanceof LootItem) {
            LootItem.Type type = LootItem.getType(heldStack.func_77973_b());
            LootItem.Quality quality = LootItem.getQuality(heldStack.func_77973_b());
            if (isAgressiveTowards) {
                this.angerTargetUUID = null;
                this.func_70604_c(null);
                this.func_70624_b(null);
                this.field_70717_bb = null;
                this.field_70718_bc = 0;
                this.angerLevel = 0;
                this.gossip.func_220916_a(player.func_110124_au(), GossipType.MINOR_POSITIVE, 10);
                return true;
            }
            if (quality != LootItem.Quality.DIRTY) {
                double modifier = 1.0;
                if (type == LootItem.Type.NECKLACE) {
                    modifier = 2.0;
                } else if (type == LootItem.Type.BROOCH) {
                    modifier = 2.5;
                } else if (type == LootItem.Type.SCEPTER) {
                    modifier = 3.0;
                } else if (type == LootItem.Type.IDOL) {
                    modifier = 5.0;
                }
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                this.handleRelicTrade(player, hand, modifier, quality);
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return super.func_184645_a(player, hand);
    }

    private void handleRelicTrade(PlayerEntity player, Hand hand, double modifier, LootItem.Quality quality) {
        int amount = 0;
        if (quality == LootItem.Quality.SILVER) {
            amount = (int)((double)amount + modifier);
        } else if (quality == LootItem.Quality.GOLD) {
            amount = (int)((double)amount + modifier * 2.0);
        } else if (quality == LootItem.Quality.SAPPHIRE) {
            amount = (int)((double)amount + modifier * 3.0);
        } else if (quality == LootItem.Quality.RUBY) {
            amount = (int)((double)amount + modifier * 4.0);
        } else if (quality == LootItem.Quality.EMERALD) {
            amount = (int)((double)amount + modifier * 5.0);
        } else if (quality == LootItem.Quality.DIAMOND) {
            amount = (int)((double)amount + modifier * 10.0);
        }
        if (amount > 0) {
            if (this.field_70170_p.field_72995_K) {
                this.addParticles(ParticleTypes.field_197632_y);
                this.func_184185_a(this.func_213714_ea(), this.func_70599_aP(), this.func_70647_i());
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(this.func_213714_ea(), this.func_70599_aP(), this.func_70647_i());
                StackHelper.giveItem(player, hand, new ItemStack((IItemProvider)AtumItems.GOLD_COIN, amount));
                this.func_213739_a(IReputationType.field_221033_e, (Entity)player);
            }
        }
    }

    private void shakeHead() {
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    private void displayMerchantGui(PlayerEntity player) {
        this.recalculateSpecialPricesFor(player);
        this.func_70932_a_(player);
        this.func_213707_a(player, this.func_145748_c_(), this.getSunspeakerData().getLevel());
    }

    private void resetAllSpecialPrices() {
        for (MerchantOffer merchantOffer : this.func_213706_dY()) {
            merchantOffer.func_222220_k();
        }
    }

    public boolean func_223340_ej() {
        return true;
    }

    public void calculateRestock() {
        this.calculateDemandOfOffers();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        this.lastRestock = this.field_70170_p.func_82737_E();
        ++this.restocksToday;
    }

    private boolean hasUsedOffer() {
        for (MerchantOffer merchantOffer : this.func_213706_dY()) {
            if (!merchantOffer.func_226654_r_()) continue;
            return true;
        }
        return false;
    }

    private boolean canRestock() {
        return this.restocksToday == 0 || this.restocksToday < 2 && this.field_70170_p.func_82737_E() > this.lastRestock + 2400L;
    }

    public boolean shouldRestock() {
        long i = this.lastRestock + 12000L;
        long j = this.field_70170_p.func_82737_E();
        boolean flag = j > i;
        long k = this.field_70170_p.func_72820_D();
        if (this.restockTime > 0L) {
            long i1 = k / 24000L;
            long l = this.restockTime / 24000L;
            flag |= i1 > l;
        }
        this.restockTime = k;
        if (flag) {
            this.lastRestock = j;
            this.resetRestock();
        }
        return this.canRestock() && this.hasUsedOffer();
    }

    private void resetRestock() {
        this.restock();
        this.restocksToday = 0;
    }

    private void restock() {
        int i = 2 - this.restocksToday;
        if (i > 0) {
            for (MerchantOffer merchantOffer : this.func_213706_dY()) {
                merchantOffer.func_222203_h();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.calculateDemandOfOffers();
        }
    }

    private void calculateDemandOfOffers() {
        for (MerchantOffer merchantOffer : this.func_213706_dY()) {
            merchantOffer.func_222222_e();
        }
    }

    private void recalculateSpecialPricesFor(PlayerEntity player) {
        int reputation = this.getPlayerReputation(player);
        if (reputation != 0) {
            for (MerchantOffer merchantOffer : this.func_213706_dY()) {
                merchantOffer.func_222207_a(-MathHelper.func_76141_d((float)((float)reputation * merchantOffer.func_222211_m())));
            }
        }
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70608_bn()) {
            return null;
        }
        return this.hasCustomer() ? SoundEvents.field_187914_gn : super.func_184639_G();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addParticles(BasicParticleType particleType) {
        for (int amount = 0; amount < 5; ++amount) {
            double x = this.field_70146_Z.nextGaussian() * 0.02;
            double y = this.field_70146_Z.nextGaussian() * 0.02;
            double z = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)particleType, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), x, y, z);
        }
    }

    public boolean func_184652_a(@Nonnull PlayerEntity player) {
        return false;
    }

    public void func_213342_e(@Nonnull BlockPos pos) {
        super.func_213342_e(pos);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, (Object)LongSerializable.func_223463_a((long)this.field_70170_p.func_82737_E()));
    }

    public void func_213366_dy() {
        super.func_213366_dy();
        this.field_213378_br.func_218205_a(MemoryModuleType.field_226332_A_, (Object)LongSerializable.func_223463_a((long)this.field_70170_p.func_82737_E()));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUNSPEAKER_DATA, (Object)new SunspeakerData(1));
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        MerchantOffers merchantOffers = this.func_213706_dY();
        if (!merchantOffers.isEmpty()) {
            compound.func_218657_a("Offers", (INBT)merchantOffers.func_222199_a());
        }
        compound.func_218657_a("SunspeakerData", (INBT)this.getSunspeakerData().serialize(NBTDynamicOps.field_210820_a));
        compound.func_218657_a("Gossips", (INBT)this.gossip.func_220914_a((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
        compound.func_74768_a("Xp", this.xp);
        compound.func_74772_a("LastRestock", this.lastRestock);
        compound.func_74772_a("LastGossipDecay", this.lastGossipDecay);
        compound.func_74768_a("RestocksToday", this.restocksToday);
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("SunspeakerData", 10)) {
            this.setSunspeakerData(new SunspeakerData(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("SunspeakerData"))));
        }
        if (compound.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        ListNBT gossips = compound.func_150295_c("Gossips", 10);
        this.gossip.func_220918_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)gossips));
        if (compound.func_150297_b("Xp", 3)) {
            this.xp = compound.func_74762_e("Xp");
        }
        this.lastRestock = compound.func_74763_f("LastRestock");
        this.lastGossipDecay = compound.func_74763_f("LastGossipDecay");
        if (this.field_70170_p instanceof ServerWorld) {
            this.resetBrain((ServerWorld)this.field_70170_p);
        }
        this.restocksToday = compound.func_74762_e("RestocksToday");
    }

    static class ItemsForCoins
    implements VillagerTrades.ITrade {
        private final int price;
        private final Item buyingItem;
        private final int maxUses;
        private final int givenExp;
        private final int minAmount;
        private final int maxAmount;

        ItemsForCoins(int price, Item item, int minAmount, int maxAmount, int maxUses, int givenExp) {
            this.buyingItem = item;
            this.price = price;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        @Nullable
        public MerchantOffer func_221182_a(@Nonnull Entity trader, @Nonnull Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)AtumItems.GOLD_COIN, this.price), new ItemStack((IItemProvider)this.buyingItem, MathHelper.func_76136_a((Random)new Random(), (int)this.minAmount, (int)this.maxAmount)), this.maxUses, this.givenExp, 0.1f);
        }
    }

    public static class SunspeakerTasks {
        public static ImmutableList<Pair<Integer, ? extends Task<? super SunspeakerEntity>>> core(float speed) {
            return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SwimTask(0.4f, 0.8f)), (Object)Pair.of((Object)0, (Object)new InteractWithDoorTask()), (Object)Pair.of((Object)0, (Object)new LookTask(45, 90)), (Object)Pair.of((Object)0, (Object)new WakeUpTask()), (Object)Pair.of((Object)1, (Object)new WalkToTargetTask(200)), (Object)Pair.of((Object)2, (Object)((Object)new SunspeakerTradeTask(speed))), (Object)Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221069_q, MemoryModuleType.field_220941_b, false)), (Object)Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d, true)));
        }

        public static ImmutableList<Pair<Integer, ? extends Task<? super SunspeakerEntity>>> meet(float speed) {
            return ImmutableList.of((Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WorkTask(MemoryModuleType.field_220943_d, 40), (Object)2), (Object)Pair.of((Object)new CongregateTask(), (Object)2)))), (Object)Pair.of((Object)10, (Object)((Object)new ShowWaresTask(400, 1600))), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d)), SunspeakerTasks.lookAtMany(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
        }

        public static ImmutableList<Pair<Integer, ? extends Task<? super SunspeakerEntity>>> rest(float speed) {
            return ImmutableList.of((Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.field_221069_q, MemoryModuleType.field_220941_b)), (Object)Pair.of((Object)3, (Object)new SleepAtHomeTask()), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new WalkToHouseTask(speed), (Object)1), (Object)Pair.of((Object)new WalkRandomlyTask(speed), (Object)4), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), SunspeakerTasks.lookAtPlayerOrSunspeaker(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
        }

        public static ImmutableList<Pair<Integer, ? extends Task<? super SunspeakerEntity>>> idle(float p_220641_1_) {
            return ImmutableList.of((Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_200756_av, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)p_220641_1_, (int)2), (Object)2), (Object)Pair.of((Object)new FindWalkTargetTask(p_220641_1_), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(p_220641_1_, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(p_220641_1_), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)3, (Object)((Object)new ShowWaresTask(400, 1600))), SunspeakerTasks.lookAtMany(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
        }

        private static Pair<Integer, Task<LivingEntity>> lookAtMany() {
            return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(AtumEntities.SUNSPEAKER, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)2))));
        }

        private static Pair<Integer, Task<LivingEntity>> lookAtPlayerOrSunspeaker() {
            return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(AtumEntities.SUNSPEAKER, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)8))));
        }
    }
}

