/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.projectile.arrow;

import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class TefnutsCallEntity
extends AbstractArrowEntity {
    protected ItemStack thrownStack = new ItemStack((IItemProvider)AtumItems.TEFNUTS_CALL);
    private boolean dealtDamage;
    public int returningTicks;

    public TefnutsCallEntity(FMLPlayMessages.SpawnEntity spawnPacket, World world) {
        this(AtumEntities.TEFNUTS_CALL, world);
    }

    public TefnutsCallEntity(EntityType<? extends TefnutsCallEntity> entityType, World world) {
        super(entityType, world);
    }

    public TefnutsCallEntity(World world, LivingEntity shooter, @Nonnull ItemStack stack) {
        super(AtumEntities.TEFNUTS_CALL, shooter, world);
        this.thrownStack = stack.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public TefnutsCallEntity(World world, double x, double y, double z) {
        super(AtumEntities.TEFNUTS_CALL, x, y, z, world);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_180427_aV() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(@Nonnull Vec3d startVec, @Nonnull Vec3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_212360_k();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_212360_k();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null && this.shouldReturnToThrower()) {
            this.func_203045_n(true);
            Vec3d vec3d = new Vec3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
            this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vec3d.field_72448_b * 0.015, this.func_226281_cx_());
            if (this.field_70170_p.field_72995_K) {
                this.field_70137_T = this.func_226278_cu_();
            }
            double d0 = 0.05;
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d.func_72432_b().func_186678_a(d0)));
            if (this.returningTicks == 0) {
                this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
            }
            ++this.returningTicks;
        }
        super.func_70071_h_();
    }

    protected void func_213868_a(@Nonnull EntityRayTraceResult rayTraceResult) {
        Entity entity = rayTraceResult.func_216348_a();
        Entity shooter = this.func_212360_k();
        if (shooter != entity) {
            Vec3d motion = this.func_213322_ci();
            float f = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72448_b * motion.field_72448_b + motion.field_72449_c * motion.field_72449_c));
            int i = MathHelper.func_76143_f((double)((double)f * this.func_70242_d()));
            if (this.func_70241_g()) {
                i += this.field_70146_Z.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = shooter == null ? DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this) : DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)shooter);
            if (this.func_70027_ad() && !(entity instanceof EndermanEntity)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, (float)i)) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (shooter instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)livingEntity, (Entity)shooter);
                        EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)shooter), (Entity)livingEntity);
                    }
                    this.func_184548_a(livingEntity);
                    if (livingEntity != shooter && livingEntity instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                    }
                }
                if (this.field_70170_p instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
                    BlockPos entityPos = this.func_180425_c();
                    if (this.field_70170_p.func_226660_f_(entityPos)) {
                        LightningBoltEntity lightningBolt = new LightningBoltEntity(this.field_70170_p, (double)entityPos.func_177958_n() + 0.5, (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p() + 0.5, false);
                        lightningBolt.func_204809_d(shooter instanceof ServerPlayerEntity ? (ServerPlayerEntity)shooter : null);
                        serverWorld.func_217468_a(lightningBolt);
                    }
                }
                this.func_184185_a(SoundEvents.field_203275_iq, 4.0f, 1.0f);
            }
        }
    }

    @Nonnull
    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(@Nonnull PlayerEntity player) {
        Entity entity = this.func_212360_k();
        if (entity == null || entity.func_110124_au() == player.func_110124_au()) {
            super.func_70100_b_(player);
        }
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("TefnutsCall", 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("TefnutsCall"));
        }
        this.dealtDamage = compound.func_74767_n("DealtDamage");
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("TefnutsCall", (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
    }

    public void func_225516_i_() {
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED) {
            super.func_225516_i_();
        }
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }
}

