/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.teammetallurgy.atum.misc.AtumRegistry;
import com.teammetallurgy.atum.world.biome.AtumBiome;
import com.teammetallurgy.atum.world.biome.DeadOasisBiome;
import com.teammetallurgy.atum.world.biome.DeadwoodForestBiome;
import com.teammetallurgy.atum.world.biome.DriedRiverBiome;
import com.teammetallurgy.atum.world.biome.LimestoneCragsBiome;
import com.teammetallurgy.atum.world.biome.LimestoneMountainsBiome;
import com.teammetallurgy.atum.world.biome.OasisBiome;
import com.teammetallurgy.atum.world.biome.SandDunesBiome;
import com.teammetallurgy.atum.world.biome.SandHillsBiome;
import com.teammetallurgy.atum.world.biome.SandPlainsBiome;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="atum")
public class AtumBiomes {
    public static final AtumBiome DEAD_OASIS = AtumRegistry.registerBiome(new DeadOasisBiome(), "dead_oasis");
    public static final AtumBiome DEADWOOD_FOREST = AtumRegistry.registerBiome(new DeadwoodForestBiome(), "deadwood_forest");
    public static final AtumBiome DRIED_RIVER = AtumRegistry.registerBiome(new DriedRiverBiome(), "dried_river");
    public static final AtumBiome LIMESTONE_CRAGS = AtumRegistry.registerBiome(new LimestoneCragsBiome(), "limestone_crags");
    public static final AtumBiome LIMESTONE_MOUNTAINS = AtumRegistry.registerBiome(new LimestoneMountainsBiome(), "limestone_mountains");
    public static final AtumBiome OASIS = AtumRegistry.registerBiome(new OasisBiome(), "oasis");
    public static final AtumBiome SAND_DUNES = AtumRegistry.registerBiome(new SandDunesBiome(), "sand_dunes");
    public static final AtumBiome SAND_HILLS = AtumRegistry.registerBiome(new SandHillsBiome(), "sand_hills");
    public static final AtumBiome SAND_PLAINS = AtumRegistry.registerBiome(new SandPlainsBiome(), "sand_plains");

    public static void addBiomeTags() {
        for (AtumBiome biome : AtumRegistry.BIOMES) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeTags.ATUM});
            if (biome == OASIS) continue;
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY});
        }
        BiomeDictionary.addTypes((Biome)DEAD_OASIS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes((Biome)DEADWOOD_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)DRIED_RIVER, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER});
        BiomeDictionary.addTypes((Biome)LIMESTONE_CRAGS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes((Biome)LIMESTONE_MOUNTAINS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.addTypes((Biome)OASIS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeTags.OASIS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes((Biome)SAND_DUNES, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes((Biome)SAND_HILLS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes((Biome)SAND_PLAINS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
    }

    public static class BiomeTags {
        public static final BiomeDictionary.Type ATUM = BiomeDictionary.Type.getType((String)"ATUM", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        public static final BiomeDictionary.Type OASIS = BiomeDictionary.Type.getType((String)"OASIS", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    }
}

