/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.teammetallurgy.atum.client.particle.DropParticle;
import com.teammetallurgy.atum.client.particle.LightSparkleParticle;
import com.teammetallurgy.atum.client.particle.MontuParticle;
import com.teammetallurgy.atum.client.particle.RaFireParticle;
import com.teammetallurgy.atum.client.particle.SwirlParticle;
import com.teammetallurgy.atum.client.particle.TefnutParticle;
import com.teammetallurgy.atum.misc.AtumRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="atum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="atum")
public class AtumParticles {
    public static final BasicParticleType ANUBIS = AtumRegistry.registerParticle("anubis");
    public static final BasicParticleType ANUBIS_SKULL = AtumRegistry.registerParticle("anubis_skull");
    public static final BasicParticleType GAS = AtumRegistry.registerParticle("gas");
    public static final BasicParticleType GEB = AtumRegistry.registerParticle("geb");
    public static final BasicParticleType HORUS = AtumRegistry.registerParticle("horus");
    public static final BasicParticleType ISIS = AtumRegistry.registerParticle("isis");
    public static final BasicParticleType LIGHT_SPARKLE = AtumRegistry.registerParticle("light_sparkle");
    public static final BasicParticleType MONTU = AtumRegistry.registerParticle("montu");
    public static final BasicParticleType NUIT_BLACK = AtumRegistry.registerParticle("nuit_black");
    public static final BasicParticleType NUIT_WHITE = AtumRegistry.registerParticle("nuit_white");
    public static final BasicParticleType RA_FIRE = AtumRegistry.registerParticle("ra_fire");
    public static final BasicParticleType SETH = AtumRegistry.registerParticle("seth");
    public static final BasicParticleType SHU = AtumRegistry.registerParticle("shu");
    public static final BasicParticleType TAR = AtumRegistry.registerParticle("tar");
    public static final BasicParticleType TEFNUT = AtumRegistry.registerParticle("tefnut");
    public static final BasicParticleType TEFNUT_DROP = AtumRegistry.registerParticle("tefnut_drop");
    public static final BasicParticleType EMPTY = AtumRegistry.registerParticle("empty");

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        AtumParticles.registerFactory(ANUBIS, SwirlParticle.Anubis::new);
        AtumParticles.registerFactory(ANUBIS_SKULL, SwirlParticle.AnubisSkull::new);
        AtumParticles.registerFactory(GAS, SwirlParticle.Gas::new);
        AtumParticles.registerFactory(GEB, SwirlParticle.Geb::new);
        AtumParticles.registerFactory(HORUS, SwirlParticle.Horus::new);
        AtumParticles.registerFactory(ISIS, SwirlParticle.Isis::new);
        AtumParticles.registerFactory(LIGHT_SPARKLE, LightSparkleParticle.Factory::new);
        AtumParticles.registerFactory(MONTU, MontuParticle.Factory::new);
        AtumParticles.registerFactory(NUIT_BLACK, SwirlParticle.NuitBlack::new);
        AtumParticles.registerFactory(NUIT_WHITE, SwirlParticle.NuitWhite::new);
        AtumParticles.registerFactory(RA_FIRE, RaFireParticle.Factory::new);
        AtumParticles.registerFactory(SETH, DropParticle.Seth::new);
        AtumParticles.registerFactory(SHU, SwirlParticle.Shu::new);
        AtumParticles.registerFactory(TAR, DropParticle.Tar::new);
        AtumParticles.registerFactory(TEFNUT, TefnutParticle.Factory::new);
        AtumParticles.registerFactory(TEFNUT_DROP, DropParticle.Tefnut::new);
    }

    public static <T extends IParticleData> void registerFactory(ParticleType<T> particleType, ParticleManager.IParticleMetaFactory<T> particleMetaFactory) {
        ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
        particleManager.func_215234_a(particleType, particleMetaFactory);
    }
}

