/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.inventory.container.entity;

import com.teammetallurgy.atum.blocks.wood.CrateBlock;
import com.teammetallurgy.atum.entity.animal.CamelEntity;
import com.teammetallurgy.atum.init.AtumGuis;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SaddleItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CamelContainer
extends Container {
    public final IInventory camelInventory;
    public final CamelEntity camel;
    private List<Slot> rightCrateSlots = new ArrayList<Slot>();
    private List<Slot> leftCrateSlots = new ArrayList<Slot>();

    public CamelContainer(int windowID, PlayerInventory playerInventory, int entityID) {
        super(AtumGuis.CAMEL, windowID);
        int slot;
        int row;
        PlayerEntity player = playerInventory.field_70458_d;
        this.camel = (CamelEntity)player.field_70170_p.func_73045_a(entityID);
        this.camelInventory = this.camel.getHorseChest();
        this.camelInventory.func_174889_b(player);
        this.func_75146_a(new Slot(this.camelInventory, 0, 62, 64){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof SaddleItem && !this.func_75216_d() && CamelContainer.this.camel.func_190685_dA();
            }

            @OnlyIn(value=Dist.CLIENT)
            public boolean func_111238_b() {
                return CamelContainer.this.camel.func_190685_dA();
            }
        });
        this.func_75146_a(new Slot(this.camelInventory, 1, 80, 64){

            public boolean func_75214_a(ItemStack stack) {
                return CamelContainer.this.camel.func_190682_f(stack);
            }

            public int func_75219_a() {
                return 1;
            }

            @OnlyIn(value=Dist.CLIENT)
            public boolean func_111238_b() {
                return CamelContainer.this.camel.func_190677_dK();
            }
        });
        this.func_75146_a(new Slot(this.camelInventory, 2, 98, 64){

            public boolean func_75214_a(ItemStack stack) {
                return CamelContainer.this.camel.isValidCarpet(stack);
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.camelInventory, 3, 35, 64){

            public boolean func_75214_a(ItemStack stack) {
                return Block.func_149634_a((Item)stack.func_77973_b()) instanceof CrateBlock;
            }

            public void func_75218_e() {
                super.func_75218_e();
                CamelContainer.this.updateLeftChestSlots();
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                for (Slot slot : CamelContainer.this.leftCrateSlots) {
                    if (!slot.func_75216_d()) continue;
                    return false;
                }
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.camelInventory, 4, 125, 64){

            public boolean func_75214_a(ItemStack stack) {
                return Block.func_149634_a((Item)stack.func_77973_b()) instanceof CrateBlock;
            }

            public void func_75218_e() {
                super.func_75218_e();
                CamelContainer.this.updateRightChestSlots();
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                for (Slot slot : CamelContainer.this.rightCrateSlots) {
                    if (!slot.func_75216_d()) continue;
                    return false;
                }
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        for (row = 0; row < 3; ++row) {
            for (slot = 0; slot < this.camel.getInventoryColumns(); ++slot) {
                this.leftCrateSlots.add(new Slot(this.camelInventory, this.camel.getNonCrateSize() + slot + row * this.camel.getInventoryColumns(), 8 + slot * 18, 86 + row * 18));
                if (this.camel == null || !this.camel.hasLeftCrate()) continue;
                this.func_75146_a(this.leftCrateSlots.get(this.leftCrateSlots.size() - 1));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (slot = 0; slot < this.camel.getInventoryColumns(); ++slot) {
                this.rightCrateSlots.add(new Slot(this.camelInventory, this.camel.getNonCrateSize() + 3 * this.camel.getInventoryColumns() + slot + row * this.camel.getInventoryColumns(), 98 + slot * 18, 86 + row * 18));
                if (this.camel == null || !this.camel.hasRightCrate()) continue;
                this.func_75146_a(this.rightCrateSlots.get(this.rightCrateSlots.size() - 1));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (slot = 0; slot < 9; ++slot) {
                this.func_75146_a(new Slot((IInventory)playerInventory, slot + row * 9 + 9, 8 + slot * 18, 102 + row * 18 + 52));
            }
        }
        for (int slot2 = 0; slot2 < 9; ++slot2) {
            this.func_75146_a(new Slot((IInventory)playerInventory, slot2, 8 + slot2 * 18, 212));
        }
    }

    private void updateLeftChestSlots() {
        int i;
        if (this.camel.hasLeftCrate()) {
            boolean hasLeftSlots = false;
            for (Slot slot : this.leftCrateSlots) {
                if (!this.field_75151_b.contains(slot)) continue;
                hasLeftSlots = true;
                break;
            }
            if (!hasLeftSlots) {
                for (int i2 = 0; i2 < this.leftCrateSlots.size(); ++i2) {
                    this.field_75151_b.add(this.camel.getNonCrateSize() + i2, this.leftCrateSlots.get(i2));
                    this.field_75153_a.add((Object)ItemStack.field_190927_a);
                }
            }
        } else {
            for (i = 0; i < this.field_75151_b.size(); ++i) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (!this.leftCrateSlots.contains(slot)) continue;
                this.field_75151_b.remove(i);
                this.field_75153_a.remove(i);
                --i;
            }
        }
        for (i = 0; i < this.field_75151_b.size(); ++i) {
            ((Slot)this.field_75151_b.get((int)i)).field_75222_d = i;
        }
    }

    private void updateRightChestSlots() {
        int i;
        if (this.camel.hasRightCrate()) {
            boolean hasRightSlots = false;
            for (Slot slot : this.rightCrateSlots) {
                if (!this.field_75151_b.contains(slot)) continue;
                hasRightSlots = true;
                break;
            }
            if (!hasRightSlots) {
                for (Slot rightCrateSlot : this.rightCrateSlots) {
                    this.field_75151_b.add(this.camel.getNonCrateSize() + this.leftCrateSlots.size(), rightCrateSlot);
                    this.field_75153_a.add((Object)ItemStack.field_190927_a);
                }
            }
        } else {
            for (i = 0; i < this.field_75151_b.size(); ++i) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (!this.rightCrateSlots.contains(slot)) continue;
                this.field_75151_b.remove(i);
                this.field_75153_a.remove(i);
                --i;
            }
        }
        for (i = 0; i < this.field_75151_b.size(); ++i) {
            ((Slot)this.field_75151_b.get((int)i)).field_75222_d = i;
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.camelInventory.func_70300_a(player) && this.camel.func_70089_S() && this.camel.func_70032_d((Entity)player) < 8.0f;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            int camelInventorySize = this.camel.getNonCrateSize() + (this.camel.hasLeftCrate() ? this.leftCrateSlots.size() : 0) + (this.camel.hasRightCrate() ? this.rightCrateSlots.size() : 0);
            if (index < camelInventorySize ? !this.func_75135_a(slotStack, camelInventorySize, this.field_75151_b.size(), true) : (this.func_75139_a(1).func_75214_a(slotStack) && !this.func_75139_a(1).func_75216_d() ? !this.func_75135_a(slotStack, 1, 5, false) : (this.func_75139_a(2).func_75214_a(slotStack) && !this.func_75139_a(2).func_75216_d() ? !this.func_75135_a(slotStack, 2, 5, false) : (this.func_75139_a(3).func_75214_a(slotStack) && !this.func_75139_a(3).func_75216_d() ? !this.func_75135_a(slotStack, 3, 5, false) : (this.func_75139_a(4).func_75214_a(slotStack) && !this.func_75139_a(4).func_75216_d() ? !this.func_75135_a(slotStack, 4, 5, false) : (this.func_75139_a(0).func_75214_a(slotStack) ? !this.func_75135_a(slotStack, 0, 1, false) : camelInventorySize <= 5 || !this.func_75135_a(slotStack, 5, camelInventorySize, false))))))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.camelInventory.func_174886_c(player);
    }
}

