/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.thoth;

import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.dimension.AtumDimensionType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CompassItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ThothsDirectionItem
extends CompassItem {
    private BlockPos pyramidPos;
    private int searchTime;
    private boolean isSearching = false;

    public ThothsDirectionItem() {
        super(new Item.Properties().func_200917_a(1).func_208103_a(Rarity.RARE));
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            double rotation;
            @OnlyIn(value=Dist.CLIENT)
            double rota;
            @OnlyIn(value=Dist.CLIENT)
            long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(@Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity livingBase) {
                LivingEntity entity;
                if (livingBase == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean livingNotNull = livingBase != null;
                Object object = entity = livingNotNull ? livingBase : stack.func_82836_z();
                if (world == null) {
                    world = entity.field_70170_p;
                }
                double angle = 0.0;
                if (world.func_201675_m().func_186058_p() == AtumDimensionType.ATUM) {
                    if (ThothsDirectionItem.this.isSearching) {
                        angle = this.spin(world);
                    } else {
                        double d1 = livingNotNull ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                        d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                        double pyramidAngle = this.getPyramidToAngle(world, (Entity)entity) / (Math.PI * 2);
                        angle = 0.5 - (d1 - 0.25 - pyramidAngle);
                    }
                } else {
                    angle = Math.random();
                }
                if (livingNotNull) {
                    angle = this.wobble(world, angle);
                }
                return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double spin(World world) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    long delta = world.func_82737_E() - this.lastUpdateTick;
                    this.lastUpdateTick = world.func_82737_E();
                    this.rotation += 0.05 * (double)delta;
                    this.rotation = MathHelper.func_191273_b((double)this.rotation, (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World world, double angle) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double wobbleAngle = angle - this.rotation;
                    wobbleAngle = MathHelper.func_191273_b((double)(wobbleAngle + 0.5), (double)1.0) - 0.5;
                    this.rota += wobbleAngle * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity frame) {
                return MathHelper.func_188209_b((int)(180 + frame.func_174811_aO().func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getPyramidToAngle(World world, Entity entity) {
                if (ThothsDirectionItem.this.isSearching) {
                    return 1.0;
                }
                if (ThothsDirectionItem.this.pyramidPos != null) {
                    BlockPos structurePos = ThothsDirectionItem.this.pyramidPos;
                    return Math.atan2((double)structurePos.func_177952_p() - entity.func_226281_cx_(), (double)structurePos.func_177958_n() - entity.func_226277_ct_());
                }
                return MathHelper.func_191273_b((double)this.wobble(world, Math.random()), (double)1.0);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_146105_b(new TranslationTextComponent("atum." + Objects.requireNonNull(this.getRegistryName()).func_110623_a() + ".searching", new Object[0]).func_211708_a(TextFormatting.YELLOW), true);
        this.searchTime = 60;
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (((Boolean)AtumConfig.WORLD_GEN.pyramidEnabled.get()).booleanValue()) {
            if (this.searchTime > 1) {
                this.isSearching = true;
                --this.searchTime;
            }
            if (this.searchTime == 1) {
                this.searchTime = 0;
                this.isSearching = false;
                if (!world.field_72995_K && entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    ServerWorld serverWorld = (ServerWorld)world;
                }
            }
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }
}

