/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.tools;

import com.teammetallurgy.atum.Atum;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.SwordItem;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class HammerItem
extends SwordItem {
    private static final AttributeModifier STUN = new AttributeModifier(UUID.fromString("b4ebf092-fe62-4250-b945-7dc45b2f1036"), "Hammer stun", -1000.0, AttributeModifier.Operation.ADDITION);
    private static final Object2FloatMap<PlayerEntity> cooldown = new Object2FloatOpenHashMap();
    protected static final Object2IntMap<LivingEntity> stun = new Object2IntOpenHashMap();

    protected HammerItem(IItemTier tier, Item.Properties properties) {
        super(tier, 17, -3.55f, properties.func_200916_a(Atum.GROUP));
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof PlayerEntity && cooldown.containsKey((Object)trueSource)) {
            Item heldItem;
            if (cooldown.getFloat((Object)trueSource) == 1.0f && (heldItem = ((PlayerEntity)trueSource).func_184614_ca().func_77973_b()) instanceof HammerItem) {
                HammerItem hammerItem = (HammerItem)heldItem;
                LivingEntity target = event.getEntityLiving();
                ModifiableAttributeInstance attribute = (ModifiableAttributeInstance)target.func_110148_a(SharedMonsterAttributes.field_111263_d);
                if (!attribute.func_180374_a(STUN)) {
                    attribute.func_111121_a(STUN);
                    hammerItem.onStun(target);
                }
            }
            cooldown.removeFloat((Object)trueSource);
        }
    }

    protected void onStun(LivingEntity target) {
        stun.put((Object)target, 40);
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (stun.isEmpty()) {
            return;
        }
        ModifiableAttributeInstance attribute = (ModifiableAttributeInstance)entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (attribute.func_180374_a(STUN)) {
            int stunTime = stun.getInt((Object)entity);
            if (stunTime <= 1) {
                attribute.func_111124_b(STUN);
                stun.remove((Object)entity, stunTime);
            } else {
                stun.replace((Object)entity, stunTime - 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttack(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getTarget() instanceof LivingEntity && player.func_184614_ca().func_77973_b() instanceof HammerItem) {
            cooldown.put((Object)player, player.func_184825_o(0.5f));
        }
    }
}

