/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc.potion;

import com.teammetallurgy.atum.entity.bandit.AssassinEntity;
import com.teammetallurgy.atum.init.AtumEffects;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.dimension.AtumDimensionType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MarkedForDeathEffect
extends Effect {
    private static final Object2IntMap<LivingEntity> NEXT_SPAWN = new Object2IntOpenHashMap();

    public MarkedForDeathEffect() {
        super(EffectType.NEUTRAL, 12624973);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public void func_76394_a(@Nonnull LivingEntity livingEntity, int amplifier) {
        int z;
        Random random;
        int x;
        BlockPos.Mutable mutablePos;
        DifficultyInstance difficulty;
        ServerWorld serverWorld;
        World world = livingEntity.field_70170_p;
        if (!world.func_201670_d() && world instanceof ServerWorld && (serverWorld = (ServerWorld)world).func_201675_m().func_186058_p() == AtumDimensionType.ATUM && !livingEntity.func_175149_v() && (difficulty = serverWorld.func_175649_E((BlockPos)(mutablePos = new BlockPos.Mutable((Entity)livingEntity).func_196234_d(x = (24 + (random = serverWorld.field_73012_v).nextInt(24)) * (random.nextBoolean() ? -1 : 1), 0, z = (24 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1))))).func_203095_a() != Difficulty.PEACEFUL) {
            double multiplier = Math.max(1.0, ((double)amplifier + Math.ceil(difficulty.func_180168_b())) / 1.33);
            int value = (int)((double)((Integer)AtumConfig.MOBS.markedForDeathTimeBaseValue.get()).intValue() / multiplier);
            if (!NEXT_SPAWN.containsKey((Object)livingEntity)) {
                NEXT_SPAWN.put((Object)livingEntity, value);
            } else {
                int currentTime = NEXT_SPAWN.getInt((Object)livingEntity);
                NEXT_SPAWN.replace((Object)livingEntity, currentTime - 1);
            }
            if (serverWorld.isAreaLoaded((BlockPos)mutablePos, 10) && NEXT_SPAWN.getInt((Object)livingEntity) <= 0) {
                mutablePos.func_185336_p(serverWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutablePos).func_177956_o());
                this.spawnAssassin((World)serverWorld, (BlockPos)mutablePos, random, livingEntity);
                NEXT_SPAWN.removeInt((Object)livingEntity);
                NEXT_SPAWN.put((Object)livingEntity, value);
            }
        }
    }

    @SubscribeEvent
    public void onEffectExpired(PotionEvent.PotionExpiryEvent event) {
        EffectInstance effectInstance = event.getPotionEffect();
        if (effectInstance != null && effectInstance.func_188419_a() == AtumEffects.MARKED_FOR_DEATH) {
            NEXT_SPAWN.removeInt((Object)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onEffectRemoval(PotionEvent.PotionRemoveEvent event) {
        EffectInstance effectInstance = event.getPotionEffect();
        if (effectInstance != null && effectInstance.func_188419_a() == AtumEffects.MARKED_FOR_DEATH) {
            NEXT_SPAWN.removeInt((Object)event.getEntityLiving());
        }
    }

    private void spawnAssassin(World world, BlockPos pos, Random rand, LivingEntity markedTarget) {
        AssassinEntity assassin;
        EntityType<AssassinEntity> entityType = AtumEntities.ASSASSIN;
        BlockState state = world.func_180495_p(pos);
        if (WorldEntitySpawner.func_222266_a((IBlockReader)world, (BlockPos)pos, (BlockState)state, (IFluidState)state.func_204520_s()) && AssassinEntity.canSpawn(entityType, (IWorld)world, SpawnReason.EVENT, pos, rand) && (assassin = (AssassinEntity)entityType.func_200721_a(world)) != null) {
            assassin.func_70107_b(pos.func_177958_n() + rand.nextInt(5) - rand.nextInt(5), pos.func_177956_o(), pos.func_177952_p() + rand.nextInt(5) - rand.nextInt(5));
            assassin.func_213386_a((IWorld)world, world.func_175649_E(pos), SpawnReason.EVENT, null, null);
            assassin.setMarkedTarget(markedTarget);
            world.func_217376_c((Entity)assassin);
        }
    }
}

