/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome;

import com.teammetallurgy.atum.blocks.SandLayersBlock;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.gen.AtumSurfaceBuilders;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class AtumBiome
extends Biome {
    private final int defaultWeight;

    public AtumBiome(Builder builder) {
        super((Biome.Builder)builder);
        this.defaultWeight = builder.defaultWeight;
    }

    protected void addDefaultSpawns(Biome biome) {
        this.addSpawn(biome, AtumEntities.DESERT_RABBIT, 5, 2, 3, EntityClassification.CREATURE);
        this.addSpawn(biome, EntityType.field_200791_e, 5, 8, 8, EntityClassification.AMBIENT);
        this.addSpawn(biome, AtumEntities.BONESTORM, 5, 1, 2, EntityClassification.MONSTER);
        this.addSpawn(biome, AtumEntities.FORSAKEN, 22, 1, 4, EntityClassification.MONSTER);
        this.addSpawn(biome, AtumEntities.MUMMY, 30, 1, 3, EntityClassification.MONSTER);
        this.addSpawn(biome, AtumEntities.WRAITH, 10, 1, 2, EntityClassification.MONSTER);
        this.addSpawn(biome, AtumEntities.STONEGUARD, 34, 1, 2, EntityClassification.MONSTER);
        this.addSpawn(biome, AtumEntities.TARANTULA, 20, 1, 3, EntityClassification.MONSTER);
    }

    protected void addSpawn(Biome biome, EntityType<?> entityType, int weight, int min, int max, EntityClassification classification) {
        ResourceLocation location = entityType.getRegistryName();
        if (location != null) {
            new AtumConfig.Mobs(AtumConfig.BUILDER, location.func_110623_a(), min, max, weight, entityType, classification, biome);
        }
    }

    protected void addCamelSpawning(Biome biome) {
        this.addSpawn(biome, AtumEntities.CAMEL, 6, 2, 6, EntityClassification.CREATURE);
    }

    protected void addDesertWolfSpawning(Biome biome) {
        this.addSpawn(biome, AtumEntities.DESERT_WOLF, 5, 2, 4, EntityClassification.CREATURE);
    }

    public static void initMobSpawns(Biome biome, EntityType<?> entityType) {
        String baseCategory = "mobs";
        EntityClassification classification = AtumConfig.Mobs.ENTITY_CLASSIFICATION.get(entityType);
        if (entityType != null && entityType.getRegistryName() != null) {
            String mobName = entityType.getRegistryName().func_110623_a();
            int weight = (Integer)AtumConfig.Helper.get(baseCategory, mobName, "weight");
            int min = (Integer)AtumConfig.Helper.get(baseCategory, mobName, "min");
            int max = (Integer)AtumConfig.Helper.get(baseCategory, mobName, "max");
            biome.func_76747_a(classification).add(new Biome.SpawnListEntry(entityType, weight, min, max));
        }
    }

    public int getDefaultWeight() {
        return this.defaultWeight;
    }

    public int func_225527_a_() {
        return 12889745;
    }

    public int func_225528_a_(double x, double z) {
        return 12889745;
    }

    @Nonnull
    public Biome getRiver() {
        return AtumBiomes.DRIED_RIVER;
    }

    public void func_203608_a(@Nonnull GenerationStage.Decoration stage, @Nonnull ChunkGenerator<? extends GenerationSettings> chunkGenerator, @Nonnull IWorld world, long seed, @Nonnull SharedSeedRandom random, @Nonnull BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, random, pos);
        if (((Boolean)AtumConfig.WORLD_GEN.sandLayerEdge.get()).booleanValue()) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos height = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177982_a(x, 0, z));
                    if (!this.canPlaceSandLayer((IWorldReader)world, height)) continue;
                    for (Direction facing : Direction.Plane.HORIZONTAL) {
                        BlockPos posOffset = height.func_177972_a(facing);
                        if (!world.func_180495_p(posOffset).func_224755_d((IBlockReader)world, posOffset, Direction.UP)) continue;
                        int layers = MathHelper.func_76136_a((Random)random, (int)1, (int)3);
                        world.func_180501_a(height, (BlockState)AtumBlocks.SAND_LAYERED.func_176223_P().func_206870_a((IProperty)SandLayersBlock.LAYERS, (Comparable)Integer.valueOf(layers)), 2);
                    }
                }
            }
        }
    }

    public boolean canPlaceSandLayer(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return this != AtumBiomes.OASIS && state.func_185904_a().func_76222_j() && stateDown.func_177230_c() != AtumBlocks.LIMESTONE_CRACKED && Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b()) && !(stateDown.func_177230_c() instanceof SandLayersBlock) && !(state.func_177230_c() instanceof SandLayersBlock);
    }

    public static class Builder
    extends Biome.Builder {
        private final int defaultWeight;

        public Builder(String biomeName, int weight) {
            this.func_205415_a(Biome.RainType.NONE);
            this.func_205417_d(0.0f);
            this.func_205414_c(2.0f);
            this.func_205412_a(4159204);
            this.func_205413_b(329011);
            this.setBaseHeight(0.135f);
            this.setHeightVariation(0.05f);
            this.func_205418_a(null);
            this.func_205419_a(Biome.Category.DESERT);
            this.func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)AtumSurfaceBuilders.SANDY);
            this.defaultWeight = weight;
            if (weight > 0) {
                new AtumConfig.Biome(AtumConfig.BUILDER, biomeName, weight);
            }
        }

        public Builder setBaseHeight(float height) {
            this.func_205421_a(height);
            return this;
        }

        public Builder setHeightVariation(float variation) {
            this.func_205420_b(variation);
            return this;
        }

        public Builder setBiomeBlocks(SurfaceBuilderConfig builderConfig) {
            this.func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)builderConfig);
            return this;
        }
    }
}

