/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.dimension;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.SandLayersBlock;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.StormStrengthPacket;
import com.teammetallurgy.atum.network.packet.WeatherPacket;
import com.teammetallurgy.atum.world.biome.AtumBiome;
import com.teammetallurgy.atum.world.biome.provider.AtumBiomeProvider;
import com.teammetallurgy.atum.world.biome.provider.AtumBiomeProviderSettings;
import com.teammetallurgy.atum.world.biome.provider.AtumBiomeProviderTypes;
import com.teammetallurgy.atum.world.dimension.AtumDimensionData;
import com.teammetallurgy.atum.world.gen.AtumChunkGenerator;
import com.teammetallurgy.atum.world.gen.AtumChunkGeneratorType;
import com.teammetallurgy.atum.world.gen.AtumGenSettings;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AtumDimension
extends Dimension {
    private static BlockPos usePos;
    public static final AtumDimensionData DATA;
    public int stormTime;
    public float prevStormStrength;
    public float stormStrength;
    private long lastUpdateTime;

    public AtumDimension(World world, DimensionType dimensionType) {
        super(world, dimensionType, 0.0f);
    }

    @SubscribeEvent
    public static void onUseBucket(PlayerInteractEvent.RightClickBlock event) {
        usePos = (Integer)AtumConfig.WORLD_GEN.waterLevel.get() > 0 ? event.getPos() : null;
    }

    public boolean func_177500_n() {
        if (usePos != null) {
            return this.field_76579_a.func_226691_t_(usePos) != AtumBiomes.OASIS && usePos.func_177956_o() >= (Integer)AtumConfig.WORLD_GEN.waterLevel.get();
        }
        return false;
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        IWorld world = event.getWorld();
        if (world.func_201675_m() instanceof AtumDimension && world.func_72912_H() instanceof DerivedWorldInfo) {
            ((DerivedWorldInfo)world.func_72912_H()).field_76115_a.func_76068_b(event.getNewTime());
        }
    }

    @Nonnull
    public ChunkGenerator<?> func_186060_c() {
        BiomeProviderType<AtumBiomeProviderSettings, AtumBiomeProvider> biomeType = AtumBiomeProviderTypes.ATUM;
        ChunkGeneratorType<AtumGenSettings, AtumChunkGenerator> chunkType = AtumChunkGeneratorType.ATUM;
        AtumGenSettings genSettings = (AtumGenSettings)chunkType.func_205483_a();
        AtumBiomeProviderSettings biomeSettings = ((AtumBiomeProviderSettings)biomeType.func_226840_a_(this.field_76579_a.func_72912_H())).setGeneratorSettings(genSettings);
        return chunkType.create(this.field_76579_a, biomeType.func_205457_a((IBiomeProviderSettings)biomeSettings), (GenerationSettings)genSettings);
    }

    @Nullable
    public BlockPos func_206920_a(@Nonnull ChunkPos chunkPos, boolean checkValid) {
        for (int x = chunkPos.func_180334_c(); x <= chunkPos.func_180332_e(); ++x) {
            for (int z = chunkPos.func_180333_d(); z <= chunkPos.func_180330_f(); ++z) {
                BlockPos pos = this.func_206921_a(x, z, checkValid);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(posX, 0, posZ);
        Biome biome = this.field_76579_a.func_226691_t_((BlockPos)mutablePos);
        BlockState state = biome.func_203944_q().func_204108_a();
        if (checkValid && !state.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_212866_a_(posX >> 4, posZ >> 4);
        int x = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, posX & 0xF, posZ & 0xF);
        if (x < 0) {
            return null;
        }
        for (int y = x + 1; y >= 0; --y) {
            mutablePos.func_181079_c(posX, y, posZ);
            BlockState stateMutable = this.field_76579_a.func_180495_p((BlockPos)mutablePos);
            if (!stateMutable.func_204520_s().func_206888_e()) break;
            if (!stateMutable.equals(state)) continue;
            return mutablePos.func_177984_a().func_185334_h();
        }
        return null;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public boolean func_76569_d() {
        return true;
    }

    @Nonnull
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)((float)((double)celestialAngle * Math.PI * 2.0))) * 2.0f + 0.5f;
        if (f < 0.2f) {
            f = 0.2f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f1 = 0.9f * f;
        float f2 = 0.75f * f;
        float f3 = 0.6f * f;
        return new Vec3d((double)f1, (double)f2, (double)f3);
    }

    public boolean func_76567_e() {
        return true;
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public boolean isDaytime() {
        return this.getWorld().func_175657_ab() < 4;
    }

    public void func_186057_q() {
        super.func_186057_q();
        if (this.field_76579_a instanceof ServerWorld) {
            ((ServerWorld)this.field_76579_a).func_217481_x().func_215752_a(() -> DATA, DATA.func_195925_e());
        }
    }

    public void calculateInitialWeather() {
        super.calculateInitialWeather();
        if (DATA.isStorming()) {
            this.stormStrength = 1.0f;
        }
    }

    private boolean canPlaceSandAt(BlockPos pos, AtumBiome biome) {
        BlockState state = this.field_76579_a.func_180495_p(pos.func_177977_b());
        return state.func_177230_c() != AtumBlocks.SAND && state.func_177230_c() != AtumBlocks.LIMESTONE_GRAVEL && biome.canPlaceSandLayer((IWorldReader)this.field_76579_a, pos) || state.func_177230_c().func_203417_a(BlockTags.field_206952_E);
    }

    public void updateWeather(Runnable defaultLogic) {
        if (((Boolean)AtumConfig.SANDSTORM.sandstormEnabled.get()).booleanValue() && !this.field_76579_a.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)this.field_76579_a;
            int cleanWeatherTime = serverWorld.func_72912_H().func_176133_A();
            if (cleanWeatherTime > 0) {
                serverWorld.func_72912_H().func_176142_i(--cleanWeatherTime);
                int n = this.stormTime = DATA.isStorming() ? 1 : 2;
            }
            if (this.stormTime <= 0) {
                this.stormTime = DATA.isStorming() ? this.field_76579_a.field_73012_v.nextInt(6000) + 6000 : this.field_76579_a.field_73012_v.nextInt(168000) + 12000;
                NetworkHandler.sendToDimension(new WeatherPacket(DATA.isStorming(), this.stormTime), serverWorld, this.func_186058_p());
            } else {
                --this.stormTime;
                if (this.stormTime <= 0) {
                    DATA.setStorming(!DATA.isStorming());
                }
            }
            this.prevStormStrength = this.stormStrength;
            this.stormStrength = DATA.isStorming() ? (this.stormStrength += 1.0f / (float)(20 * (Integer)AtumConfig.SANDSTORM.sandstormTransitionTime.get())) : (this.stormStrength -= 1.0f / (float)(20 * (Integer)AtumConfig.SANDSTORM.sandstormTransitionTime.get()));
            this.stormStrength = MathHelper.func_76131_a((float)this.stormStrength, (float)0.0f, (float)1.0f);
            if (this.stormStrength != this.prevStormStrength || this.lastUpdateTime < System.currentTimeMillis() - 1000L) {
                NetworkHandler.sendToDimension(new StormStrengthPacket(this.stormStrength), serverWorld, this.func_186058_p());
                this.lastUpdateTime = System.currentTimeMillis();
            }
            try {
                if ((Integer)AtumConfig.SANDSTORM.sandstormSandLayerChance.get() > 0 && this.field_76579_a.field_73012_v.nextInt((Integer)AtumConfig.SANDSTORM.sandstormSandLayerChance.get()) == 0 && this.stormStrength > 0.9f) {
                    ChunkManager chunkManager = ((ServerWorld)this.field_76579_a).getWorldServer().func_72863_F().field_217237_a;
                    chunkManager.func_223491_f().forEach(chunkHolder -> {
                        BlockPos pos;
                        BlockPos posDown;
                        ChunkPos chunkPos;
                        Optional optionalChunk = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                        if (optionalChunk.isPresent() && !this.isOutsideSpawningRadius(chunkManager, chunkPos = ((Chunk)optionalChunk.get()).func_76632_l()) && this.field_76579_a.isAreaLoaded(posDown = (pos = this.field_76579_a.func_205770_a(Heightmap.Type.MOTION_BLOCKING, serverWorld.func_217383_a(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d(), 15))).func_177977_b(), 1)) {
                            BlockState sandState = this.field_76579_a.func_180495_p(pos);
                            Biome biome = this.field_76579_a.func_226691_t_(pos);
                            if (biome instanceof AtumBiome) {
                                if (sandState.func_177230_c() == AtumBlocks.SAND_LAYERED) {
                                    int layers = (Integer)sandState.func_177229_b((IProperty)SandLayersBlock.LAYERS);
                                    if (layers < 3) {
                                        this.field_76579_a.func_175656_a(pos, (BlockState)sandState.func_206870_a((IProperty)SandLayersBlock.LAYERS, (Comparable)Integer.valueOf(++layers)));
                                    }
                                } else if (this.canPlaceSandAt(pos, (AtumBiome)biome)) {
                                    this.field_76579_a.func_175656_a(pos, AtumBlocks.SAND_LAYERED.func_176223_P());
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                Atum.LOG.error("Error occurred while Sandstorm attempted to place Sand Layer");
            }
        }
    }

    private static double getDistanceSquaredToChunk(ChunkPos chunkPos, Entity entity) {
        double chunkX = chunkPos.field_77276_a * 16 + 8;
        double chunkZ = chunkPos.field_77275_b * 16 + 8;
        double x = chunkX - entity.func_226277_ct_();
        double z = chunkZ - entity.func_226281_cx_();
        return x * x + z * z;
    }

    public boolean isOutsideSpawningRadius(ChunkManager chunkManager, ChunkPos chunkPos) {
        long i = chunkPos.func_201841_a();
        return !chunkManager.func_219246_e().func_223494_d(i) || chunkManager.field_219271_y.func_219444_a(i).noneMatch(p -> !p.func_175149_v() && AtumDimension.getDistanceSquaredToChunk(chunkPos, (Entity)p) < 16384.0);
    }

    static {
        DATA = new AtumDimensionData();
    }
}

