/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.AtumConfig;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class StartStructureFeature
extends Feature<NoFeatureConfig> {
    public StartStructureFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(@Nonnull IWorld world, @Nonnull ChunkGenerator<? extends GenerationSettings> generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            TemplateManager manager = serverWorld.func_217485_w().func_186340_h();
            Template template = manager.func_200219_b(new ResourceLocation((String)AtumConfig.ATUM_START.atumStartStructure.get()));
            if (template != null) {
                Rotation[] rotations = Rotation.values();
                Rotation rotation = rotations[rand.nextInt(rotations.length)];
                PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_189950_a(rand);
                BlockPos rotatedPos = template.func_186257_a(rotation);
                int x = rand.nextInt(rotatedPos.func_177958_n()) + template.func_186259_a().func_177958_n();
                int z = rand.nextInt(rotatedPos.func_177952_p()) + template.func_186259_a().func_177952_p();
                BlockPos posOffset = pos.func_177982_a(x, 0, z);
                while (posOffset.func_177956_o() > 1 && world.func_175623_d(posOffset.func_177977_b())) {
                    posOffset = posOffset.func_177977_b();
                }
                while (!world.func_175623_d(posOffset.func_177984_a()) && (world.func_180495_p(posOffset.func_177977_b()).func_177230_c() != AtumBlocks.SAND || world.func_180495_p(posOffset.func_177977_b()).func_177230_c() != AtumBlocks.SAND_LAYERED) || posOffset.func_177956_o() < 60) {
                    posOffset = posOffset.func_177984_a();
                }
                template.func_189962_a(world, posOffset, settings, 20);
                return true;
            }
            Atum.LOG.error((String)AtumConfig.ATUM_START.atumStartStructure.get() + " is not a valid structure");
            return false;
        }
        return false;
    }
}

