/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.lighthouse;

import com.teammetallurgy.atum.blocks.base.ChestBaseBlock;
import com.teammetallurgy.atum.blocks.wood.tileentity.crate.CrateTileEntity;
import com.teammetallurgy.atum.entity.efreet.SunspeakerEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.init.AtumStructurePieces;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class LighthousePieces {
    public static final ResourceLocation LIGHTHOUSE = new ResourceLocation("atum", "lighthouse");

    public static class LighthouseTemplate
    extends TemplateStructurePiece {
        private final Rotation rotation;
        private int sunspeakerSpawned;

        public LighthouseTemplate(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(AtumStructurePieces.LIGHTHOUSE, 0);
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.loadTemplate(manager);
        }

        public LighthouseTemplate(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.LIGHTHOUSE, nbt);
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.sunspeakerSpawned = nbt.func_74762_e("SunspeakerCount");
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_200219_b(LIGHTHOUSE);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        private void spawnSunspeakers(IWorld world, MutableBoundingBox box, int x, int y, int z, int min, int max) {
            if (this.sunspeakerSpawned > 0) {
                return;
            }
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
            Random rand = new Random(world.func_72905_C() ^ (long)x ^ (long)(z << 16));
            int numToSpawn = rand.nextInt(1 + max - min) + min;
            int[] levels = new int[]{0, 5, 10, 22};
            ArrayList<Integer> ylevels = new ArrayList<Integer>();
            for (int i = 0; i < numToSpawn; ++i) {
                ylevels.add(y + levels[rand.nextInt(levels.length)] + 1);
            }
            HashSet<BlockPos> usedPosition = new HashSet<BlockPos>();
            int tries = 0;
            while (this.sunspeakerSpawned < numToSpawn) {
                int l;
                int k;
                int sw = 2;
                int j = x + rand.nextInt(2 * sw + 1) - sw;
                BlockPos pos = new BlockPos(j, k = ((Integer)ylevels.get(this.sunspeakerSpawned)).intValue(), l = z + rand.nextInt(2 * sw + 1) - sw);
                if (usedPosition.contains(pos)) continue;
                usedPosition.add(pos);
                if (box.func_175898_b((Vec3i)pos) && world.func_175623_d(pos)) {
                    ++this.sunspeakerSpawned;
                    SunspeakerEntity sunspeaker = (SunspeakerEntity)AtumEntities.SUNSPEAKER.func_200721_a(world.func_201672_e());
                    if (sunspeaker != null) {
                        sunspeaker.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                        sunspeaker.func_213386_a(world, world.func_175649_E(new BlockPos((Entity)sunspeaker)), SpawnReason.STRUCTURE, null, null);
                        world.func_217376_c((Entity)sunspeaker);
                    }
                }
                if (++tries <= 100) continue;
                break;
            }
        }

        protected void func_186175_a(@Nonnull String function, @Nonnull BlockPos pos, @Nonnull IWorld world, @Nonnull Random rand, @Nonnull MutableBoundingBox box) {
            if (function.equals("PalmCrate")) {
                if (box.func_175898_b((Vec3i)pos)) {
                    if (rand.nextDouble() <= 0.2) {
                        world.func_180501_a(pos, ChestBaseBlock.correctFacing((IBlockReader)world, pos, AtumBlocks.PALM_CRATE.func_176223_P(), AtumBlocks.PALM_CRATE), 2);
                        TileEntity tileEntity = world.func_175625_s(pos);
                        if (tileEntity instanceof CrateTileEntity) {
                            ((CrateTileEntity)tileEntity).func_189404_a(AtumLootTables.LIGHTHOUSE, rand.nextLong());
                        }
                    } else {
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            } else if (function.equals("Sunspeaker")) {
                this.spawnSunspeakers(world, box, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 2, 5);
            }
        }

        protected void func_143011_b(@Nonnull CompoundNBT compound) {
            super.func_143011_b(compound);
            compound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
            compound.func_74768_a("SunspeakerCount", this.sunspeakerSpawned);
        }
    }
}

