/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.pyramid;

import com.mojang.datafixers.Dynamic;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.SyncHandStackSizePacket;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidPieces;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PyramidStructure
extends Structure<NoFeatureConfig> {
    public PyramidStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    @Nonnull
    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int spacing = (Integer)AtumConfig.WORLD_GEN.pyramidSpacing.get();
        int separation = (Integer)AtumConfig.WORLD_GEN.pyramidSeparation.get();
        int k = x + spacing * spacingOffsetsX;
        int l = z + spacing * spacingOffsetsZ;
        int i1 = k < 0 ? k - spacing + 1 : k;
        int j1 = l < 0 ? l - spacing + 1 : l;
        int k1 = i1 / spacing;
        int l1 = j1 / spacing;
        ((SharedSeedRandom)random).func_202425_c(chunkGenerator.func_202089_c(), k1, l1);
        k1 *= spacing;
        l1 *= spacing;
        return new ChunkPos(k1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2, l1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2);
    }

    public boolean func_225558_a_(@Nonnull BiomeManager manager, @Nonnull ChunkGenerator<?> generator, @Nonnull Random rand, int chunkX, int chunkZ, @Nonnull Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(generator, rand, chunkX, chunkZ, 0, 0);
        if (chunkX == chunkpos.field_77276_a && chunkZ == chunkpos.field_77275_b) {
            if (!generator.func_202094_a(biome, (Structure)this)) {
                return false;
            }
            return StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, null) > 55;
        }
        return false;
    }

    @Nonnull
    public String func_143025_a() {
        return String.valueOf(PyramidPieces.PYRAMID);
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public int func_202367_b() {
        return 9;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        IWorld world = event.getWorld();
        if (event.getEntity() instanceof ServerPlayerEntity && this.func_202366_b(world, event.getPos())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            Block placedBlock = event.getPlacedBlock().func_177230_c();
            if (!player.func_184812_l_() && !(placedBlock instanceof TorchBlock)) {
                event.setCanceled(true);
                ItemStack placedStack = new ItemStack((IItemProvider)placedBlock);
                Hand hand = player.func_184614_ca().func_77973_b() == placedStack.func_77973_b() ? Hand.MAIN_HAND : Hand.OFF_HAND;
                NetworkHandler.sendTo(player, new SyncHandStackSizePacket(placedStack, hand == Hand.MAIN_HAND ? 1 : 0));
            }
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
        }

        public void func_214625_a(@Nonnull ChunkGenerator<?> generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int y = StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, rotation);
            if (y > 55) {
                int yChance = MathHelper.func_76136_a((Random)this.field_214631_d, (int)7, (int)14);
                BlockPos pos = new BlockPos(chunkX * 16 + 8, y - yChance, chunkZ * 16 + 8);
                List<StructurePiece> components = PyramidPieces.getComponents(manager, pos, rotation);
                this.field_75075_a.addAll(components);
                this.func_202500_a();
            }
        }

        public void func_225565_a_(@Nonnull IWorld world, @Nonnull ChunkGenerator<?> generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos) {
            if (world.func_226691_t_(chunkPos.func_206849_h()) != AtumBiomes.DRIED_RIVER) {
                super.func_225565_a_(world, generator, rand, box, chunkPos);
                int y = this.field_75074_b.field_78895_b;
                for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                    for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                        BlockPos pyramidPos;
                        BlockPos pos = new BlockPos(x, y, z);
                        if (world.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vec3i)pos)) continue;
                        boolean isVecInside = false;
                        for (StructurePiece component : this.field_75075_a) {
                            if (!component.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                            isVecInside = true;
                            break;
                        }
                        if (!isVecInside) continue;
                        for (int pyramidY = y - 1; pyramidY > 1 && (world.func_175623_d(pyramidPos = new BlockPos(x, pyramidY, z)) || world.func_180495_p(pyramidPos).func_185904_a().func_76224_d()); --pyramidY) {
                            world.func_180501_a(pyramidPos, AtumBlocks.LIMESTONE_BRICK_LARGE.func_176223_P(), 2);
                        }
                    }
                }
            }
        }
    }
}

