/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.ruins;

import com.mojang.datafixers.Dynamic;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.gen.AtumChunkGenerator;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinPieces;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RuinStructure
extends Structure<NoFeatureConfig> {
    public RuinStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    @Nonnull
    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int spacing = (Integer)AtumConfig.WORLD_GEN.ruinsSpacing.get();
        int separation = (Integer)AtumConfig.WORLD_GEN.ruinsSeparation.get();
        int k = x + spacing * spacingOffsetsX;
        int l = z + spacing * spacingOffsetsZ;
        int i1 = k < 0 ? k - spacing + 1 : k;
        int j1 = l < 0 ? l - spacing + 1 : l;
        int k1 = i1 / spacing;
        int l1 = j1 / spacing;
        ((SharedSeedRandom)random).func_202425_c(chunkGenerator.func_202089_c(), k1, l1);
        k1 *= spacing;
        l1 *= spacing;
        return new ChunkPos(k1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2, l1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2);
    }

    public boolean func_225558_a_(@Nonnull BiomeManager manager, @Nonnull ChunkGenerator<?> generator, @Nonnull Random rand, int chunkX, int chunkZ, @Nonnull Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(generator, rand, chunkX, chunkZ, 0, 0);
        if (chunkX == chunkpos.field_77276_a && chunkZ == chunkpos.field_77275_b) {
            if (generator instanceof AtumChunkGenerator) {
                if (!generator.func_202094_a(biome, (Structure)this)) {
                    return false;
                }
                int y = StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, null);
                return y > 60 && y < 85;
            }
            return false;
        }
        return false;
    }

    @Nonnull
    public String func_143025_a() {
        return String.valueOf(new ResourceLocation("atum", "ruin"));
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public int func_202367_b() {
        return 1;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
        }

        public void func_214625_a(@Nonnull ChunkGenerator<?> generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int y = StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, rotation);
            if (y > 60 && y < 85) {
                BlockPos pos = new BlockPos(chunkX * 16 + 8, y - 1, chunkZ * 16 + 8);
                RuinPieces.RuinTemplate ruin = new RuinPieces.RuinTemplate(manager, pos, (Random)this.field_214631_d, rotation);
                this.field_75075_a.add(ruin);
                this.func_202500_a();
            }
        }

        public void func_225565_a_(@Nonnull IWorld world, @Nonnull ChunkGenerator<?> generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos) {
            boolean doesChunkHaveStructure;
            boolean bl = doesChunkHaveStructure = StructureHelper.doesChunkHaveStructure(world, chunkPos.field_77276_a, chunkPos.field_77275_b, AtumFeatures.PYRAMID) || StructureHelper.doesChunkHaveStructure(world, chunkPos.field_77276_a, chunkPos.field_77275_b, AtumFeatures.GIRAFI_TOMB);
            if (!doesChunkHaveStructure) {
                super.func_225565_a_(world, generator, rand, box, chunkPos);
                int y = this.field_75074_b.field_78895_b;
                for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                    for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                        BlockPos tombPos;
                        BlockPos pos = new BlockPos(x, y, z);
                        if (world.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vec3i)pos)) continue;
                        boolean isVecInside = false;
                        for (StructurePiece piece : this.field_75075_a) {
                            if (!piece.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                            isVecInside = true;
                            break;
                        }
                        if (!isVecInside) continue;
                        for (int ruinY = y - 1; ruinY > 1 && (world.func_175623_d(tombPos = new BlockPos(x, ruinY, z)) || world.func_180495_p(tombPos).func_185904_a().func_76224_d()); --ruinY) {
                            world.func_180501_a(tombPos, AtumBlocks.LIMESTONE.func_176223_P(), 2);
                        }
                    }
                }
            }
        }
    }
}

