/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.bagofyurting;

import com.github.commoble.bagofyurting.BlockRemovalSorter;
import com.github.commoble.bagofyurting.BlockUnloadSorter;
import com.github.commoble.bagofyurting.Config;
import com.github.commoble.bagofyurting.TagWrappers;
import com.github.commoble.bagofyurting.util.NBTMapHelper;
import com.github.commoble.bagofyurting.util.RotationUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class BagOfYurtingData {
    public static final String NBT_KEY = "yurtdata";
    public static final Direction BASE_DIRECTION = Direction.SOUTH;
    private static final NBTMapHelper<BlockPos, CompoundNBT, StateData, CompoundNBT> mapper = new NBTMapHelper<BlockPos, CompoundNBT, StateData, CompoundNBT>("yurtdata", NBTUtil::func_186859_a, NBTUtil::func_186861_c, StateData::write, StateData::read);
    private final Map<BlockPos, StateData> map;
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BagOfYurtingData(Map<BlockPos, StateData> map) {
        this.map = map;
    }

    public static BagOfYurtingData yurtBlocksAndConvertToData(ItemUseContext context, int radius) {
        BlockPos origin = context.func_195995_a();
        Direction orientation = context.func_195992_f();
        World world = context.func_195991_k();
        BlockPos vertexA = origin.func_177982_a(-radius, 0, -radius);
        BlockPos vertexB = origin.func_177982_a(radius, 2 * radius, radius);
        Map<BlockPos, Pair> transformPairs = BlockPos.func_218281_b((BlockPos)vertexA, (BlockPos)vertexB).filter(pos -> BagOfYurtingData.canBlockBeStored(context, pos)).map(BlockPos::func_185334_h).sorted(new BlockRemovalSorter(world)).collect(Collectors.toMap(pos -> pos, pos -> Pair.of((Object)BagOfYurtingData.transformBlockPos(orientation, pos, origin), (Object)BagOfYurtingData.getPosEntryAndRemoveBlock(context, pos))));
        Map<BlockPos, StateData> transformData = transformPairs.values().stream().collect(Collectors.toMap(pair -> (BlockPos)pair.getLeft(), pair -> (StateData)pair.getRight()));
        if (transformPairs.size() > 0 && world instanceof ServerWorld) {
            BagOfYurtingData.doPoofEffects((ServerWorld)world, transformPairs.keySet());
            for (Map.Entry<BlockPos, Pair> entry : transformPairs.entrySet()) {
                BlockPos pos2 = entry.getKey();
                BlockState oldState = ((StateData)entry.getValue().getRight()).state;
                BagOfYurtingData.sendBlockUpdateAfterRemoval(world, pos2, oldState);
            }
        }
        return new BagOfYurtingData(transformData);
    }

    private static void sendBlockUpdateAfterRemoval(World world, BlockPos pos, BlockState oldState) {
        world.func_184138_a(pos, oldState, Blocks.field_150350_a.func_176223_P(), 3);
        world.func_195592_c(pos, oldState.func_177230_c());
    }

    public boolean attemptUnloadIntoWorld(ItemUseContext context, int radius) {
        boolean success;
        BlockPos hitPos;
        World world = context.func_195991_k();
        boolean hitBlockReplaceable = world.func_180495_p(hitPos = context.func_195995_a()).func_185904_a().func_76222_j();
        BlockPos origin = hitBlockReplaceable ? hitPos : hitPos.func_177972_a(context.func_196000_l());
        Direction orientation = context.func_195992_f();
        Rotation unrotation = RotationUtil.getUntransformRotation(orientation);
        PlayerEntity player = context.func_195999_j();
        Map<BlockPos, StateData> worldPositions = this.map.entrySet().stream().collect(Collectors.toMap(entry -> BagOfYurtingData.untransformBlockPos(unrotation, (BlockPos)entry.getKey(), origin), entry -> (StateData)entry.getValue()));
        boolean bl = success = worldPositions.entrySet().stream().allMatch(entry -> BagOfYurtingData.canBlockBeUnloadedAt((BlockPos)entry.getKey(), world, player)) && BagOfYurtingData.doesPlaceEventSucceed(context, world, player, worldPositions);
        if (success) {
            worldPositions.entrySet().stream().sorted(BlockUnloadSorter.INSTANCE).forEach(entry -> ((StateData)entry.getValue()).setBlockAndTE(world, (BlockPos)entry.getKey(), unrotation));
            if (world instanceof ServerWorld) {
                BagOfYurtingData.doPoofEffects((ServerWorld)world, worldPositions.keySet());
            }
        }
        return success;
    }

    private static void doPoofEffects(ServerWorld world, Collection<BlockPos> changedPositions) {
        AxisAlignedBB aabb = changedPositions.stream().map(AxisAlignedBB::new).reduce(AxisAlignedBB::func_111270_a).orElse(EMPTY_AABB);
        if (aabb.func_72320_b() > 0.5) {
            Vec3d center = aabb.func_189972_c();
            double xRadius = aabb.func_216364_b() * 0.5;
            double yRadius = aabb.func_216360_c() * 0.5;
            double zRadius = aabb.func_216362_d() * 0.5;
            double volume = xRadius * yRadius * zRadius * 8.0;
            int particles = Math.max(5000, (int)volume * 5);
            world.func_184133_a(null, new BlockPos(center), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_195598_a((IParticleData)ParticleTypes.field_197627_t, center.func_82615_a(), center.func_82617_b(), center.func_82616_c(), particles, xRadius, yRadius, zRadius, 0.0);
        }
    }

    private static boolean canBlockBeStored(ItemUseContext context, BlockPos pos) {
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        return !state.isAir((IBlockReader)context.func_195991_k(), pos) && !World.func_189509_E((BlockPos)pos) && BagOfYurtingData.isBlockYurtingAllowedByTags(player, state, pos) && BagOfYurtingData.doesBreakEventSucceed(world, pos, state, player);
    }

    private static boolean isBlockYurtingAllowedByTags(@Nullable PlayerEntity player, BlockState state, BlockPos pos) {
        if (player != null && (player.func_184812_l_() || player.func_211513_k(Config.INSTANCE.minPermissionToYurtUnyurtableBlocks.get().intValue()))) {
            return true;
        }
        return !state.func_203425_a((Tag)TagWrappers.blacklist) && (TagWrappers.whitelist.func_199885_a().isEmpty() || state.func_203425_a((Tag)TagWrappers.whitelist));
    }

    private static boolean doesBreakEventSucceed(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        PlayerEntity eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, eventPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static boolean doesPlaceEventSucceed(ItemUseContext context, World world, PlayerEntity player, Map<BlockPos, StateData> worldPositions) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        PlayerEntity eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        List snapshots = worldPositions.keySet().stream().map(pos -> new BlockSnapshot((IWorld)world, pos, world.func_180495_p(pos))).collect(Collectors.toList());
        BlockState statePlacedAgainst = world.func_180495_p(context.func_195995_a());
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(snapshots, statePlacedAgainst, (Entity)eventPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static BlockPos transformBlockPos(Direction orientation, BlockPos pos, BlockPos origin) {
        BlockPos offset = pos.func_177973_b((Vec3i)origin);
        return offset.func_190942_a(RotationUtil.getTransformRotation(orientation));
    }

    private static BlockPos untransformBlockPos(Rotation unrotation, BlockPos offset, BlockPos origin) {
        BlockPos unRotatedOffset = offset.func_190942_a(unrotation);
        return origin.func_177971_a((Vec3i)unRotatedOffset);
    }

    private static StateData getPosEntryAndRemoveBlock(ItemUseContext context, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        Rotation rotation = RotationUtil.getTransformRotation(context.func_195992_f());
        if (te != null) {
            te.func_189515_b(nbt);
        }
        world.func_175713_t(pos);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
        return new StateData(state.func_185907_a(rotation), nbt);
    }

    private static boolean canBlockBeUnloadedAt(BlockPos pos, World world, @Nonnull PlayerEntity player) {
        if (player != null && player.func_184812_l_() || player.func_211513_k(Config.INSTANCE.minPermissionToYurtUnyurtableBlocks.get().intValue())) {
            return true;
        }
        BlockState oldState = world.func_180495_p(pos);
        return oldState.isAir((IBlockReader)world, pos) || oldState.func_203425_a((Tag)TagWrappers.replaceable) || oldState.func_185904_a().func_76222_j();
    }

    public static boolean doesNBTContainYurtData(CompoundNBT nbt) {
        return !nbt.func_150295_c(NBT_KEY, 10).isEmpty();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public CompoundNBT writeIntoNBT(CompoundNBT nbt) {
        mapper.write(this.map, nbt);
        return nbt;
    }

    public static BagOfYurtingData read(CompoundNBT nbt) {
        return new BagOfYurtingData(mapper.read(nbt));
    }

    public static class StateData {
        public static final String BLOCKSTATE = "state";
        public static final String TILE = "te";
        @Nonnull
        private final BlockState state;
        @Nonnull
        private final CompoundNBT tileEntityData;

        public StateData(@Nonnull BlockState state, @Nonnull CompoundNBT tileEntityData) {
            this.state = state;
            this.tileEntityData = tileEntityData;
        }

        public BlockState getState() {
            return this.state;
        }

        public void setBlockAndTE(World world, BlockPos pos, Rotation unrotation) {
            TileEntity te;
            world.func_175656_a(pos, this.state.func_185907_a(unrotation));
            if (!this.tileEntityData.isEmpty() && (te = world.func_175625_s(pos)) != null) {
                te.func_145839_a(this.tileEntityData);
                te.func_226984_a_(world, pos);
            }
        }

        public CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a(BLOCKSTATE, (INBT)NBTUtil.func_190009_a((BlockState)this.state));
            nbt.func_218657_a(TILE, (INBT)this.tileEntityData);
            return nbt;
        }

        public static StateData read(CompoundNBT nbt) {
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l(BLOCKSTATE));
            CompoundNBT te = nbt.func_74775_l(TILE);
            return new StateData(state, te);
        }
    }
}

