/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.bagofyurting;

import com.github.commoble.bagofyurting.BagOfYurtingItem;
import com.github.commoble.bagofyurting.ItemRegistrar;
import com.github.commoble.bagofyurting.RecipeRegistrar;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class BagOfYurtingUpgradeRecipe
extends ShapedRecipe {
    private final int displayRadius;

    public BagOfYurtingUpgradeRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, int displayRadius) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.displayRadius = displayRadius;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeRegistrar.UPGRADE_RECIPE;
    }

    public ItemStack func_77571_b() {
        return ItemRegistrar.BAG_OF_YURTING.withRadius(super.func_77571_b(), this.displayRadius);
    }

    public ItemStack func_77572_b(CraftingInventory craftingSlots) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int slotCount = craftingSlots.func_70302_i_();
        for (int i = 0; i < slotCount; ++i) {
            stacks.add(craftingSlots.func_70301_a(i));
        }
        return this.getActualOutput(stacks);
    }

    public ItemStack getActualOutput(List<ItemStack> stacks) {
        ItemStack output = this.func_77571_b().func_77946_l();
        int bagRadius = Integer.MAX_VALUE;
        boolean foundBag = false;
        ArrayList<Integer> dyes = new ArrayList<Integer>();
        for (ItemStack stack : stacks) {
            Item item = stack.func_77973_b();
            if (!(item instanceof BagOfYurtingItem)) continue;
            foundBag = true;
            int newRadius = ItemRegistrar.BAG_OF_YURTING.getRadius(stack);
            if (ItemRegistrar.BAG_OF_YURTING.func_200883_f_(stack)) {
                dyes.add(ItemRegistrar.BAG_OF_YURTING.func_200886_f(stack));
            }
            if (newRadius >= bagRadius) continue;
            bagRadius = newRadius;
        }
        if (!foundBag) {
            bagRadius = 0;
        }
        ItemStack actualOutput = ItemRegistrar.BAG_OF_YURTING.withRadius(output, bagRadius + 1);
        int colors = dyes.size();
        if (colors > 0) {
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            Iterator iterator = dyes.iterator();
            while (iterator.hasNext()) {
                int color = (Integer)iterator.next();
                redSum += color >> 16 & 0xFF;
                greenSum += color >> 8 & 0xFF;
                blueSum += color & 0xFF;
            }
            int finalRed = redSum / colors << 16;
            int finalGreen = greenSum / colors << 8;
            int finalBlue = blueSum / colors & 0xFF;
            int finalColor = finalRed + finalGreen + finalBlue;
            ItemRegistrar.BAG_OF_YURTING.func_200885_a(actualOutput, finalColor);
        }
        return actualOutput;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public ShapedRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = super.func_199425_a_(recipeId, json);
            return new BagOfYurtingUpgradeRecipe(recipeId, recipe.func_193358_e(), recipe.func_192403_f(), recipe.func_192404_g(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b(), 1);
        }

        public ShapedRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe recipe = super.func_199426_a_(recipeId, buffer);
            return new BagOfYurtingUpgradeRecipe(recipeId, recipe.func_193358_e(), recipe.func_192403_f(), recipe.func_192404_g(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b(), 1);
        }
    }
}

