/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.bagofyurting.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class NBTMapHelper<K, KNBT extends INBT, V, VNBT extends INBT> {
    private static final String KEY = "k";
    private static final String VALUE = "v";
    private final String name;
    private final Function<K, KNBT> keyWriter;
    private final Function<KNBT, K> keyReader;
    private final Function<V, VNBT> valueWriter;
    private final Function<VNBT, V> valueReader;

    public NBTMapHelper(String name, Function<K, KNBT> keyWriter, Function<KNBT, K> keyReader, Function<V, VNBT> valueWriter, Function<VNBT, V> valueReader) {
        this.name = name;
        this.keyReader = keyReader;
        this.keyWriter = keyWriter;
        this.valueReader = valueReader;
        this.valueWriter = valueWriter;
    }

    public boolean hasData(CompoundNBT nbt) {
        return nbt.func_74764_b(this.name);
    }

    public Map<K, V> read(CompoundNBT nbt) {
        HashMap newMap = new HashMap();
        ListNBT entryList = nbt.func_150295_c(this.name, 10);
        if (entryList == null) {
            return newMap;
        }
        int entryCount = entryList.size();
        if (entryCount <= 0) {
            return newMap;
        }
        IntStream.range(0, entryCount).mapToObj(i -> entryList.func_150305_b(i)).forEach(entryNBT -> this.writeEntry(newMap, (CompoundNBT)entryNBT));
        return newMap;
    }

    private void writeEntry(Map<K, V> map, CompoundNBT entryNBT) {
        K key = this.keyReader.apply(entryNBT.func_74781_a(KEY));
        V value = this.valueReader.apply(entryNBT.func_74781_a(VALUE));
        map.put(key, value);
    }

    public CompoundNBT write(Map<K, V> map, CompoundNBT compound) {
        ListNBT entryListNBT = new ListNBT();
        map.entrySet().forEach(entry -> this.writeEntry(entryListNBT, (Map.Entry<K, V>)entry));
        compound.func_218657_a(this.name, (INBT)entryListNBT);
        return compound;
    }

    private void writeEntry(ListNBT entryListNBT, Map.Entry<K, V> entry) {
        CompoundNBT entryNBT = new CompoundNBT();
        entryNBT.func_218657_a(KEY, (INBT)this.keyWriter.apply(entry.getKey()));
        entryNBT.func_218657_a(VALUE, (INBT)this.valueWriter.apply(entry.getValue()));
        entryListNBT.add((Object)entryNBT);
    }
}

