/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.bagofyurting;

import com.github.commoble.bagofyurting.BagOfYurtingData;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BagOfYurtingItem
extends Item
implements IDyeableArmorItem {
    public static final String RADIUS_KEY = "radius";
    public static final int UNDYED_COLOR = 0xFFFFFF;

    public BagOfYurtingItem(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77636_d(ItemStack stack) {
        return BagOfYurtingItem.getDataReader(stack) != null;
    }

    public int getRadius(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(RADIUS_KEY);
    }

    public int getDiameter(ItemStack stack) {
        return this.getRadius(stack) * 2 + 1;
    }

    public ItemStack withRadius(ItemStack stack, int radius) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_196082_o().func_74768_a(RADIUS_KEY, radius);
        return newStack;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (int i = 0; i < 7; ++i) {
                items.add((Object)this.withRadius(new ItemStack((IItemProvider)this), i));
            }
        }
    }

    @Nullable
    public static Supplier<BagOfYurtingData> getDataReader(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (BagOfYurtingData.doesNBTContainYurtData(nbt)) {
            return () -> BagOfYurtingData.read(nbt);
        }
        return null;
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : 0xFFFFFF;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().func_201670_d()) {
            Supplier<BagOfYurtingData> dataGetter = BagOfYurtingItem.getDataReader(context.func_195996_i());
            if (dataGetter == null) {
                this.loadBag(context);
            } else {
                this.unloadBag(context, dataGetter.get());
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void loadBag(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        ItemStack oldStack = context.func_195999_j().func_184586_b(hand);
        BagOfYurtingData data = BagOfYurtingData.yurtBlocksAndConvertToData(context, this.getRadius(oldStack));
        if (!data.isEmpty()) {
            ItemStack newStack = oldStack.func_77946_l();
            data.writeIntoNBT(newStack.func_196082_o());
            context.func_195999_j().func_184611_a(context.func_221531_n(), newStack);
        } else {
            context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("bagofyurting.failure.load"), true);
        }
    }

    public void unloadBag(ItemUseContext context, BagOfYurtingData data) {
        Hand hand = context.func_221531_n();
        ItemStack oldStack = context.func_195999_j().func_184586_b(hand);
        boolean success = data.attemptUnloadIntoWorld(context, this.getRadius(oldStack));
        if (success) {
            ItemStack newStack = oldStack.func_77946_l();
            newStack.func_196082_o().func_218657_a("yurtdata", (INBT)new CompoundNBT());
            context.func_195999_j().func_184611_a(context.func_221531_n(), newStack);
        } else {
            context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("bagofyurting.failure.unload"), true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int diameter = this.getDiameter(stack);
        String sizeText = String.format("%sx%sx%s", diameter, diameter, diameter);
        tooltip.add((ITextComponent)new StringTextComponent(sizeText).func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GRAY)));
    }
}

