/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bandits;

import java.util.function.Supplier;
import net.mcreator.bandits.BanditsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class BanditsModVariables {

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            this.data.func_76184_a(buffer.func_150793_b());
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(WorldSavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isServer()) {
                    WorldSavedDataSyncMessage.syncData(message, context.getDirection().getReceptionSide(), context.getSender().field_70170_p);
                } else {
                    WorldSavedDataSyncMessage.syncData(message, context.getDirection().getReceptionSide(), Minecraft.func_71410_x().field_71439_g.field_70170_p);
                }
            });
            context.setPacketHandled(true);
        }

        private static void syncData(WorldSavedDataSyncMessage message, LogicalSide side, World world) {
            if (side.isServer()) {
                message.data.func_76185_a();
                if (message.type == 0) {
                    BanditsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)message);
                    world.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215757_a(message.data);
                } else {
                    BanditsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Dimension)world.field_73011_w).func_186058_p()), (Object)message);
                    ((ServerWorld)world).func_217481_x().func_215757_a(message.data);
                }
            } else if (message.type == 0) {
                MapVariables.clientSide = (MapVariables)message.data;
            } else {
                WorldVariables.clientSide = (WorldVariables)message.data;
            }
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "bandits_mapvars";
        public String axeBlocks = "Cocoa, Jack o'Lantern, Pumpkin, Vines, Melon, Bee Nest, Brown Mushroom Block, Red Mushroom Block, Mushroom Stem, White Banner, Orange Banner, Magenta Banner, Light Blue Banner, Yellow Banner, Lime Banner, Pink Banner, Gray Banner, Light Gray Banner, Cyan Banner, Purple Banner, Blue Banner, Brown Banner, Green Banner, Red Banner, Black Banner, White Wall Banner, Orange Wall Banner, Magenta Wall Banner, Light Blue Wall Banner, Yellow Wall Banner, Lime Wall Banner, Pink Wall Banner, Gray Wall Banner, Light Gray Wall Banner, Cyan Wall Banner, Purple Wall Banner, Blue Wall Banner, Brown Wall Banner, Green Wall Banner, Red Wall Banner, Black Wall Banner, Oak Wood, Spruce Wood, Birch Wood, Jungle Wood, Acacia Wood, Dark Oak Wood, Crimson Hyphae, Warped Hyphae, Stripped Oak Wood, Stripped Spruce Wood, Stripped Birch Wood, Stripped Jungle Wood, Stripped Acacia Wood, Stripped Dark Oak Wood, Stripped Crimson Hyphae, Stripped Warped Hyphae";
        public boolean BanditAwake = true;
        public boolean banditBuilding = true;
        public boolean disableAmbushes = false;
        public double gracePeriod = 0.0;
        public String hoeBlocks = "Nether Wart Block, Warped Wart Block, Shroomlight, Hay Bale, Target, Dried Kelp Block, Sponge, Wet Sponge, Oak Leaves, Spruce Leaves, Birch Leaves, Jungle Leaves, Acacia Leaves, Dark Oak Leaves";
        public String pickaxeBlocks = "Obsidian, Ancient Debris, Crying Obsidian, Respawn Anchor, Ender Chest, Anvil, Block of Coal, Block of Diamond, Block of Netherite, Block of Emerald, Block of Iron, Block of Redstone, Enchantment Table, Iron Bars, Iron Door, Iron Trapdoor, Monster Spawner, Bell, Dispenser, Dropper, Observer, Furnace, Blast furnace, Smoker, Stonecutter, Lodestone, Smoker, Stonecutter, Lodestone, Lantern, Conduit, Block of Gold, Coal Ore, Dragon Egg, Diamond Ore, Emerald Ore, End Stone, Gold Ore, Hopper, Iron Ore, Lapis Lazuli Block, Lapis Lazuli Ore, Nether Quartz Ore, Nether Gold Ore, Redstone Ore, Grindstone, Bone Block, Brick Stairs, Bricks, Cauldron, Cobblestone, Cobblestone Stairs, Cobblestone Wall, Mossy Cobblestone, Nether Bricks, Red Nether Bricks, Nether Brick Fence, Nether Brick Stairs, Oak Slab, Spruce Slab, Birch Slab, Jungle Slab, Acacia Slab, Dark Oak Slab, Crimson Slab, Warped Slab, Stone Slab, Smooth Stone Slab, Granite Slab, Polished Granite Slab, Diorite Slab, Polished Diorite Slab, Andesite Slab, Polished Andesite Slab, Cobblestone Slab, Mossy Cobblestone Slab, Stone Brick Slab, Mossy Stone Brick Slab, Brick Slab, End Stone Brick Slab, Nether Brick Slab, Red Nether Brick Slab, Sandstone Slab, Cut Sandstone Slab, Smooth Sandstone Slab, Red Sandstone Slab, Cut Red Sandstone Slab, Smooth Red Sandstone Slab, Quartz Slab, Smooth Quartz Slab, Purpur Slab, Prismarine Slab, Prismarine Brick Slab, Dark Prismarine Slab, Petrified Oak Slab, Blackstone Slab, Polished Blackstone Slab, Polished Blackstone Brick Slab";
        public String shovelBlocks = "Clay, Farmland, Grass Block, Grass Path, Gravel,  Mycelium, Podzol, Coarse Dirt, Dirt, Red Sand, Sand, Soul Sand, Soul Soil, White Concrete Powder, Orange Concrete Powder, Magenta Concrete Powder, Light Blue Concrete Powder, Yellow Concrete Powder, Lime Concrete Powder, Pink Concrete Powder, Gray Concrete Powder, Light Gray Concrete Powder, Cyan Concrete Powder, Purple Concrete Powder, Blue Concrete Powder, Brown Concrete Powder, Green Concrete Powder, Red Concrete Powder, Black Concrete Powder";
        public String swordBlocks = "Bamboo, Cobweb";
        public double warPeriod = -1.0;
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.axeBlocks = nbt.func_74779_i("axeBlocks");
            this.BanditAwake = nbt.func_74767_n("BanditAwake");
            this.banditBuilding = nbt.func_74767_n("banditBuilding");
            this.disableAmbushes = nbt.func_74767_n("disableAmbushes");
            this.gracePeriod = nbt.func_74769_h("gracePeriod");
            this.hoeBlocks = nbt.func_74779_i("hoeBlocks");
            this.pickaxeBlocks = nbt.func_74779_i("pickaxeBlocks");
            this.shovelBlocks = nbt.func_74779_i("shovelBlocks");
            this.swordBlocks = nbt.func_74779_i("swordBlocks");
            this.warPeriod = nbt.func_74769_h("warPeriod");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74778_a("axeBlocks", this.axeBlocks);
            nbt.func_74757_a("BanditAwake", this.BanditAwake);
            nbt.func_74757_a("banditBuilding", this.banditBuilding);
            nbt.func_74757_a("disableAmbushes", this.disableAmbushes);
            nbt.func_74780_a("gracePeriod", this.gracePeriod);
            nbt.func_74778_a("hoeBlocks", this.hoeBlocks);
            nbt.func_74778_a("pickaxeBlocks", this.pickaxeBlocks);
            nbt.func_74778_a("shovelBlocks", this.shovelBlocks);
            nbt.func_74778_a("swordBlocks", this.swordBlocks);
            nbt.func_74780_a("warPeriod", this.warPeriod);
            return nbt;
        }

        public void syncData(World world) {
            this.func_76185_a();
            if (world.field_72995_K) {
                BanditsMod.PACKET_HANDLER.sendToServer((Object)new WorldSavedDataSyncMessage(0, this));
            } else {
                BanditsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(World world) {
            if (world instanceof ServerWorld) {
                return (MapVariables)world.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "bandits_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            return nbt;
        }

        public void syncData(World world) {
            this.func_76185_a();
            if (world.field_72995_K) {
                BanditsMod.PACKET_HANDLER.sendToServer((Object)new WorldSavedDataSyncMessage(1, this));
            } else {
                BanditsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Dimension)world.field_73011_w).func_186058_p()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(World world) {
            if (world instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

