/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui;

import io.github.cottonmc.cotton.gui.EmptyInventory;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.PropertyDelegateHolder;
import io.github.cottonmc.cotton.gui.ValidatedSlot;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlayerInvPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3954;

public class SyncedGuiDescription
extends class_1703
implements GuiDescription {
    protected class_1263 blockInventory;
    protected class_1661 playerInventory;
    protected class_1937 world;
    protected class_3913 propertyDelegate;
    protected WPanel rootPanel = new WGridPanel();
    protected int titleColor = 0x404040;
    protected int darkTitleColor = 0xBCBCBC;
    protected boolean fullscreen = false;
    protected boolean titleVisible = true;
    protected HorizontalAlignment titleAlignment = HorizontalAlignment.LEFT;
    protected WWidget focus;

    public SyncedGuiDescription(class_3917<?> type, int syncId, class_1661 playerInventory) {
        super(type, syncId);
        this.blockInventory = null;
        this.playerInventory = playerInventory;
        this.world = playerInventory.field_7546.field_6002;
        this.propertyDelegate = null;
    }

    public SyncedGuiDescription(class_3917<?> type, int syncId, class_1661 playerInventory, class_1263 blockInventory, class_3913 propertyDelegate) {
        super(type, syncId);
        this.blockInventory = blockInventory;
        this.playerInventory = playerInventory;
        this.world = playerInventory.field_7546.field_6002;
        this.propertyDelegate = propertyDelegate;
        if (propertyDelegate != null && propertyDelegate.method_17389() > 0) {
            this.method_17360(propertyDelegate);
        }
    }

    @Override
    public WPanel getRootPanel() {
        return this.rootPanel;
    }

    @Override
    public int getTitleColor() {
        return this.world.field_9236 && LibGuiClient.config.darkMode ? this.darkTitleColor : this.titleColor;
    }

    @Override
    public SyncedGuiDescription setRootPanel(WPanel panel) {
        this.rootPanel = panel;
        return this;
    }

    @Override
    public SyncedGuiDescription setTitleColor(int color) {
        this.titleColor = color;
        this.darkTitleColor = color == 0x404040 ? 0xBCBCBC : color;
        return this;
    }

    @Override
    public SyncedGuiDescription setTitleColor(int lightColor, int darkColor) {
        this.titleColor = lightColor;
        this.darkTitleColor = darkColor;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
        if (this.rootPanel != null && !this.fullscreen) {
            this.rootPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
        }
    }

    @Override
    public void addSlotPeer(ValidatedSlot slot) {
        this.method_7621(slot);
    }

    public class_1799 method_7593(int slotNumber, int button, class_1713 action, class_1657 player) {
        if (action == class_1713.field_7794) {
            if (slotNumber < 0) {
                return class_1799.field_8037;
            }
            if (slotNumber >= this.field_7761.size()) {
                return class_1799.field_8037;
            }
            class_1735 slot = (class_1735)this.field_7761.get(slotNumber);
            if (slot == null || !slot.method_7674(player)) {
                return class_1799.field_8037;
            }
            class_1799 remaining = class_1799.field_8037;
            if (slot != null && slot.method_7681()) {
                class_1799 toTransfer = slot.method_7677();
                remaining = toTransfer.method_7972();
                if (this.blockInventory != null ? (slot.field_7871 == this.blockInventory ? !this.insertItem(toTransfer, (class_1263)this.playerInventory, true, player) : !this.insertItem(toTransfer, this.blockInventory, false, player)) : !this.swapHotbar(toTransfer, slotNumber, (class_1263)this.playerInventory, player)) {
                    return class_1799.field_8037;
                }
                if (toTransfer.method_7960()) {
                    slot.method_7673(class_1799.field_8037);
                } else {
                    slot.method_7668();
                }
            }
            return remaining;
        }
        return super.method_7593(slotNumber, button, action, player);
    }

    private boolean insertIntoExisting(class_1799 toInsert, class_1735 slot, class_1657 player) {
        class_1799 curSlotStack = slot.method_7677();
        if (!curSlotStack.method_7960() && SyncedGuiDescription.method_7612((class_1799)toInsert, (class_1799)curSlotStack) && slot.method_7674(player)) {
            int combinedAmount = curSlotStack.method_7947() + toInsert.method_7947();
            if (combinedAmount <= toInsert.method_7914()) {
                toInsert.method_7939(0);
                curSlotStack.method_7939(combinedAmount);
                slot.method_7668();
                return true;
            }
            if (curSlotStack.method_7947() < toInsert.method_7914()) {
                toInsert.method_7934(toInsert.method_7914() - curSlotStack.method_7947());
                curSlotStack.method_7939(toInsert.method_7914());
                slot.method_7668();
                return true;
            }
        }
        return false;
    }

    private boolean insertIntoEmpty(class_1799 toInsert, class_1735 slot) {
        class_1799 curSlotStack = slot.method_7677();
        if (curSlotStack.method_7960() && slot.method_7680(toInsert)) {
            if (toInsert.method_7947() > slot.method_7675()) {
                slot.method_7673(toInsert.method_7971(slot.method_7675()));
            } else {
                slot.method_7673(toInsert.method_7971(toInsert.method_7947()));
            }
            slot.method_7668();
            return true;
        }
        return false;
    }

    private boolean insertItem(class_1799 toInsert, class_1263 inventory, boolean walkBackwards, class_1657 player) {
        boolean inserted;
        block19: {
            class_1735 curSlot;
            int i;
            ArrayList<class_1735> inventorySlots = new ArrayList<class_1735>();
            for (class_1735 slot : this.field_7761) {
                if (slot.field_7871 != inventory) continue;
                inventorySlots.add(slot);
            }
            if (inventorySlots.isEmpty()) {
                return false;
            }
            inserted = false;
            if (walkBackwards) {
                for (i = inventorySlots.size() - 1; i >= 0; --i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoExisting(toInsert, curSlot, player)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < inventorySlots.size(); ++i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoExisting(toInsert, curSlot, player)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            }
            if (toInsert.method_7960()) break block19;
            if (walkBackwards) {
                for (i = inventorySlots.size() - 1; i >= 0; --i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoEmpty(toInsert, curSlot)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < inventorySlots.size(); ++i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoEmpty(toInsert, curSlot)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            }
        }
        return inserted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean swapHotbar(class_1799 toInsert, int slotNumber, class_1263 inventory, class_1657 player) {
        class_1735 curSlot;
        ArrayList<class_1735> storageSlots = new ArrayList<class_1735>();
        ArrayList<class_1735> hotbarSlots = new ArrayList<class_1735>();
        boolean swapToStorage = true;
        boolean inserted = false;
        for (class_1735 slot : this.field_7761) {
            if (slot.field_7871 != inventory || !(slot instanceof ValidatedSlot)) continue;
            int index = ((ValidatedSlot)slot).getInventoryIndex();
            if (class_1661.method_7380((int)index)) {
                hotbarSlots.add(slot);
                continue;
            }
            storageSlots.add(slot);
            if (index != slotNumber) continue;
            swapToStorage = false;
        }
        if (storageSlots.isEmpty() || hotbarSlots.isEmpty()) {
            return false;
        }
        if (swapToStorage) {
            int i;
            for (i = 0; i < storageSlots.size(); ++i) {
                curSlot = (class_1735)storageSlots.get(i);
                if (this.insertIntoExisting(toInsert, curSlot, player)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) break;
            }
            if (toInsert.method_7960()) return inserted;
            for (i = 0; i < storageSlots.size(); ++i) {
                curSlot = (class_1735)storageSlots.get(i);
                if (this.insertIntoEmpty(toInsert, curSlot)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) return inserted;
            }
            return inserted;
        } else {
            int i;
            for (i = 0; i < hotbarSlots.size(); ++i) {
                curSlot = (class_1735)hotbarSlots.get(i);
                if (this.insertIntoExisting(toInsert, curSlot, player)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) break;
            }
            if (toInsert.method_7960()) return inserted;
            for (i = 0; i < hotbarSlots.size(); ++i) {
                curSlot = (class_1735)hotbarSlots.get(i);
                if (this.insertIntoEmpty(toInsert, curSlot)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) return inserted;
            }
        }
        return inserted;
    }

    @Nullable
    public WWidget doMouseUp(int x, int y, int state) {
        if (this.rootPanel != null) {
            return this.rootPanel.onMouseUp(x, y, state);
        }
        return null;
    }

    @Nullable
    public WWidget doMouseDown(int x, int y, int button) {
        if (this.rootPanel != null) {
            return this.rootPanel.onMouseDown(x, y, button);
        }
        return null;
    }

    public void doMouseDrag(int x, int y, int button, double deltaX, double deltaY) {
        if (this.rootPanel != null) {
            this.rootPanel.onMouseDrag(x, y, button, deltaX, deltaY);
        }
    }

    public void doClick(int x, int y, int button) {
        if (this.focus != null) {
            int wx = this.focus.getAbsoluteX();
            int wy = this.focus.getAbsoluteY();
            if (x < wx || x >= wx + this.focus.getWidth() || y < wy || y >= wy + this.focus.getHeight()) {
                WWidget lastFocus = this.focus;
                this.focus = null;
                lastFocus.onFocusLost();
            }
        }
    }

    public void doCharType(char ch) {
        if (this.focus != null) {
            this.focus.onCharTyped(ch);
        }
    }

    @Override
    @Nullable
    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    @Override
    public GuiDescription setPropertyDelegate(class_3913 delegate) {
        this.propertyDelegate = delegate;
        return this;
    }

    public WPlayerInvPanel createPlayerInventoryPanel() {
        return new WPlayerInvPanel(this.playerInventory);
    }

    public WPlayerInvPanel createPlayerInventoryPanel(boolean hasLabel) {
        return new WPlayerInvPanel(this.playerInventory, hasLabel);
    }

    public WPlayerInvPanel createPlayerInventoryPanel(WWidget label) {
        return new WPlayerInvPanel(this.playerInventory, label);
    }

    public static class_1263 getBlockInventory(class_3914 ctx) {
        return SyncedGuiDescription.getBlockInventory(ctx, () -> EmptyInventory.INSTANCE);
    }

    public static class_1263 getBlockInventory(class_3914 ctx, int size) {
        return SyncedGuiDescription.getBlockInventory(ctx, () -> new class_1277(size));
    }

    private static class_1263 getBlockInventory(class_3914 ctx, Supplier<class_1263> fallback) {
        return ctx.method_17395((world, pos) -> {
            class_1278 inventory;
            class_2680 state = world.method_8320(pos);
            class_2248 b = state.method_26204();
            if (b instanceof class_3954 && (inventory = ((class_3954)b).method_17680(state, (class_1936)world, pos)) != null) {
                return inventory;
            }
            class_2586 be = world.method_8321(pos);
            if (be != null) {
                if (be instanceof class_3954) {
                    class_1278 inventory2 = ((class_3954)be).method_17680(state, (class_1936)world, pos);
                    if (inventory2 != null) {
                        return inventory2;
                    }
                } else if (be instanceof class_1263) {
                    return (class_1263)be;
                }
            }
            return (class_1263)fallback.get();
        }).orElseGet(fallback);
    }

    public static class_3913 getBlockPropertyDelegate(class_3914 ctx) {
        return (class_3913)ctx.method_17395((world, pos) -> {
            class_2586 be = world.method_8321(pos);
            if (be != null && be instanceof PropertyDelegateHolder) {
                return ((PropertyDelegateHolder)be).getPropertyDelegate();
            }
            return new class_3919(0);
        }).orElse(new class_3919(0));
    }

    public static class_3913 getBlockPropertyDelegate(class_3914 ctx, int size) {
        return (class_3913)ctx.method_17395((world, pos) -> {
            class_2586 be = world.method_8321(pos);
            if (be != null && be instanceof PropertyDelegateHolder) {
                return ((PropertyDelegateHolder)be).getPropertyDelegate();
            }
            return new class_3919(size);
        }).orElse(new class_3919(size));
    }

    public boolean method_7597(class_1657 entity) {
        return this.blockInventory != null ? this.blockInventory.method_5443(entity) : true;
    }

    @Override
    public boolean isFocused(WWidget widget) {
        return this.focus == widget;
    }

    @Override
    public WWidget getFocus() {
        return this.focus;
    }

    @Override
    public void requestFocus(WWidget widget) {
        if (this.focus == widget) {
            return;
        }
        if (!widget.canFocus()) {
            return;
        }
        if (this.focus != null) {
            this.focus.onFocusLost();
        }
        this.focus = widget;
        this.focus.onFocusGained();
    }

    @Override
    public void releaseFocus(WWidget widget) {
        if (this.focus == widget) {
            this.focus = null;
            widget.onFocusLost();
        }
    }

    @Override
    public boolean isFullscreen() {
        return this.fullscreen;
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    @Override
    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    @Override
    public void setTitleVisible(boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    @Override
    public HorizontalAlignment getTitleAlignment() {
        return this.titleAlignment;
    }

    @Override
    public void setTitleAlignment(HorizontalAlignment titleAlignment) {
        this.titleAlignment = titleAlignment;
    }
}

