/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.client.NinePatch;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import net.minecraft.class_2960;

@FunctionalInterface
public interface BackgroundPainter {
    public static final BackgroundPainter VANILLA = BackgroundPainter.createLightDarkVariants(BackgroundPainter.createNinePatch(new class_2960("libgui", "textures/widget/panel_light.png"), 8), BackgroundPainter.createNinePatch(new class_2960("libgui", "textures/widget/panel_dark.png"), 8));
    public static final BackgroundPainter SLOT = (left, top, panel) -> {
        if (!(panel instanceof WItemSlot)) {
            ScreenDrawing.drawBeveledPanel(left - 1, top - 1, panel.getWidth() + 2, panel.getHeight() + 2, -1207959552, 0x4C000000, -1191182337);
        } else {
            WItemSlot slot = (WItemSlot)panel;
            for (int x = 0; x < slot.getWidth() / 18; ++x) {
                for (int y = 0; y < slot.getHeight() / 18; ++y) {
                    int sy;
                    int sx;
                    int index = x + y * (slot.getWidth() / 18);
                    int lo = -1207959552;
                    int bg = 0x4C000000;
                    int hi = -1191182337;
                    if (slot.isBigSlot()) {
                        ScreenDrawing.drawBeveledPanel(x * 18 + left - 3, y * 18 + top - 3, 26, 26, lo, bg, hi);
                        if (slot.getFocusedSlot() != index) continue;
                        sx = x * 18 + left - 3;
                        sy = y * 18 + top - 3;
                        ScreenDrawing.coloredRect(sx, sy, 26, 1, -96);
                        ScreenDrawing.coloredRect(sx, sy + 1, 1, 25, -96);
                        ScreenDrawing.coloredRect(sx + 26 - 1, sy + 1, 1, 25, -96);
                        ScreenDrawing.coloredRect(sx + 1, sy + 26 - 1, 25, 1, -96);
                        continue;
                    }
                    ScreenDrawing.drawBeveledPanel(x * 18 + left, y * 18 + top, 18, 18, lo, bg, hi);
                    if (slot.getFocusedSlot() != index) continue;
                    sx = x * 18 + left;
                    sy = y * 18 + top;
                    ScreenDrawing.coloredRect(sx, sy, 18, 1, -96);
                    ScreenDrawing.coloredRect(sx, sy + 1, 1, 17, -96);
                    ScreenDrawing.coloredRect(sx + 18 - 1, sy + 1, 1, 17, -96);
                    ScreenDrawing.coloredRect(sx + 1, sy + 18 - 1, 17, 1, -96);
                }
            }
        }
    };

    public void paintBackground(int var1, int var2, WWidget var3);

    public static BackgroundPainter createColorful(int panelColor) {
        return (left, top, panel) -> ScreenDrawing.drawGuiPanel(left - 8, top - 8, panel.getWidth() + 16, panel.getHeight() + 16, panelColor);
    }

    public static BackgroundPainter createColorful(int panelColor, float contrast) {
        return (left, top, panel) -> {
            int shadowColor = ScreenDrawing.multiplyColor(panelColor, 1.0f - contrast);
            int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.0f + contrast);
            ScreenDrawing.drawGuiPanel(left - 8, top - 8, panel.getWidth() + 16, panel.getHeight() + 16, shadowColor, panelColor, hilightColor, -16777216);
        };
    }

    public static NinePatch createNinePatch(class_2960 texture) {
        return new NinePatch(texture);
    }

    public static NinePatch createNinePatch(class_2960 texture, int padding) {
        return new NinePatch(texture).setPadding(padding);
    }

    public static BackgroundPainter createLightDarkVariants(BackgroundPainter light, BackgroundPainter dark) {
        return (left, top, panel) -> {
            if (LibGuiClient.config.darkMode) {
                dark.paintBackground(left, top, panel);
            } else {
                light.paintBackground(left, top, panel);
            }
        };
    }
}

