/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public enum CottonHud implements HudRenderCallback
{
    INSTANCE;

    private final Set<WWidget> widgets = new HashSet<WWidget>();
    private final Map<WWidget, Positioner> positioners = new HashMap<WWidget, Positioner>();

    public void add(WWidget widget) {
        this.widgets.add(widget);
    }

    public void add(WWidget widget, int x, int y) {
        this.add(widget, Positioner.of(x, y));
    }

    public void add(WWidget widget, int x, int y, int width, int height) {
        this.add(widget, Positioner.of(x, y));
        widget.setSize(width, height);
    }

    public void add(WWidget widget, Positioner positioner) {
        this.widgets.add(widget);
        this.setPositioner(widget, positioner);
    }

    public void add(WWidget widget, Positioner positioner, int width, int height) {
        this.widgets.add(widget);
        widget.setSize(width, height);
        this.setPositioner(widget, positioner);
    }

    public void setPositioner(WWidget widget, Positioner positioner) {
        this.positioners.put(widget, positioner);
    }

    public void remove(WWidget widget) {
        this.widgets.remove(widget);
    }

    public void onHudRender(class_4587 matrices, float tickDelta) {
        class_1041 window = class_310.method_1551().method_22683();
        int hudWidth = window.method_4486();
        int hudHeight = window.method_4502();
        for (WWidget widget : this.widgets) {
            Positioner positioner = this.positioners.get(widget);
            if (positioner != null) {
                positioner.reposition(widget, hudWidth, hudHeight);
            }
            widget.paint(matrices, widget.getX(), widget.getY(), -1, -1);
        }
    }

    static {
        HudRenderCallback.EVENT.register((Object)INSTANCE);
    }

    @FunctionalInterface
    public static interface Positioner {
        public void reposition(WWidget var1, int var2, int var3);

        public static Positioner of(int x, int y) {
            return (widget, hudWidth, hudHeight) -> widget.setLocation((hudWidth + x) % hudWidth, (hudHeight + y) % hudHeight);
        }

        public static Positioner horizontallyCentered(int y) {
            return (widget, hudWidth, hudHeight) -> widget.setLocation((hudWidth - widget.getWidth()) / 2, (hudHeight + y) % hudHeight);
        }
    }
}

