/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import io.github.cottonmc.cotton.gui.client.LibGuiConfig;
import io.github.cottonmc.cotton.gui.client.NinePatch;
import io.github.cottonmc.jankson.JanksonFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibGuiClient
implements ClientModInitializer {
    public static final Logger logger = LogManager.getLogger();
    public static final String MODID = "libgui";
    public static volatile LibGuiConfig config;
    public static final Jankson jankson;

    public void onInitializeClient() {
        config = LibGuiClient.loadConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)NinePatch.MetadataLoader.INSTANCE);
    }

    public static LibGuiConfig loadConfig() {
        try {
            File file = new File(FabricLoader.getInstance().getConfigDirectory(), "libgui.json5");
            if (!file.exists()) {
                LibGuiClient.saveConfig(new LibGuiConfig());
            }
            JsonObject json = jankson.load(file);
            config = (LibGuiConfig)jankson.fromJson(json, LibGuiConfig.class);
        }
        catch (Exception e) {
            logger.error("[LibGui] Error loading config: {}", (Object)e.getMessage());
        }
        return config;
    }

    public static void saveConfig(LibGuiConfig config) {
        try {
            File file = new File(FabricLoader.getInstance().getConfigDirectory(), "libgui.json5");
            JsonElement json = jankson.toJson((Object)config);
            String result = json.toJson(true, true);
            try (FileOutputStream out = new FileOutputStream(file, false);){
                out.write(result.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            logger.error("[LibGui] Error saving config: {}", (Object)e.getMessage());
        }
    }

    static {
        jankson = JanksonFactory.createJankson();
    }
}

