/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

@Environment(value=EnvType.CLIENT)
public class NinePatch
implements BackgroundPainter {
    private final class_2960 texture;
    private final int cornerSize;
    private final float cornerUv;
    private int topPadding = 0;
    private int leftPadding = 0;
    private int bottomPadding = 0;
    private int rightPadding = 0;
    private Mode mode = null;

    public NinePatch(class_2960 texture) {
        this(texture, 4, 0.25f);
    }

    public NinePatch(class_2960 texture, int cornerSize, float cornerUv) {
        this.texture = texture;
        this.cornerSize = cornerSize;
        this.cornerUv = cornerUv;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public NinePatch setTopPadding(int topPadding) {
        this.topPadding = topPadding;
        return this;
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public NinePatch setLeftPadding(int leftPadding) {
        this.leftPadding = leftPadding;
        return this;
    }

    public int getBottomPadding() {
        return this.bottomPadding;
    }

    public NinePatch setBottomPadding(int bottomPadding) {
        this.bottomPadding = bottomPadding;
        return this;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public NinePatch setRightPadding(int rightPadding) {
        this.rightPadding = rightPadding;
        return this;
    }

    public NinePatch setPadding(int padding) {
        this.bottomPadding = this.rightPadding = padding;
        this.leftPadding = this.rightPadding;
        this.topPadding = this.rightPadding;
        return this;
    }

    public NinePatch setPadding(int vertical, int horizontal) {
        this.topPadding = this.bottomPadding = vertical;
        this.leftPadding = this.rightPadding = horizontal;
        return this;
    }

    public NinePatch setPadding(int topPadding, int leftPadding, int bottomPadding, int rightPadding) {
        this.topPadding = topPadding;
        this.leftPadding = leftPadding;
        this.bottomPadding = bottomPadding;
        this.rightPadding = rightPadding;
        return this;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    @Nullable
    public Mode getMode() {
        return this.mode;
    }

    public NinePatch setMode(@Nullable Mode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public void paintBackground(int left, int top, WWidget panel) {
        int width = panel.getWidth() + this.leftPadding + this.rightPadding;
        int height = panel.getHeight() + this.topPadding + this.bottomPadding;
        int x1 = (left -= this.leftPadding) + this.cornerSize;
        int x2 = left + width - this.cornerSize;
        int y1 = (top -= this.topPadding) + this.cornerSize;
        int y2 = top + height - this.cornerSize;
        float uv1 = this.cornerUv;
        float uv2 = 1.0f - this.cornerUv;
        Mode mode = this.mode != null ? this.mode : MetadataLoader.INSTANCE.getProperties(this.texture).getMode();
        ScreenDrawing.texturedRect(left, top, this.cornerSize, this.cornerSize, this.texture, 0.0f, 0.0f, uv1, uv1, -1);
        ScreenDrawing.texturedRect(x2, top, this.cornerSize, this.cornerSize, this.texture, uv2, 0.0f, 1.0f, uv1, -1);
        ScreenDrawing.texturedRect(left, y2, this.cornerSize, this.cornerSize, this.texture, 0.0f, uv2, uv1, 1.0f, -1);
        ScreenDrawing.texturedRect(x2, y2, this.cornerSize, this.cornerSize, this.texture, uv2, uv2, 1.0f, 1.0f, -1);
        if (mode == Mode.TILING) {
            int tileSize = (int)((float)this.cornerSize / this.cornerUv - (float)(2 * this.cornerSize));
            int widthLeft = width - 2 * this.cornerSize;
            int heightLeft = height - 2 * this.cornerSize;
            int tileCountX = class_3532.method_15386((float)((float)widthLeft / (float)tileSize));
            int tileCountY = class_3532.method_15386((float)((float)heightLeft / (float)tileSize));
            for (int i = 0; i < tileCountX; ++i) {
                float px = 0.0625f;
                int tileWidth = Math.min(widthLeft, tileSize);
                float uo = (float)(tileSize - tileWidth) * px;
                ScreenDrawing.texturedRect(x1 + i * tileSize, top, tileWidth, this.cornerSize, this.texture, uv1, 0.0f, uv2 - uo, uv1, -1);
                ScreenDrawing.texturedRect(x1 + i * tileSize, y2, tileWidth, this.cornerSize, this.texture, uv1, uv2, uv2 - uo, 1.0f, -1);
                heightLeft = height - 2 * this.cornerSize;
                for (int j = 0; j < tileCountY; ++j) {
                    int tileHeight = Math.min(heightLeft, tileSize);
                    float vo = (float)(tileSize - tileHeight) * px;
                    ScreenDrawing.texturedRect(left, y1 + j * tileSize, this.cornerSize, tileHeight, this.texture, 0.0f, uv1, uv1, uv2 - vo, -1);
                    ScreenDrawing.texturedRect(x2, y1 + j * tileSize, this.cornerSize, tileHeight, this.texture, uv2, uv1, 1.0f, uv2 - vo, -1);
                    ScreenDrawing.texturedRect(x1 + i * tileSize, y1 + j * tileSize, tileWidth, tileHeight, this.texture, uv1, uv1, uv2 - uo, uv2 - vo, -1);
                    heightLeft -= tileSize;
                }
                widthLeft -= tileSize;
            }
        } else {
            ScreenDrawing.texturedRect(x1, top, width - 2 * this.cornerSize, this.cornerSize, this.texture, uv1, 0.0f, uv2, uv1, -1);
            ScreenDrawing.texturedRect(left, y1, this.cornerSize, height - 2 * this.cornerSize, this.texture, 0.0f, uv1, uv1, uv2, -1);
            ScreenDrawing.texturedRect(x1, y2, width - 2 * this.cornerSize, this.cornerSize, this.texture, uv1, uv2, uv2, 1.0f, -1);
            ScreenDrawing.texturedRect(x2, y1, this.cornerSize, height - 2 * this.cornerSize, this.texture, uv2, uv1, 1.0f, uv2, -1);
            ScreenDrawing.texturedRect(x1, y1, width - 2 * this.cornerSize, height - 2 * this.cornerSize, this.texture, uv1, uv1, uv2, uv2, -1);
        }
    }

    public static class MetadataLoader
    extends class_4080<Map<class_2960, Properties>>
    implements IdentifiableResourceReloadListener {
        public static final MetadataLoader INSTANCE = new MetadataLoader();
        private static final class_2960 ID = new class_2960("libgui", "9patch_metadata");
        private static final String SUFFIX = ".9patch";
        private Map<class_2960, TextureProperties> properties = Collections.emptyMap();

        public TextureProperties getProperties(class_2960 texture) {
            return this.properties.getOrDefault(texture, TextureProperties.DEFAULT);
        }

        public class_2960 getFabricId() {
            return ID;
        }

        protected Map<class_2960, Properties> prepare(class_3300 manager, class_3695 profiler) {
            Collection ids = manager.method_14488("textures", s -> s.endsWith(SUFFIX));
            HashMap<class_2960, Properties> result = new HashMap<class_2960, Properties>();
            for (class_2960 input : ids) {
                try {
                    class_3298 resource = manager.method_14486(input);
                    Throwable throwable = null;
                    try {
                        InputStream stream = resource.method_14482();
                        Throwable throwable2 = null;
                        try {
                            Properties props = new Properties();
                            props.load(stream);
                            class_2960 textureId = new class_2960(input.method_12836(), input.method_12832().substring(0, input.method_12832().length() - SUFFIX.length()));
                            result.put(textureId, props);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (resource == null) continue;
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LibGuiClient.logger.error("Error while loading metadata file {}, skipping...", (Object)input, (Object)e);
                }
            }
            return result;
        }

        protected void apply(Map<class_2960, Properties> meta, class_3300 manager, class_3695 profiler) {
            this.properties = new HashMap<class_2960, TextureProperties>();
            for (Map.Entry<class_2960, Properties> entry : meta.entrySet()) {
                String modeStr;
                class_2960 id = entry.getKey();
                Properties props = entry.getValue();
                Mode mode = TextureProperties.DEFAULT.getMode();
                if (props.containsKey("mode") && (mode = Mode.fromString(modeStr = props.getProperty("mode"))) == null) {
                    LibGuiClient.logger.error("Invalid mode '{}' in nine-patch metadata file for texture {}", (Object)modeStr, (Object)id);
                    continue;
                }
                TextureProperties texProperties = new TextureProperties(mode);
                this.properties.put(id, texProperties);
            }
        }
    }

    public static class TextureProperties {
        public static final TextureProperties DEFAULT = new TextureProperties(Mode.STRETCHING);
        private final Mode mode;

        public TextureProperties(Mode mode) {
            this.mode = mode;
        }

        public Mode getMode() {
            return this.mode;
        }
    }

    public static enum Mode {
        STRETCHING,
        TILING;


        @Nullable
        static Mode fromString(String str) {
            if (str == null) {
                return null;
            }
            if (str.equalsIgnoreCase("stretching")) {
                return STRETCHING;
            }
            if (str.equalsIgnoreCase("tiling")) {
                return TILING;
            }
            return null;
        }
    }
}

