/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ScreenDrawing {
    private ScreenDrawing() {
    }

    public static void texturedRect(int x, int y, int width, int height, class_2960 texture, int color) {
        ScreenDrawing.texturedRect(x, y, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f, color, 1.0f);
    }

    public static void texturedRect(int x, int y, int width, int height, class_2960 texture, int color, float opacity) {
        ScreenDrawing.texturedRect(x, y, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f, color, opacity);
    }

    public static void texturedRect(int x, int y, int width, int height, class_2960 texture, float u1, float v1, float u2, float v2, int color) {
        ScreenDrawing.texturedRect(x, y, width, height, texture, u1, v1, u2, v2, color, 1.0f);
    }

    public static void texturedRect(int x, int y, int width, int height, class_2960 texture, float u1, float v1, float u2, float v2, int color, float opacity) {
        class_310.method_1551().method_1531().method_22813(texture);
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22527);
        buffer.method_1328(7, class_290.field_20887);
        buffer.method_22912((double)x, (double)(y + height), 0.0).method_22915(r, g, b, opacity).method_22913(u1, v2).method_1344();
        buffer.method_22912((double)(x + width), (double)(y + height), 0.0).method_22915(r, g, b, opacity).method_22913(u2, v2).method_1344();
        buffer.method_22912((double)(x + width), (double)y, 0.0).method_22915(r, g, b, opacity).method_22913(u2, v1).method_1344();
        buffer.method_22912((double)x, (double)y, 0.0).method_22915(r, g, b, opacity).method_22913(u1, v1).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void texturedGuiRect(int x, int y, int width, int height, class_2960 texture, int textureX, int textureY, int color) {
        float px = 0.00390625f;
        ScreenDrawing.texturedRect(x, y, width, height, texture, (float)textureX * px, (float)textureY * px, (float)(textureX + width) * px, (float)(textureY + height) * px, color);
    }

    public static void texturedGuiRect(int left, int top, int width, int height, class_2960 texture, int color) {
        ScreenDrawing.texturedGuiRect(left, top, width, height, texture, 0, 0, color);
    }

    public static void coloredRect(int left, int top, int width, int height, int color) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22527);
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_22912((double)left, (double)(top + height), 0.0).method_22915(r, g, b, a).method_1344();
        buffer.method_22912((double)(left + width), (double)(top + height), 0.0).method_22915(r, g, b, a).method_1344();
        buffer.method_22912((double)(left + width), (double)top, 0.0).method_22915(r, g, b, a).method_1344();
        buffer.method_22912((double)left, (double)top, 0.0).method_22915(r, g, b, a).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void maskedRect(class_2960 mask, class_2960 texture, int left, int top, int width, int height) {
        ScreenDrawing.texturedRect(left, top, width, height, mask, 0.0f, 0.0f, 1.0f, 1.0f, -1);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)514);
        ScreenDrawing.texturedRect(left, top, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f, -1);
        RenderSystem.depthFunc((int)513);
        RenderSystem.disableDepthTest();
    }

    public static void drawGuiPanel(int x, int y, int width, int height) {
        if (LibGuiClient.config.darkMode) {
            ScreenDrawing.drawGuiPanel(x, y, width, height, -16053493, -13684945, -12500671, -16777216);
        } else {
            ScreenDrawing.drawGuiPanel(x, y, width, height, -11184811, -3750202, -1, -16777216);
        }
    }

    public static void drawGuiPanel(int x, int y, int width, int height, int panelColor) {
        int shadowColor = ScreenDrawing.multiplyColor(panelColor, 0.5f);
        int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.25f);
        ScreenDrawing.drawGuiPanel(x, y, width, height, shadowColor, panelColor, hilightColor, -16777216);
    }

    public static void drawGuiPanel(int x, int y, int width, int height, int shadow, int panel, int hilight, int outline) {
        ScreenDrawing.coloredRect(x + 3, y + 3, width - 6, height - 6, panel);
        ScreenDrawing.coloredRect(x + 2, y + 1, width - 4, 2, hilight);
        ScreenDrawing.coloredRect(x + 2, y + height - 3, width - 4, 2, shadow);
        ScreenDrawing.coloredRect(x + 1, y + 2, 2, height - 4, hilight);
        ScreenDrawing.coloredRect(x + width - 3, y + 2, 2, height - 4, shadow);
        ScreenDrawing.coloredRect(x + width - 3, y + 2, 1, 1, panel);
        ScreenDrawing.coloredRect(x + 2, y + height - 3, 1, 1, panel);
        ScreenDrawing.coloredRect(x + 3, y + 3, 1, 1, hilight);
        ScreenDrawing.coloredRect(x + width - 4, y + height - 4, 1, 1, shadow);
        ScreenDrawing.coloredRect(x + 2, y, width - 4, 1, outline);
        ScreenDrawing.coloredRect(x, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(x + width - 1, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(x + 2, y + height - 1, width - 4, 1, outline);
        ScreenDrawing.coloredRect(x + 1, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(x + 1, y + height - 2, 1, 1, outline);
        ScreenDrawing.coloredRect(x + width - 2, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(x + width - 2, y + height - 2, 1, 1, outline);
    }

    public static void drawBeveledPanel(int x, int y) {
        ScreenDrawing.drawBeveledPanel(x, y, 18, 18, -13158601, -7631989, -1);
    }

    public static void drawBeveledPanel(int x, int y, int width, int height) {
        ScreenDrawing.drawBeveledPanel(x, y, width, height, -13158601, -7631989, -1);
    }

    public static void drawBeveledPanel(int x, int y, int width, int height, int topleft, int panel, int bottomright) {
        ScreenDrawing.coloredRect(x, y, width, height, panel);
        ScreenDrawing.coloredRect(x, y, width - 1, 1, topleft);
        ScreenDrawing.coloredRect(x, y + 1, 1, height - 2, topleft);
        ScreenDrawing.coloredRect(x + width - 1, y + 1, 1, height - 1, bottomright);
        ScreenDrawing.coloredRect(x + 1, y + height - 1, width - 1, 1, bottomright);
    }

    public static void drawString(class_4587 matrices, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_1729(matrices, s, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_1729(matrices, s, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width - wid;
                class_310.method_1551().field_1772.method_1729(matrices, s, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawString(class_4587 matrices, class_5348 text, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_27528(matrices, text, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_27525(text);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_27528(matrices, text, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_27525(text);
                int l = width - wid;
                class_310.method_1551().field_1772.method_27528(matrices, text, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawStringWithShadow(class_4587 matrices, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_1720(matrices, s, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_1720(matrices, s, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width - wid;
                class_310.method_1551().field_1772.method_1720(matrices, s, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawStringWithShadow(class_4587 matrices, class_5348 text, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_27517(matrices, text, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_27525(text);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_27517(matrices, text, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_27525(text);
                int l = width - wid;
                class_310.method_1551().field_1772.method_27517(matrices, text, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawString(class_4587 matrices, String s, int x, int y, int color) {
        class_310.method_1551().field_1772.method_1729(matrices, s, (float)x, (float)y, color);
    }

    public static void drawString(class_4587 matrices, class_5348 text, int x, int y, int color) {
        class_310.method_1551().field_1772.method_27528(matrices, text, (float)x, (float)y, color);
    }

    public static int colorAtOpacity(int opaque, float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        int a = (int)(opacity * 255.0f);
        return opaque & 0xFFFFFF | a << 24;
    }

    public static int multiplyColor(int color, float amount) {
        int a = color & 0xFF000000;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        r = Math.min(r * amount, 1.0f);
        g = Math.min(g * amount, 1.0f);
        b = Math.min(b * amount, 1.0f);
        int ir = (int)(r * 255.0f);
        int ig = (int)(g * 255.0f);
        int ib = (int)(b * 255.0f);
        return a | ir << 16 | ig << 8 | ib;
    }
}

