/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class WBar
extends WWidget {
    protected final class_2960 bg;
    protected final class_2960 bar;
    protected final int field;
    protected final int max;
    protected int maxValue;
    protected class_3913 properties;
    protected final Direction direction;
    protected String tooltipLabel;
    protected class_2561 tooltipTextComponent;

    public WBar(class_2960 bg, class_2960 bar, int field, int maxfield) {
        this(bg, bar, field, maxfield, Direction.UP);
    }

    public WBar(class_2960 bg, class_2960 bar, int field, int maxfield, Direction dir) {
        this.bg = bg;
        this.bar = bar;
        this.field = field;
        this.max = maxfield;
        this.maxValue = 0;
        this.direction = dir;
    }

    public WBar withTooltip(String label) {
        this.tooltipLabel = label;
        return this;
    }

    public WBar withTooltip(class_2561 label) {
        this.tooltipTextComponent = label;
        return this;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        int barSize;
        if (this.bg != null) {
            ScreenDrawing.texturedRect(x, y, this.getWidth(), this.getHeight(), this.bg, -1);
        } else {
            ScreenDrawing.coloredRect(x, y, this.getWidth(), this.getHeight(), ScreenDrawing.colorAtOpacity(0, 0.25f));
        }
        float percent = (float)this.properties.method_17390(this.field) / (float)this.properties.method_17390(this.max);
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        int barMax = this.getWidth();
        if (this.direction == Direction.DOWN || this.direction == Direction.UP) {
            barMax = this.getHeight();
        }
        if ((barSize = (int)((float)barMax * (percent = (float)((int)(percent * (float)barMax)) / (float)barMax))) <= 0) {
            return;
        }
        switch (this.direction) {
            case UP: {
                int left = x;
                int top = y + this.getHeight();
                top -= barSize;
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(left, top, this.getWidth(), barSize, this.bar, 0.0f, 1.0f - percent, 1.0f, 1.0f, -1);
                    break;
                }
                ScreenDrawing.coloredRect(left, top, this.getWidth(), barSize, ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case RIGHT: {
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(x, y, barSize, this.getHeight(), this.bar, 0.0f, 0.0f, percent, 1.0f, -1);
                    break;
                }
                ScreenDrawing.coloredRect(x, y, barSize, this.getHeight(), ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case DOWN: {
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(x, y, this.getWidth(), barSize, this.bar, 0.0f, 0.0f, 1.0f, percent, -1);
                    break;
                }
                ScreenDrawing.coloredRect(x, y, this.getWidth(), barSize, ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case LEFT: {
                int left = x + this.getWidth();
                int top = y;
                left -= barSize;
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(left, top, barSize, this.getHeight(), this.bar, 1.0f - percent, 0.0f, 1.0f, 1.0f, -1);
                    break;
                }
                ScreenDrawing.coloredRect(left, top, barSize, this.getHeight(), ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
        }
    }

    @Override
    public void addTooltip(List<class_5348> information) {
        if (this.tooltipLabel != null) {
            class_2585 formatted;
            int value = this.field >= 0 ? this.properties.method_17390(this.field) : 0;
            int valMax = this.max >= 0 ? this.properties.method_17390(this.max) : this.maxValue;
            try {
                formatted = new class_2588(this.tooltipLabel, new Object[]{value, valMax});
            }
            catch (Throwable t) {
                formatted = new class_2585(t.getLocalizedMessage());
            }
            information.add((class_5348)formatted);
        }
        if (this.tooltipTextComponent != null) {
            try {
                information.add((class_5348)this.tooltipTextComponent);
            }
            catch (Throwable t) {
                information.add((class_5348)new class_2585(t.getLocalizedMessage()));
            }
        }
    }

    @Override
    public void validate(GuiDescription host) {
        super.validate(host);
        if (this.properties == null) {
            this.properties = host.getPropertyDelegate();
        }
    }

    @Nullable
    public class_3913 getProperties() {
        return this.properties;
    }

    public WBar setProperties(class_3913 properties) {
        this.properties = properties;
        return this;
    }

    public static WBar withConstantMaximum(class_2960 bg, class_2960 bar, int field, int maxValue, Direction dir) {
        WBar result = new WBar(bg, bar, field, -1, dir);
        result.maxValue = maxValue;
        return result;
    }

    public static enum Direction {
        UP,
        RIGHT,
        DOWN,
        LEFT;

    }
}

