/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.Objects;

public class WBox
extends WPanel {
    protected int spacing = 4;
    protected Axis axis;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;

    public WBox(Axis axis) {
        this.axis = Objects.requireNonNull(axis, "axis");
    }

    public void add(WWidget widget, int width, int height) {
        widget.setParent(this);
        this.children.add(widget);
        if (this.canResize()) {
            widget.setSize(width, height);
        }
    }

    public void add(WWidget widget) {
        this.add(widget, 18, 18);
    }

    @Override
    public void layout() {
        int dimension = 0;
        if (this.axis == Axis.HORIZONTAL && this.horizontalAlignment != HorizontalAlignment.LEFT) {
            int widgetWidth = this.spacing * (this.children.size() - 1);
            for (WWidget child : this.children) {
                widgetWidth += child.getWidth();
            }
            dimension = this.horizontalAlignment == HorizontalAlignment.CENTER ? (this.getWidth() - widgetWidth) / 2 : this.getWidth() - widgetWidth;
        } else if (this.verticalAlignment != VerticalAlignment.TOP) {
            int widgetHeight = this.spacing * (this.children.size() - 1);
            for (WWidget child : this.children) {
                widgetHeight += child.getHeight();
            }
            dimension = this.verticalAlignment == VerticalAlignment.CENTER ? (this.getHeight() - widgetHeight) / 2 : this.getHeight() - widgetHeight;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            WWidget child = (WWidget)this.children.get(i);
            if (this.axis == Axis.HORIZONTAL) {
                int y;
                switch (this.verticalAlignment) {
                    default: {
                        y = 0;
                        break;
                    }
                    case CENTER: {
                        y = (this.getHeight() - child.getHeight()) / 2;
                        break;
                    }
                    case BOTTOM: {
                        y = this.getHeight() - child.getHeight();
                    }
                }
                child.setLocation(dimension, y);
            } else {
                int x;
                switch (this.horizontalAlignment) {
                    default: {
                        x = 0;
                        break;
                    }
                    case CENTER: {
                        x = (this.getWidth() - child.getWidth()) / 2;
                        break;
                    }
                    case RIGHT: {
                        x = this.getWidth() - child.getWidth();
                    }
                }
                child.setLocation(x, dimension);
            }
            if (child instanceof WPanel) {
                ((WPanel)child).layout();
            }
            this.expandToFit(child);
            if (i != this.children.size() - 1) {
                dimension += this.spacing;
            }
            dimension += this.axis == Axis.HORIZONTAL ? child.getWidth() : child.getHeight();
        }
    }

    public int getSpacing() {
        return this.spacing;
    }

    public WBox setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public WBox setAxis(Axis axis) {
        this.axis = Objects.requireNonNull(axis, "axis");
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WBox setHorizontalAlignment(HorizontalAlignment alignment) {
        this.horizontalAlignment = Objects.requireNonNull(alignment, "alignment");
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WBox setVerticalAlignment(VerticalAlignment alignment) {
        this.verticalAlignment = Objects.requireNonNull(alignment, "alignment");
        return this;
    }
}

