/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import java.util.function.Supplier;
import net.minecraft.class_4587;

public class WDynamicLabel
extends WWidget {
    protected Supplier<String> text;
    protected HorizontalAlignment alignment = HorizontalAlignment.LEFT;
    protected int color;
    protected int darkmodeColor;
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int DEFAULT_DARKMODE_TEXT_COLOR = 0xBCBCBC;

    public WDynamicLabel(Supplier<String> text, int color) {
        this.text = text;
        this.color = color;
        this.darkmodeColor = color == 0x404040 ? 0xBCBCBC : color;
    }

    public WDynamicLabel(Supplier<String> text) {
        this(text, 0x404040);
    }

    @Override
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        String tr = this.text.get();
        ScreenDrawing.drawString(matrices, tr, this.alignment, x, y, this.getWidth(), LibGuiClient.config.darkMode ? this.darkmodeColor : this.color);
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    public WDynamicLabel setDarkmodeColor(int color) {
        this.darkmodeColor = color;
        return this;
    }

    public WDynamicLabel disableDarkmode() {
        this.darkmodeColor = this.color;
        return this;
    }

    public WDynamicLabel setColor(int color, int darkmodeColor) {
        this.color = color;
        this.darkmodeColor = darkmodeColor;
        return this;
    }

    public WDynamicLabel setText(Supplier<String> text) {
        this.text = text;
        return this;
    }

    public WDynamicLabel setAlignment(HorizontalAlignment align) {
        this.alignment = align;
        return this;
    }
}

