/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_3494;
import net.minecraft.class_4587;
import net.minecraft.class_918;

public class WItem
extends WWidget {
    private List<class_1799> items;
    private int duration = 25;
    private int ticks = 0;
    private int current = 0;

    public WItem(List<class_1799> items) {
        this.setItems(items);
    }

    public WItem(class_3494<? extends class_1935> tag) {
        this(WItem.getRenderStacks(tag));
    }

    public WItem(class_1799 stack) {
        this(Collections.singletonList(stack));
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick() {
        if (this.ticks++ >= this.duration) {
            this.ticks = 0;
            this.current = (this.current + 1) % this.items.size();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        RenderSystem.enableDepthTest();
        class_310 mc = class_310.method_1551();
        class_918 renderer = mc.method_1480();
        renderer.field_4730 = 100.0f;
        renderer.method_27953(this.items.get(this.current), x + this.getWidth() / 2 - 9, y + this.getHeight() / 2 - 9);
        renderer.field_4730 = 0.0f;
    }

    public int getDuration() {
        return this.duration;
    }

    public WItem setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public List<class_1799> getItems() {
        return this.items;
    }

    public WItem setItems(List<class_1799> items) {
        Objects.requireNonNull(items, "stacks == null!");
        if (items.isEmpty()) {
            throw new IllegalArgumentException("The stack list is empty!");
        }
        this.items = items;
        this.current = 0;
        this.ticks = 0;
        return this;
    }

    private static List<class_1799> getRenderStacks(class_3494<? extends class_1935> tag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_1935 item : tag.method_15138()) {
            builder.add((Object)new class_1799(item));
        }
        return builder.build();
    }
}

