/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.ValidatedSlot;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class WItemSlot
extends WWidget {
    private static final Predicate<class_1799> DEFAULT_FILTER = stack -> true;
    private final List<ValidatedSlot> peers = new ArrayList<ValidatedSlot>();
    @Nullable
    @Environment(value=EnvType.CLIENT)
    private BackgroundPainter backgroundPainter = null;
    private class_1263 inventory;
    private int startIndex = 0;
    private int slotsWide = 1;
    private int slotsHigh = 1;
    private boolean big = false;
    private boolean insertingAllowed = true;
    private boolean takingAllowed = true;
    private int focusedSlot = -1;
    private Predicate<class_1799> filter = DEFAULT_FILTER;

    public WItemSlot(class_1263 inventory, int startIndex, int slotsWide, int slotsHigh, boolean big) {
        this.inventory = inventory;
        this.startIndex = startIndex;
        this.slotsWide = slotsWide;
        this.slotsHigh = slotsHigh;
        this.big = big;
    }

    private WItemSlot() {
    }

    public static WItemSlot of(class_1263 inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        return w;
    }

    public static WItemSlot of(class_1263 inventory, int startIndex, int slotsWide, int slotsHigh) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = startIndex;
        w.slotsWide = slotsWide;
        w.slotsHigh = slotsHigh;
        return w;
    }

    public static WItemSlot outputOf(class_1263 inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        w.big = true;
        return w;
    }

    public static WItemSlot ofPlayerStorage(class_1263 inventory) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = 9;
        w.slotsWide = 9;
        w.slotsHigh = 3;
        return w;
    }

    @Override
    public int getWidth() {
        return this.slotsWide * 18;
    }

    @Override
    public int getHeight() {
        return this.slotsHigh * 18;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    public boolean isBigSlot() {
        return this.big;
    }

    public boolean isModifiable() {
        return this.takingAllowed || this.insertingAllowed;
    }

    public WItemSlot setModifiable(boolean modifiable) {
        this.insertingAllowed = modifiable;
        this.takingAllowed = modifiable;
        for (ValidatedSlot peer : this.peers) {
            peer.setInsertingAllowed(modifiable);
            peer.setTakingAllowed(modifiable);
        }
        return this;
    }

    public boolean isInsertingAllowed() {
        return this.insertingAllowed;
    }

    public WItemSlot setInsertingAllowed(boolean insertingAllowed) {
        this.insertingAllowed = insertingAllowed;
        for (ValidatedSlot peer : this.peers) {
            peer.setInsertingAllowed(insertingAllowed);
        }
        return this;
    }

    public boolean isTakingAllowed() {
        return this.takingAllowed;
    }

    public WItemSlot setTakingAllowed(boolean takingAllowed) {
        this.takingAllowed = takingAllowed;
        for (ValidatedSlot peer : this.peers) {
            peer.setTakingAllowed(takingAllowed);
        }
        return this;
    }

    public int getFocusedSlot() {
        return this.focusedSlot;
    }

    @Override
    public void validate(GuiDescription host) {
        super.validate(host);
        this.peers.clear();
        int index = this.startIndex;
        for (int y = 0; y < this.slotsHigh; ++y) {
            for (int x = 0; x < this.slotsWide; ++x) {
                ValidatedSlot slot = this.createSlotPeer(this.inventory, index, this.getAbsoluteX() + x * 18 + 1, this.getAbsoluteY() + y * 18 + 1);
                slot.setInsertingAllowed(this.insertingAllowed);
                slot.setTakingAllowed(this.takingAllowed);
                slot.setFilter(this.filter);
                this.peers.add(slot);
                host.addSlotPeer(slot);
                ++index;
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onKeyPressed(int ch, int key, int modifiers) {
        if (WItemSlot.isActivationKey(ch) && this.host instanceof class_1703 && this.focusedSlot >= 0) {
            class_1703 handler = (class_1703)this.host;
            class_310 client = class_310.method_1551();
            ValidatedSlot peer = this.peers.get(this.focusedSlot);
            client.field_1761.method_2906(handler.field_7763, peer.field_7874, 0, class_1713.field_7790, (class_1657)client.field_1724);
        }
    }

    protected ValidatedSlot createSlotPeer(class_1263 inventory, int index, int x, int y) {
        return new ValidatedSlot(inventory, index, x, y);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    @Environment(value=EnvType.CLIENT)
    public void setBackgroundPainter(@Nullable BackgroundPainter painter) {
        this.backgroundPainter = painter;
    }

    public Predicate<class_1799> getFilter() {
        return this.filter;
    }

    public WItemSlot setFilter(Predicate<class_1799> filter) {
        this.filter = filter;
        for (ValidatedSlot peer : this.peers) {
            peer.setFilter(filter);
        }
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        (this.backgroundPainter != null ? this.backgroundPainter : BackgroundPainter.SLOT).paintBackground(x, y, this);
    }

    @Override
    @Nullable
    public WWidget cycleFocus(boolean lookForwards) {
        if (this.focusedSlot < 0) {
            this.focusedSlot = lookForwards ? 0 : this.slotsWide * this.slotsHigh - 1;
            return this;
        }
        if (lookForwards) {
            ++this.focusedSlot;
            if (this.focusedSlot >= this.slotsWide * this.slotsHigh) {
                this.focusedSlot = -1;
                return null;
            }
            return this;
        }
        --this.focusedSlot;
        return this.focusedSlot >= 0 ? this : null;
    }
}

