/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.client.TextHoverRendererScreen;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class WLabel
extends WWidget {
    protected class_5348 text;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    protected int color;
    protected int darkmodeColor;
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int DEFAULT_DARKMODE_TEXT_COLOR = 0xBCBCBC;

    public WLabel(String text, int color) {
        this((class_5348)new class_2585(text), color);
    }

    public WLabel(class_5348 text, int color) {
        this.text = text;
        this.color = color;
        this.darkmodeColor = color == 0x404040 ? 0xBCBCBC : color;
    }

    public WLabel(String text) {
        this(text, 0x404040);
    }

    public WLabel(class_5348 text) {
        this(text, 0x404040);
    }

    @Override
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        class_437 screen;
        int yOffset;
        class_310 mc = class_310.method_1551();
        class_327 renderer = mc.field_1772;
        switch (this.verticalAlignment) {
            case CENTER: {
                int n = this.height / 2;
                renderer.getClass();
                yOffset = n - 9 / 2;
                break;
            }
            case BOTTOM: {
                renderer.getClass();
                yOffset = this.height - 9;
                break;
            }
            default: {
                yOffset = 0;
            }
        }
        ScreenDrawing.drawString(matrices, this.text, this.horizontalAlignment, x, y + yOffset, this.getWidth(), LibGuiClient.config.darkMode ? this.darkmodeColor : this.color);
        class_2583 hoveredTextStyle = this.getTextStyleAt(mouseX, mouseY);
        if (hoveredTextStyle != null && (screen = class_310.method_1551().field_1755) instanceof TextHoverRendererScreen) {
            ((TextHoverRendererScreen)screen).renderTextHover(matrices, hoveredTextStyle, x + mouseX, y + mouseY);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClick(int x, int y, int button) {
        class_437 screen;
        class_2583 hoveredTextStyle = this.getTextStyleAt(x, y);
        if (hoveredTextStyle != null && (screen = class_310.method_1551().field_1755) != null) {
            screen.method_25430(hoveredTextStyle);
        }
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_2583 getTextStyleAt(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return class_310.method_1551().field_1772.method_27527().method_27489(this.text, x);
        }
        return null;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, Math.max(8, y));
    }

    public int getDarkmodeColor() {
        return this.darkmodeColor;
    }

    public WLabel setDarkmodeColor(int color) {
        this.darkmodeColor = color;
        return this;
    }

    public WLabel disableDarkmode() {
        this.darkmodeColor = this.color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public WLabel setColor(int color) {
        this.color = color;
        return this;
    }

    public WLabel setColor(int color, int darkmodeColor) {
        this.color = color;
        this.darkmodeColor = darkmodeColor;
        return this;
    }

    public class_5348 getText() {
        return this.text;
    }

    public WLabel setText(class_5348 text) {
        this.text = text;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WLabel setHorizontalAlignment(HorizontalAlignment align) {
        this.horizontalAlignment = align;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WLabel setVerticalAlignment(VerticalAlignment align) {
        this.verticalAlignment = align;
        return this;
    }
}

