/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.WSlider;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class WLabeledSlider
extends WAbstractSlider {
    private static final class_1158 ROTATION_Z_270 = class_1160.field_20703.method_23214(270.0f);
    @Nullable
    private class_5348 label = null;
    @Nullable
    private LabelUpdater labelUpdater = null;
    private HorizontalAlignment labelAlignment = HorizontalAlignment.CENTER;

    public WLabeledSlider(int min, int max) {
        this(min, max, Axis.HORIZONTAL);
    }

    public WLabeledSlider(int min, int max, Axis axis) {
        super(min, max, axis);
    }

    public WLabeledSlider(int min, int max, Axis axis, @Nullable class_5348 label) {
        this(min, max, axis);
        this.label = label;
    }

    public WLabeledSlider(int min, int max, @Nullable class_5348 label) {
        this(min, max);
        this.label = label;
    }

    @Override
    public void setSize(int x, int y) {
        if (this.axis == Axis.HORIZONTAL) {
            super.setSize(x, 20);
        } else {
            super.setSize(20, y);
        }
    }

    @Nullable
    public class_5348 getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable class_5348 label) {
        this.label = label;
    }

    @Override
    protected void onValueChanged(int value) {
        super.onValueChanged(value);
        if (this.labelUpdater != null) {
            this.label = this.labelUpdater.updateLabel(value);
        }
    }

    public HorizontalAlignment getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(HorizontalAlignment labelAlignment) {
        this.labelAlignment = labelAlignment;
    }

    @Nullable
    public LabelUpdater getLabelUpdater() {
        return this.labelUpdater;
    }

    public void setLabelUpdater(@Nullable LabelUpdater labelUpdater) {
        this.labelUpdater = labelUpdater;
    }

    @Override
    protected int getThumbWidth() {
        return 8;
    }

    @Override
    protected boolean isMouseInsideBounds(int x, int y) {
        return x >= 0 && x <= this.width && y >= 0 && y <= this.height;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        int aHeight;
        int aWidth = this.axis == Axis.HORIZONTAL ? this.width : this.height;
        int n = aHeight = this.axis == Axis.HORIZONTAL ? this.height : this.width;
        int rotMouseX = this.axis == Axis.HORIZONTAL ? (this.direction == WAbstractSlider.Direction.LEFT ? this.width - mouseX : mouseX) : (this.direction == WAbstractSlider.Direction.UP ? this.height - mouseY : mouseY);
        int rotMouseY = this.axis == Axis.HORIZONTAL ? mouseY : mouseX;
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 0.0);
        if (this.axis == Axis.VERTICAL) {
            matrices.method_22904(0.0, (double)this.height, 0.0);
            matrices.method_22907(ROTATION_Z_270);
        }
        this.drawButton(0, 0, 0, aWidth);
        int thumbX = Math.round(this.coordToValueRatio * (float)(this.value - this.min));
        int thumbY = 0;
        int thumbWidth = this.getThumbWidth();
        int thumbHeight = aHeight;
        boolean hovering = rotMouseX >= thumbX && rotMouseX <= thumbX + thumbWidth && rotMouseY >= thumbY && rotMouseY <= thumbY + thumbHeight;
        int thumbState = this.dragging || hovering ? 2 : 1;
        this.drawButton(thumbX, thumbY, thumbState, thumbWidth);
        if (thumbState == 1 && this.isFocused()) {
            float px = 0.03125f;
            ScreenDrawing.texturedRect(thumbX, thumbY, thumbWidth, thumbHeight, WSlider.LIGHT_TEXTURE, 24.0f * px, 0.0f * px, 32.0f * px, 20.0f * px, -1);
        }
        if (this.label != null) {
            int color = this.isMouseInsideBounds(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
            ScreenDrawing.drawStringWithShadow(matrices, this.label, this.labelAlignment, 2, aHeight / 2 - 4, aWidth - 4, color);
        }
        matrices.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    private void drawButton(int x, int y, int state, int width) {
        float px = 0.00390625f;
        float buttonLeft = 0.0f * px;
        float buttonTop = (float)(46 + state * 20) * px;
        int halfWidth = width / 2;
        if (halfWidth > 198) {
            halfWidth = 198;
        }
        float buttonWidth = (float)halfWidth * px;
        float buttonHeight = 20.0f * px;
        float buttonEndLeft = (float)(200 - halfWidth) * px;
        ScreenDrawing.texturedRect(x, y, halfWidth, 20, class_339.field_22757, buttonLeft, buttonTop, buttonLeft + buttonWidth, buttonTop + buttonHeight, -1);
        ScreenDrawing.texturedRect(x + halfWidth, y, halfWidth, 20, class_339.field_22757, buttonEndLeft, buttonTop, 200.0f * px, buttonTop + buttonHeight, -1);
    }

    @FunctionalInterface
    public static interface LabelUpdater {
        public class_5348 updateLabel(int var1);
    }
}

