/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;

public abstract class WPanel
extends WWidget {
    protected final List<WWidget> children = new ArrayList<WWidget>();
    @Environment(value=EnvType.CLIENT)
    private BackgroundPainter backgroundPainter = null;

    @Override
    public void createPeers(GuiDescription c) {
        super.createPeers(c);
        for (WWidget child : this.children) {
            child.createPeers(c);
        }
    }

    public void remove(WWidget w) {
        this.children.remove(w);
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public WPanel setBackgroundPainter(BackgroundPainter painter) {
        this.backgroundPainter = painter;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void layout() {
        for (WWidget child : this.children) {
            if (child instanceof WPanel) {
                ((WPanel)child).layout();
            }
            this.expandToFit(child);
        }
    }

    protected void expandToFit(WWidget w) {
        int pushRight = w.getX() + w.getWidth();
        int pushDown = w.getY() + w.getHeight();
        this.setSize(Math.max(this.getWidth(), pushRight), Math.max(this.getHeight(), pushDown));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WWidget onMouseUp(int x, int y, int button) {
        if (this.children.isEmpty()) {
            return super.onMouseUp(x, y, button);
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            return child.onMouseUp(x - child.getX(), y - child.getY(), button);
        }
        return super.onMouseUp(x, y, button);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WWidget onMouseDown(int x, int y, int button) {
        if (this.children.isEmpty()) {
            return super.onMouseDown(x, y, button);
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            return child.onMouseDown(x - child.getX(), y - child.getY(), button);
        }
        return super.onMouseDown(x, y, button);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onMouseDrag(int x, int y, int button) {
        if (this.children.isEmpty()) {
            return;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            child.onMouseDrag(x - child.getX(), y - child.getY(), button);
            return;
        }
        super.onMouseDrag(x, y, button);
    }

    @Override
    public WWidget hit(int x, int y) {
        if (this.children.isEmpty()) {
            return this;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            return child.hit(x - child.getX(), y - child.getY());
        }
        return this;
    }

    @Override
    public void validate(GuiDescription c) {
        super.validate(c);
        this.layout();
        for (WWidget child : this.children) {
            child.validate(c);
        }
        if (c != null) {
            this.createPeers(c);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paintBackground(x, y, this);
        }
        for (WWidget child : this.children) {
            child.paint(matrices, x + child.getX(), y + child.getY(), mouseX - child.getX(), mouseY - child.getY());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick() {
        for (WWidget child : this.children) {
            child.tick();
        }
    }

    @Override
    @Nullable
    public WWidget cycleFocus(boolean lookForwards) {
        return this.cycleFocus(lookForwards, null);
    }

    @Nullable
    public WWidget cycleFocus(boolean lookForwards, @Nullable WWidget pivot) {
        block8: {
            int currentIndex;
            block9: {
                block6: {
                    block7: {
                        if (pivot != null) break block6;
                        if (!lookForwards) break block7;
                        for (WWidget child : this.children) {
                            WWidget result = this.checkFocusCycling(lookForwards, child);
                            if (result == null) continue;
                            return result;
                        }
                        break block8;
                    }
                    if (this.children.isEmpty()) break block8;
                    for (int i = this.children.size() - 1; i >= 0; --i) {
                        WWidget child = this.children.get(i);
                        WWidget result = this.checkFocusCycling(lookForwards, child);
                        if (result == null) continue;
                        return result;
                    }
                    break block8;
                }
                currentIndex = this.children.indexOf(pivot);
                if (currentIndex == -1) {
                    int n = currentIndex = lookForwards ? 0 : this.children.size() - 1;
                }
                if (!lookForwards) break block9;
                if (currentIndex >= this.children.size() - 1) break block8;
                for (int i = currentIndex + 1; i < this.children.size(); ++i) {
                    WWidget child = this.children.get(i);
                    WWidget result = this.checkFocusCycling(lookForwards, child);
                    if (result == null) continue;
                    return result;
                }
                break block8;
            }
            if (currentIndex > 0) {
                for (int i = currentIndex - 1; i >= 0; --i) {
                    WWidget child = this.children.get(i);
                    WWidget result = this.checkFocusCycling(lookForwards, child);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    @Nullable
    private WWidget checkFocusCycling(boolean lookForwards, WWidget child) {
        if (child.canFocus() || child instanceof WPanel) {
            return child.cycleFocus(lookForwards);
        }
        return null;
    }

    public String toString() {
        return "WPanel{ children: [\n" + this.children.stream().map(Objects::toString).flatMap(x -> Stream.of(x.split("\n")).map(y -> "\t" + y)).collect(Collectors.joining(",\n")) + "]\u00a0}";
    }
}

