/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_5348;

public class WPlayerInvPanel
extends WPlainPanel {
    private final WItemSlot inv;
    private final WItemSlot hotbar;
    @Nullable
    private final WWidget label;

    public WPlayerInvPanel(class_1661 playerInventory) {
        this(playerInventory, true);
    }

    public WPlayerInvPanel(class_1661 playerInventory, boolean hasLabel) {
        this(playerInventory, hasLabel ? WPlayerInvPanel.createDefaultLabel(playerInventory) : null);
    }

    public WPlayerInvPanel(class_1661 playerInventory, @Nullable WWidget label) {
        int y = 0;
        this.label = label;
        if (label != null) {
            this.add(label, 0, 0, label.getWidth(), label.getHeight());
            y += label.getHeight();
        }
        this.inv = WItemSlot.ofPlayerStorage((class_1263)playerInventory);
        this.hotbar = WItemSlot.of((class_1263)playerInventory, 0, 9, 1);
        this.add(this.inv, 0, y);
        this.add(this.hotbar, 0, y + 58);
    }

    private static WLabel createDefaultLabel(class_1661 playerInventory) {
        WLabel label = new WLabel((class_5348)playerInventory.method_5476());
        label.setSize(162, 11);
        return label;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WPanel setBackgroundPainter(BackgroundPainter painter) {
        super.setBackgroundPainter(null);
        this.inv.setBackgroundPainter(painter);
        this.hotbar.setBackgroundPainter(painter);
        return this;
    }

    @Override
    public void validate(GuiDescription c) {
        super.validate(c);
        if (c != null && this.label instanceof WLabel) {
            ((WLabel)this.label).setColor(c.getTitleColor());
        }
    }
}

