/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;

public class WScrollBar
extends WWidget {
    protected Axis axis = Axis.HORIZONTAL;
    protected int value;
    protected int maxValue = 100;
    protected int window = 16;
    protected int anchor = -1;
    protected int anchorValue = -1;
    protected boolean sliding = false;

    public WScrollBar() {
    }

    public WScrollBar(Axis axis) {
        this.axis = axis;
    }

    @Override
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        int bottom;
        int middle;
        int top;
        if (LibGuiClient.config.darkMode) {
            ScreenDrawing.drawBeveledPanel(x, y, this.width, this.height, -14606047, -13684945, -10658467);
        } else {
            ScreenDrawing.drawBeveledPanel(x, y, this.width, this.height, -13158601, -7631989, -1);
        }
        if (this.maxValue <= 0) {
            return;
        }
        if (this.sliding) {
            if (LibGuiClient.config.darkMode) {
                top = -9671572;
                middle = -13684945;
                bottom = -14606047;
            } else {
                top = -1;
                middle = -7631989;
                bottom = -11184811;
            }
        } else if (this.isWithinBounds(mouseX, mouseY)) {
            if (LibGuiClient.config.darkMode) {
                top = -10524003;
                middle = -13484178;
                bottom = -16048054;
            } else {
                top = -3157769;
                middle = -7892537;
                bottom = -13353355;
            }
        } else if (LibGuiClient.config.darkMode) {
            top = -9671572;
            middle = -12500671;
            bottom = -14606047;
        } else {
            top = -1;
            middle = -3750202;
            bottom = -11184811;
        }
        if (this.axis == Axis.HORIZONTAL) {
            ScreenDrawing.drawBeveledPanel(x + 1 + this.getHandlePosition(), y + 1, this.getHandleSize(), this.height - 2, top, middle, bottom);
            if (this.isFocused()) {
                WScrollBar.drawBeveledOutline(x + 1 + this.getHandlePosition(), y + 1, this.getHandleSize(), this.height - 2, -89, -7565511);
            }
        } else {
            ScreenDrawing.drawBeveledPanel(x + 1, y + 1 + this.getHandlePosition(), this.width - 2, this.getHandleSize(), top, middle, bottom);
            if (this.isFocused()) {
                WScrollBar.drawBeveledOutline(x + 1, y + 1 + this.getHandlePosition(), this.width - 2, this.getHandleSize(), -89, -7565511);
            }
        }
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    private static void drawBeveledOutline(int x, int y, int width, int height, int topleft, int bottomright) {
        ScreenDrawing.coloredRect(x, y, width, 1, topleft);
        ScreenDrawing.coloredRect(x, y + 1, 1, height - 1, topleft);
        ScreenDrawing.coloredRect(x + width - 1, y + 1, 1, height - 1, bottomright);
        ScreenDrawing.coloredRect(x + 1, y + height - 1, width - 1, 1, bottomright);
    }

    public int getHandleSize() {
        int bar;
        float percentage = this.window >= this.maxValue ? 1.0f : (float)this.window / (float)this.maxValue;
        int result = (int)(percentage * (float)(bar = this.axis == Axis.HORIZONTAL ? this.width - 2 : this.height - 2));
        if (result < 6) {
            result = 6;
        }
        return result;
    }

    public int getMovableDistance() {
        int bar = this.axis == Axis.HORIZONTAL ? this.width - 2 : this.height - 2;
        return bar - this.getHandleSize();
    }

    public int pixelsToValues(int pixels) {
        int bar = this.axis == Axis.HORIZONTAL ? this.width - 2 : this.height - 2;
        float percent = (float)pixels / (float)bar;
        return (int)(percent * (float)(this.maxValue - this.window));
    }

    public int getHandlePosition() {
        float percent = (float)this.value / (float)Math.max(this.maxValue - this.window, 1);
        return (int)(percent * (float)this.getMovableDistance());
    }

    public int getMaxScrollValue() {
        return this.maxValue - this.window;
    }

    protected void adjustSlider(int x, int y) {
        int delta = 0;
        delta = this.axis == Axis.HORIZONTAL ? x - this.anchor : y - this.anchor;
        int valueDelta = this.pixelsToValues(delta);
        int valueNew = this.anchorValue + valueDelta;
        if (valueNew > this.getMaxScrollValue()) {
            valueNew = this.getMaxScrollValue();
        }
        if (valueNew < 0) {
            valueNew = 0;
        }
        this.value = valueNew;
    }

    @Override
    public WWidget onMouseDown(int x, int y, int button) {
        this.requestFocus();
        if (this.axis == Axis.HORIZONTAL) {
            this.anchor = x;
            this.anchorValue = this.value;
        } else {
            this.anchor = y;
            this.anchorValue = this.value;
        }
        this.sliding = true;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onMouseDrag(int x, int y, int button) {
        this.adjustSlider(x, y);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WWidget onMouseUp(int x, int y, int button) {
        this.anchor = -1;
        this.anchorValue = -1;
        this.sliding = false;
        return this;
    }

    @Override
    public void onKeyPressed(int ch, int key, int modifiers) {
        WAbstractSlider.Direction direction;
        WAbstractSlider.Direction direction2 = direction = this.axis == Axis.HORIZONTAL ? WAbstractSlider.Direction.RIGHT : WAbstractSlider.Direction.DOWN;
        if (WAbstractSlider.isIncreasingKey(ch, direction)) {
            if (this.value < this.getMaxScrollValue()) {
                ++this.value;
            }
        } else if (WAbstractSlider.isDecreasingKey(ch, direction) && this.value > 0) {
            --this.value;
        }
    }

    public int getValue() {
        return this.value;
    }

    public WScrollBar setValue(int value) {
        this.value = value;
        this.checkValue();
        return this;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public WScrollBar setMaxValue(int max) {
        this.maxValue = max;
        this.checkValue();
        return this;
    }

    public int getWindow() {
        return this.window;
    }

    public WScrollBar setWindow(int window) {
        this.window = window;
        return this;
    }

    protected void checkValue() {
        if (this.value > this.maxValue - this.window) {
            this.value = this.maxValue - this.window;
        }
        if (this.value < 0) {
            this.value = 0;
        }
    }
}

