/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.widget.WClippedPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WScrollBar;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_4587;

public class WScrollPanel
extends WClippedPanel {
    private static final int SCROLL_BAR_SIZE = 8;
    private final WWidget widget;
    private TriState scrollingHorizontally = TriState.DEFAULT;
    private TriState scrollingVertically = TriState.DEFAULT;
    protected WScrollBar horizontalScrollBar = new WScrollBar(Axis.HORIZONTAL);
    protected WScrollBar verticalScrollBar = new WScrollBar(Axis.VERTICAL);
    private int lastHorizontalScroll = -1;
    private int lastVerticalScroll = -1;

    public WScrollPanel(WWidget widget) {
        this.widget = widget;
        widget.setParent(this);
        this.horizontalScrollBar.setParent(this);
        this.verticalScrollBar.setParent(this);
        this.children.add(widget);
        this.children.add(this.verticalScrollBar);
    }

    public TriState isScrollingHorizontally() {
        return this.scrollingHorizontally;
    }

    public WScrollPanel setScrollingHorizontally(TriState scrollingHorizontally) {
        if (scrollingHorizontally != this.scrollingHorizontally) {
            this.scrollingHorizontally = scrollingHorizontally;
            this.layout();
        }
        return this;
    }

    public TriState isScrollingVertically() {
        return this.scrollingVertically;
    }

    public WScrollPanel setScrollingVertically(TriState scrollingVertically) {
        if (scrollingVertically != this.scrollingVertically) {
            this.scrollingVertically = scrollingVertically;
            this.layout();
        }
        return this;
    }

    @Override
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        if (this.verticalScrollBar.getValue() != this.lastVerticalScroll || this.horizontalScrollBar.getValue() != this.lastHorizontalScroll) {
            this.layout();
            this.lastHorizontalScroll = this.horizontalScrollBar.getValue();
            this.lastVerticalScroll = this.verticalScrollBar.getValue();
        }
        super.paint(matrices, x, y, mouseX, mouseY);
    }

    @Override
    public void layout() {
        boolean horizontal;
        this.children.clear();
        boolean bl = this.scrollingHorizontally == TriState.DEFAULT ? this.widget.width > this.width - 8 : (horizontal = this.scrollingHorizontally.get());
        boolean vertical = this.scrollingVertically == TriState.DEFAULT ? this.widget.height > this.height - 8 : this.scrollingVertically.get();
        int offset = horizontal && vertical ? 8 : 0;
        this.verticalScrollBar.setSize(8, this.height - offset);
        this.verticalScrollBar.setLocation(this.width - this.verticalScrollBar.getWidth(), 0);
        this.horizontalScrollBar.setSize(this.width - offset, 8);
        this.horizontalScrollBar.setLocation(0, this.height - this.horizontalScrollBar.getHeight());
        if (this.widget instanceof WPanel) {
            ((WPanel)this.widget).layout();
        }
        this.children.add(this.widget);
        int x = horizontal ? -this.horizontalScrollBar.getValue() : 0;
        int y = vertical ? -this.verticalScrollBar.getValue() : 0;
        this.widget.setLocation(x, y);
        this.verticalScrollBar.setWindow(this.height - (horizontal ? 8 : 0));
        this.verticalScrollBar.setMaxValue(this.widget.getHeight());
        this.horizontalScrollBar.setWindow(this.width - (vertical ? 8 : 0));
        this.horizontalScrollBar.setMaxValue(this.widget.getWidth());
        if (vertical) {
            this.children.add(this.verticalScrollBar);
        }
        if (horizontal) {
            this.children.add(this.horizontalScrollBar);
        }
    }
}

