/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class WSprite
extends WWidget {
    protected int currentFrame = 0;
    protected long currentFrameTime = 0L;
    protected class_2960[] frames;
    protected int frameTime;
    protected long lastFrame;
    protected boolean singleImage = false;
    protected int tint = -1;
    protected float u1 = 0.0f;
    protected float v1 = 0.0f;
    protected float u2 = 1.0f;
    protected float v2 = 1.0f;

    public WSprite(class_2960 image) {
        this.frames = new class_2960[]{image};
        this.singleImage = true;
    }

    public WSprite(class_2960 image, float u1, float v1, float u2, float v2) {
        this(image);
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }

    public WSprite(int frameTime, class_2960 ... frames) {
        this.frameTime = frameTime;
        this.frames = frames;
        if (frames.length == 1) {
            this.singleImage = true;
        }
    }

    public WSprite setImage(class_2960 image) {
        this.frames = new class_2960[]{image};
        this.singleImage = true;
        this.currentFrame = 0;
        this.currentFrameTime = 0L;
        return this;
    }

    public WSprite setFrames(class_2960 ... frames) {
        this.frames = frames;
        if (frames.length == 1) {
            this.singleImage = true;
        }
        if (this.currentFrame >= frames.length) {
            this.currentFrame = 0;
            this.currentFrameTime = 0L;
        }
        return this;
    }

    public WSprite setTint(int tint) {
        this.tint = tint;
        return this;
    }

    public WSprite setOpaqueTint(int tint) {
        this.tint = tint | 0xFF000000;
        return this;
    }

    public WSprite setUv(float u1, float v1, float u2, float v2) {
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        return this;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        if (this.singleImage) {
            this.paintFrame(x, y, this.frames[0]);
        } else {
            boolean inBounds;
            long now = System.nanoTime() / 1000000L;
            boolean bl = inBounds = this.currentFrame >= 0 && this.currentFrame < this.frames.length;
            if (!inBounds) {
                this.currentFrame = 0;
            }
            class_2960 currentFrameTex = this.frames[this.currentFrame];
            this.paintFrame(x, y, currentFrameTex);
            long elapsed = now - this.lastFrame;
            this.currentFrameTime += elapsed;
            if (this.currentFrameTime >= (long)this.frameTime) {
                ++this.currentFrame;
                if (this.currentFrame >= this.frames.length - 1) {
                    this.currentFrame = 0;
                }
                this.currentFrameTime = 0L;
            }
            this.lastFrame = now;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void paintFrame(int x, int y, class_2960 texture) {
        ScreenDrawing.texturedRect(x, y, this.getWidth(), this.getHeight(), texture, this.u1, this.v1, this.u2, this.v2, this.tint);
    }
}

