/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.client.TextHoverRendererScreen;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class WText
extends WWidget {
    protected class_5348 text;
    protected int color;
    protected int darkmodeColor;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    private List<class_5348> wrappedLines;
    private boolean wrappingScheduled = false;

    public WText(class_5348 text) {
        this(text, 0x404040);
    }

    public WText(class_5348 text, int color) {
        this.text = Objects.requireNonNull(text, "text must not be null");
        this.color = color;
        this.darkmodeColor = color == 0x404040 ? 0xBCBCBC : color;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.wrappingScheduled = true;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private void wrapLines() {
        class_327 font = class_310.method_1551().field_1772;
        this.wrappedLines = font.method_1728(this.text, this.width);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_2583 getTextStyleAt(int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        font.getClass();
        int lineIndex = y / 9;
        if (lineIndex >= 0 && lineIndex < this.wrappedLines.size()) {
            class_5348 line = this.wrappedLines.get(lineIndex);
            return font.method_27527().method_27489(line, x);
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        class_437 screen;
        int yOffset;
        if (this.wrappedLines == null || this.wrappingScheduled) {
            this.wrapLines();
            this.wrappingScheduled = false;
        }
        class_327 font = class_310.method_1551().field_1772;
        switch (this.verticalAlignment) {
            case CENTER: {
                int n = this.height / 2;
                font.getClass();
                yOffset = n - 9 * this.wrappedLines.size() / 2;
                break;
            }
            case BOTTOM: {
                font.getClass();
                yOffset = this.height - 9 * this.wrappedLines.size();
                break;
            }
            default: {
                yOffset = 0;
            }
        }
        for (int i = 0; i < this.wrappedLines.size(); ++i) {
            class_5348 line = this.wrappedLines.get(i);
            int c = LibGuiClient.config.darkMode ? this.darkmodeColor : this.color;
            font.getClass();
            ScreenDrawing.drawString(matrices, line, this.horizontalAlignment, x, y + yOffset + i * 9, this.width, c);
        }
        class_2583 hoveredTextStyle = this.getTextStyleAt(mouseX, mouseY);
        if (hoveredTextStyle != null && (screen = class_310.method_1551().field_1755) instanceof TextHoverRendererScreen) {
            ((TextHoverRendererScreen)screen).renderTextHover(matrices, hoveredTextStyle, x + mouseX, y + mouseY);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClick(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        class_2583 hoveredTextStyle = this.getTextStyleAt(x, y);
        if (hoveredTextStyle != null) {
            class_310.method_1551().field_1755.method_25430(hoveredTextStyle);
        }
    }

    public class_5348 getText() {
        return this.text;
    }

    public WText setText(class_5348 text) {
        Objects.requireNonNull(text, "text is null");
        this.text = text;
        this.wrappingScheduled = true;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public WText setColor(int color) {
        this.color = color;
        return this;
    }

    public int getDarkmodeColor() {
        return this.darkmodeColor;
    }

    public WText setDarkmodeColor(int darkmodeColor) {
        this.darkmodeColor = darkmodeColor;
        return this;
    }

    public WText setColor(int color, int darkmodeColor) {
        this.setColor(color);
        this.setDarkmodeColor(darkmodeColor);
        return this;
    }

    public WText disableDarkmode() {
        this.darkmodeColor = this.color;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WText setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WText setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }
}

