/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class WTextField
extends WWidget {
    public static final int OFFSET_X_TEXT = 4;
    @Environment(value=EnvType.CLIENT)
    private class_327 font;
    protected String text = "";
    protected int maxLength = 16;
    protected boolean editable = true;
    protected int enabledColor = 0xE0E0E0;
    protected int uneditableColor = 0x707070;
    @Nullable
    protected class_2561 suggestion = null;
    protected int cursor = 0;
    protected int select = -1;
    protected Consumer<String> onChanged;
    protected Predicate<String> textPredicate;
    @Nullable
    @Environment(value=EnvType.CLIENT)
    protected BackgroundPainter backgroundPainter;

    public WTextField() {
    }

    public WTextField(class_2561 suggestion) {
        this.suggestion = suggestion;
    }

    public void setText(String s) {
        if (this.textPredicate == null || this.textPredicate.test(s)) {
            String string = this.text = s.length() > this.maxLength ? s.substring(0, this.maxLength) : s;
            if (this.onChanged != null) {
                this.onChanged.accept(this.text);
            }
        }
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    public void setCursorPos(int location) {
        this.cursor = class_3532.method_15340((int)location, (int)0, (int)this.text.length());
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getCursor() {
        return this.cursor;
    }

    @Nullable
    public String getSelection() {
        if (this.select < 0) {
            return null;
        }
        if (this.select == this.cursor) {
            return null;
        }
        if (this.select > this.text.length()) {
            this.select = this.text.length();
        }
        if (this.cursor < 0) {
            this.cursor = 0;
        }
        if (this.cursor > this.text.length()) {
            this.cursor = this.text.length();
        }
        int start = Math.min(this.select, this.cursor);
        int end = Math.max(this.select, this.cursor);
        return this.text.substring(start, end);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderTextField(class_4587 matrices, int x, int y) {
        if (this.font == null) {
            this.font = class_310.method_1551().field_1772;
        }
        int borderColor = this.isFocused() ? -96 : -6250336;
        ScreenDrawing.coloredRect(x - 1, y - 1, this.width + 2, this.height + 2, borderColor);
        ScreenDrawing.coloredRect(x, y, this.width, this.height, -16777216);
        int textColor = this.editable ? this.enabledColor : this.uneditableColor;
        String trimText = this.font.method_27523(this.text, this.width - 4);
        boolean selection = this.select != -1;
        boolean focused = this.isFocused();
        int textX = x + 4;
        int textY = y + (this.height - 8) / 2;
        int adjustedCursor = this.cursor;
        if (adjustedCursor > trimText.length()) {
            adjustedCursor = trimText.length();
        }
        int preCursorAdvance = textX;
        if (!trimText.isEmpty()) {
            String string_2 = trimText.substring(0, adjustedCursor);
            preCursorAdvance = this.font.method_1720(matrices, string_2, (float)textX, (float)textY, textColor);
        }
        if (adjustedCursor < trimText.length()) {
            this.font.method_1720(matrices, trimText.substring(adjustedCursor), (float)(preCursorAdvance - 1), (float)textY, textColor);
        }
        if (this.text.length() == 0 && this.suggestion != null) {
            this.font.method_27517(matrices, (class_5348)this.suggestion, (float)textX, (float)textY, -8355712);
        }
        if (focused && !selection) {
            if (adjustedCursor < trimText.length()) {
                ScreenDrawing.coloredRect(preCursorAdvance - 1, textY - 2, 1, 12, -3092272);
            } else {
                this.font.method_1720(matrices, "_", (float)preCursorAdvance, (float)textY, textColor);
            }
        }
        if (selection) {
            int a = WTextField.getCaretOffset(this.text, this.cursor);
            int b = WTextField.getCaretOffset(this.text, this.select);
            if (b < a) {
                int tmp = b;
                b = a;
                a = tmp;
            }
            this.invertedRect(textX + a - 1, textY - 1, Math.min(b - a, this.width - 4), 12);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void invertedRect(int x, int y, int width, int height) {
        class_289 tessellator_1 = class_289.method_1348();
        class_287 bufferBuilder_1 = tessellator_1.method_1349();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((class_4493.class_1030)class_4493.class_1030.field_5110);
        bufferBuilder_1.method_1328(7, class_290.field_1592);
        bufferBuilder_1.method_22912((double)x, (double)(y + height), 0.0).method_1344();
        bufferBuilder_1.method_22912((double)(x + width), (double)(y + height), 0.0).method_1344();
        bufferBuilder_1.method_22912((double)(x + width), (double)y, 0.0).method_1344();
        bufferBuilder_1.method_22912((double)x, (double)y, 0.0).method_1344();
        tessellator_1.method_1350();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public WTextField setTextPredicate(Predicate<String> predicate_1) {
        this.textPredicate = predicate_1;
        return this;
    }

    public WTextField setChangedListener(Consumer<String> listener) {
        this.onChanged = listener;
        return this;
    }

    public WTextField setMaxLength(int max) {
        this.maxLength = max;
        if (this.text.length() > max) {
            this.text = this.text.substring(0, max);
            this.onChanged.accept(this.text);
        }
        return this;
    }

    public WTextField setEnabledColor(int col) {
        this.enabledColor = col;
        return this;
    }

    public WTextField setDisabledColor(int col) {
        this.uneditableColor = col;
        return this;
    }

    public WTextField setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Nullable
    public class_2561 getSuggestion() {
        return this.suggestion;
    }

    public WTextField setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion != null ? new class_2585(suggestion) : null;
        return this;
    }

    public WTextField setSuggestion(@Nullable class_2561 suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public WTextField setBackgroundPainter(BackgroundPainter painter) {
        this.backgroundPainter = painter;
        return this;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public void onFocusGained() {
    }

    @Override
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        this.renderTextField(matrices, x, y);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClick(int x, int y, int button) {
        this.requestFocus();
        this.cursor = WTextField.getCaretPos(this.text, x - 4);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onCharTyped(char ch) {
        if (this.text.length() < this.maxLength) {
            if (this.cursor < 0) {
                this.cursor = 0;
            }
            if (this.cursor > this.text.length()) {
                this.cursor = this.text.length();
            }
            String before = this.text.substring(0, this.cursor);
            String after = this.text.substring(this.cursor, this.text.length());
            this.text = before + ch + after;
            ++this.cursor;
        }
    }

    public void insertText(int ofs, String s) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onKeyPressed(int ch, int key, int modifiers) {
        if (!this.editable) {
            return;
        }
        if (class_437.method_25438((int)ch)) {
            String selection = this.getSelection();
            if (selection != null) {
                class_310.method_1551().field_1774.method_1455(selection);
            }
            return;
        }
        if (class_437.method_25437((int)ch)) {
            if (this.select != -1) {
                int b = this.cursor;
                int a = this.select;
                if (b < a) {
                    int tmp = b;
                    b = a;
                    a = tmp;
                }
                String before = this.text.substring(0, a);
                String after = this.text.substring(b);
                String clip = class_310.method_1551().field_1774.method_1460();
                this.text = before + clip + after;
                this.select = -1;
                this.cursor = (before + clip).length();
            } else {
                String before = this.text.substring(0, this.cursor);
                String after = this.text.substring(this.cursor, this.text.length());
                String clip = class_310.method_1551().field_1774.method_1460();
                this.text = before + clip + after;
                this.cursor += clip.length();
                if (this.text.length() > this.maxLength) {
                    this.text = this.text.substring(0, this.maxLength);
                    if (this.cursor > this.text.length()) {
                        this.cursor = this.text.length();
                    }
                }
            }
            return;
        }
        if (class_437.method_25439((int)ch)) {
            this.select = 0;
            this.cursor = this.text.length();
            return;
        }
        if (modifiers == 0) {
            if (ch == 261 || ch == 259) {
                if (this.text.length() > 0 && this.cursor > 0) {
                    if (this.select >= 0 && this.select != this.cursor) {
                        int b = this.cursor;
                        int a = this.select;
                        if (b < a) {
                            int tmp = b;
                            b = a;
                            a = tmp;
                        }
                        String before = this.text.substring(0, a);
                        String after = this.text.substring(b);
                        this.text = before + after;
                        if (this.cursor == b) {
                            this.cursor = a;
                        }
                        this.select = -1;
                    } else {
                        String before = this.text.substring(0, this.cursor);
                        String after = this.text.substring(this.cursor, this.text.length());
                        before = before.substring(0, before.length() - 1);
                        this.text = before + after;
                        --this.cursor;
                    }
                }
            } else if (ch == 263) {
                if (this.select != -1) {
                    this.cursor = Math.min(this.cursor, this.select);
                    this.select = -1;
                } else if (this.cursor > 0) {
                    --this.cursor;
                }
            } else if (ch == 262) {
                if (this.select != -1) {
                    this.cursor = Math.max(this.cursor, this.select);
                    this.select = -1;
                } else if (this.cursor < this.text.length()) {
                    ++this.cursor;
                }
            }
        } else if (modifiers == 1) {
            if (ch == 263) {
                if (this.select == -1) {
                    this.select = this.cursor;
                }
                if (this.cursor > 0) {
                    --this.cursor;
                }
                if (this.select == this.cursor) {
                    this.select = -1;
                }
            } else if (ch == 262) {
                if (this.select == -1) {
                    this.select = this.cursor;
                }
                if (this.cursor < this.text.length()) {
                    ++this.cursor;
                }
                if (this.select == this.cursor) {
                    this.select = -1;
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static int getCaretPos(String s, int x) {
        if (x <= 0) {
            return 0;
        }
        class_327 font = class_310.method_1551().field_1772;
        int lastAdvance = 0;
        for (int i = 0; i < s.length() - 1; ++i) {
            int charAdvance;
            int advance = font.method_1727(s.substring(0, i + 1));
            if (x < advance + (charAdvance = advance - lastAdvance) / 2) {
                return i + 1;
            }
            lastAdvance = advance;
        }
        return s.length();
    }

    @Environment(value=EnvType.CLIENT)
    public static int getCaretOffset(String s, int pos) {
        if (pos == 0) {
            return 0;
        }
        class_327 font = class_310.method_1551().field_1772;
        int ofs = font.method_1727(s.substring(0, pos)) + 1;
        return ofs;
    }
}

