/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.LibGuiClient;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class WToggleButton
extends WWidget {
    protected static final class_2960 DEFAULT_OFF_IMAGE = new class_2960("libgui:textures/widget/toggle_off.png");
    protected static final class_2960 DEFAULT_ON_IMAGE = new class_2960("libgui:textures/widget/toggle_on.png");
    protected static final class_2960 DEFAULT_FOCUS_IMAGE = new class_2960("libgui:textures/widget/toggle_focus.png");
    protected class_2960 onImage;
    protected class_2960 offImage;
    protected class_2960 focusImage = DEFAULT_FOCUS_IMAGE;
    @Nullable
    protected class_5348 label = null;
    protected boolean isOn = false;
    @Nullable
    protected Consumer<Boolean> onToggle = null;
    protected int color = 0x404040;
    protected int darkmodeColor = 0xBCBCBC;

    public WToggleButton() {
        this(DEFAULT_ON_IMAGE, DEFAULT_OFF_IMAGE);
    }

    public WToggleButton(class_5348 text) {
        this(DEFAULT_ON_IMAGE, DEFAULT_OFF_IMAGE);
        this.label = text;
    }

    public WToggleButton(class_2960 onImage, class_2960 offImage) {
        this.onImage = onImage;
        this.offImage = offImage;
    }

    public WToggleButton(class_2960 onImage, class_2960 offImage, class_5348 label) {
        this.onImage = onImage;
        this.offImage = offImage;
        this.label = label;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        ScreenDrawing.texturedRect(x, y, 18, 18, this.isOn ? this.onImage : this.offImage, -1);
        if (this.isFocused()) {
            ScreenDrawing.texturedRect(x, y, 18, 18, this.focusImage, -1);
        }
        if (this.label != null) {
            ScreenDrawing.drawString(matrices, this.label, x + 22, y + 6, LibGuiClient.config.darkMode ? this.darkmodeColor : this.color);
        }
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClick(int x, int y, int button) {
        super.onClick(x, y, button);
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        this.isOn = !this.isOn;
        this.onToggle(this.isOn);
    }

    @Override
    public void onKeyPressed(int ch, int key, int modifiers) {
        if (WToggleButton.isActivationKey(ch)) {
            this.onClick(0, 0, 0);
        }
    }

    protected void onToggle(boolean on) {
        if (this.onToggle != null) {
            this.onToggle.accept(on);
        }
    }

    public boolean getToggle() {
        return this.isOn;
    }

    public void setToggle(boolean on) {
        this.isOn = on;
    }

    @Nullable
    public Consumer<Boolean> getOnToggle() {
        return this.onToggle;
    }

    public WToggleButton setOnToggle(@Nullable Consumer<Boolean> onToggle) {
        this.onToggle = onToggle;
        return this;
    }

    @Nullable
    public class_5348 getLabel() {
        return this.label;
    }

    public WToggleButton setLabel(@Nullable class_5348 label) {
        this.label = label;
        return this;
    }

    public WToggleButton setColor(int light, int dark) {
        this.color = light;
        this.darkmodeColor = dark;
        return this;
    }

    public class_2960 getOnImage() {
        return this.onImage;
    }

    public WToggleButton setOnImage(class_2960 onImage) {
        this.onImage = onImage;
        return this;
    }

    public class_2960 getOffImage() {
        return this.offImage;
    }

    public WToggleButton setOffImage(class_2960 offImage) {
        this.offImage = offImage;
        return this;
    }

    public class_2960 getFocusImage() {
        return this.focusImage;
    }

    public WToggleButton setFocusImage(class_2960 focusImage) {
        this.focusImage = focusImage;
        return this;
    }
}

