/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    protected WPanel parent;
    protected int x = 0;
    protected int y = 0;
    protected int width = 18;
    protected int height = 18;
    @Nullable
    protected GuiDescription host;

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int x, int y) {
        this.width = x;
        this.height = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getAbsoluteX() {
        if (this.parent == null) {
            return this.getX();
        }
        return this.getX() + this.parent.getAbsoluteX();
    }

    public int getAbsoluteY() {
        if (this.parent == null) {
            return this.getY();
        }
        return this.getY() + this.parent.getAbsoluteY();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean canResize() {
        return false;
    }

    @Nullable
    public WPanel getParent() {
        return this.parent;
    }

    public void setParent(WPanel parent) {
        this.parent = parent;
    }

    @Environment(value=EnvType.CLIENT)
    public WWidget onMouseDown(int x, int y, int button) {
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public void onMouseDrag(int x, int y, int button, double deltaX, double deltaY) {
        this.onMouseDrag(x, y, button);
    }

    @Environment(value=EnvType.CLIENT)
    public void onMouseDrag(int x, int y, int button) {
    }

    @Environment(value=EnvType.CLIENT)
    public WWidget onMouseUp(int x, int y, int button) {
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public void onClick(int x, int y, int button) {
    }

    @Environment(value=EnvType.CLIENT)
    public void onMouseScroll(int x, int y, double amount) {
    }

    @Environment(value=EnvType.CLIENT)
    public void onMouseMove(int x, int y) {
    }

    @Environment(value=EnvType.CLIENT)
    public void onCharTyped(char ch) {
    }

    @Environment(value=EnvType.CLIENT)
    public void onKeyPressed(int ch, int key, int modifiers) {
    }

    @Environment(value=EnvType.CLIENT)
    public void onKeyReleased(int ch, int key, int modifiers) {
    }

    public void onFocusGained() {
    }

    public void onFocusLost() {
    }

    public boolean isFocused() {
        if (this.host == null) {
            return false;
        }
        return this.host.isFocused(this);
    }

    public void requestFocus() {
        if (this.host != null) {
            this.host.requestFocus(this);
        } else {
            LOGGER.warn("Requesting focus for {}, but the host is null", (Object)this);
        }
    }

    public void releaseFocus() {
        if (this.host != null) {
            this.host.releaseFocus(this);
        }
    }

    public boolean canFocus() {
        return false;
    }

    @Deprecated
    public void createPeers(GuiDescription c) {
    }

    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderTooltip(class_4587 matrices, int x, int y, int tX, int tY) {
        ArrayList<class_5348> info = new ArrayList<class_5348>();
        this.addTooltip(info);
        if (info.size() == 0) {
            return;
        }
        class_437 screen = class_310.method_1551().field_1755;
        screen.method_25417(matrices, info, tX + x, tY + y);
    }

    public void validate(GuiDescription host) {
        this.host = host;
    }

    @Nullable
    public final GuiDescription getHost() {
        return this.host;
    }

    public void setHost(@Nullable GuiDescription host) {
        this.host = host;
    }

    public void addTooltip(List<class_5348> tooltip) {
    }

    public WWidget hit(int x, int y) {
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public void tick() {
    }

    @Nullable
    public WWidget cycleFocus(boolean lookForwards) {
        return this.canFocus() ? (this.isFocused() ? null : this) : null;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isActivationKey(int ch) {
        return ch == 257 || ch == 335 || ch == 32;
    }
}

